/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.continuous;

import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingMonitorType;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingPolicy;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingPolicyConfiguration;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingTargetType;
import org.apache.skywalking.oap.server.core.query.input.ContinuousProfilingPolicyCreation;
import org.apache.skywalking.oap.server.core.query.input.ContinuousProfilingPolicyItemCreation;
import org.apache.skywalking.oap.server.core.query.input.ContinuousProfilingPolicyTargetCreation;
import org.apache.skywalking.oap.server.core.query.type.ContinuousProfilingSetResult;
import org.apache.skywalking.oap.server.core.storage.profiling.continuous.IContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class ContinuousProfilingMutationService
implements Service {
    private static final Gson GSON = new Gson();
    private final ModuleManager moduleManager;
    private IContinuousProfilingPolicyDAO policyDAO;

    public IContinuousProfilingPolicyDAO getPolicyDAO() {
        if (this.policyDAO == null) {
            this.policyDAO = (IContinuousProfilingPolicyDAO)this.moduleManager.find("storage").provider().getService(IContinuousProfilingPolicyDAO.class);
        }
        return this.policyDAO;
    }

    public ContinuousProfilingSetResult setContinuousProfilingPolicy(ContinuousProfilingPolicyCreation request) throws IOException {
        String validateTarget;
        if (StringUtil.isEmpty((String)request.getServiceId())) {
            return this.buildError("the service id cannot be empty");
        }
        if (CollectionUtils.isNotEmpty(request.getTargets()) && StringUtil.isNotEmpty((String)(validateTarget = this.validateTargets(request.getTargets())))) {
            return this.buildError(validateTarget);
        }
        ContinuousProfilingPolicyConfiguration configuration = ContinuousProfilingPolicyConfiguration.buildFromRequest(request);
        String configurationJSON = GSON.toJson((Object)configuration);
        ContinuousProfilingPolicy policy = new ContinuousProfilingPolicy();
        policy.setServiceId(request.getServiceId());
        policy.setUuid(Hashing.sha512().hashString((CharSequence)configurationJSON, StandardCharsets.UTF_8).toString());
        policy.setConfigurationJson(configurationJSON);
        this.getPolicyDAO().savePolicy(policy);
        return this.buildSaveSuccess();
    }

    private String validateTargets(List<ContinuousProfilingPolicyTargetCreation> targets) {
        HashSet<ContinuousProfilingTargetType> targetCache = new HashSet<ContinuousProfilingTargetType>();
        for (ContinuousProfilingPolicyTargetCreation target : targets) {
            ContinuousProfilingTargetType targetType = target.getTargetType();
            if (targetCache.contains((Object)targetType)) {
                return "contains multiple same target type: " + targetType;
            }
            targetCache.add(targetType);
            HashSet<ContinuousProfilingMonitorType> monitorTypeCache = new HashSet<ContinuousProfilingMonitorType>();
            for (ContinuousProfilingPolicyItemCreation item : target.getCheckItems()) {
                if (monitorTypeCache.contains((Object)item.getType())) {
                    return "contains multiple same monitor type " + item.getType() + " in " + targetType;
                }
                monitorTypeCache.add(item.getType());
                String itemCheck = this.validatePolicyItem(item);
                if (!StringUtil.isNotEmpty((String)itemCheck)) continue;
                return "check " + item.getType() + " in " + targetType + " error: " + itemCheck;
            }
        }
        return null;
    }

    private String validatePolicyItem(ContinuousProfilingPolicyItemCreation item) {
        String timeWindowsValidate = this.validatePolicyItemWindows(item);
        if (StringUtil.isNotEmpty((String)timeWindowsValidate)) {
            return timeWindowsValidate;
        }
        try {
            switch (item.getType()) {
                case PROCESS_CPU: {
                    int cpuPercent = Integer.parseInt(item.getThreshold());
                    if (cpuPercent >= 0 && cpuPercent <= 100) break;
                    return "the process CPU percent should in [0-100]";
                }
                case PROCESS_THREAD_COUNT: {
                    int threadCount = Integer.parseInt(item.getThreshold());
                    if (threadCount >= 0) break;
                    return "the process thread count must bigger than zero";
                }
                case SYSTEM_LOAD: {
                    int systemLoad = Integer.parseInt(item.getThreshold());
                    if (systemLoad >= 0) break;
                    return "the system load must bigger than zero";
                }
                case HTTP_ERROR_RATE: {
                    int httpErrorRate = Integer.parseInt(item.getThreshold());
                    if (httpErrorRate >= 0 && httpErrorRate <= 100) break;
                    return "the HTTP error rate should in [0-100]";
                }
                case HTTP_AVG_RESPONSE_TIME: {
                    int httpAvgResponseTime = Integer.parseInt(item.getThreshold());
                    if (httpAvgResponseTime >= 0) break;
                    return "the HTTP average response time must bigger than zero";
                }
            }
        }
        catch (NumberFormatException e) {
            return "parsing threshold error";
        }
        return null;
    }

    private String validatePolicyItemWindows(ContinuousProfilingPolicyItemCreation item) {
        if (item.getPeriod() <= 0) {
            return "period must bigger than zero";
        }
        if (item.getCount() < 0) {
            return "count must bigger than zero";
        }
        if (item.getCount() > item.getPeriod()) {
            return "count must be small than period";
        }
        return null;
    }

    private ContinuousProfilingSetResult buildError(String message) {
        return ContinuousProfilingSetResult.builder().status(false).errorReason(message).build();
    }

    private ContinuousProfilingSetResult buildSaveSuccess() {
        return ContinuousProfilingSetResult.builder().status(true).build();
    }

    @Generated
    public ContinuousProfilingMutationService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

