/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.cache;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.DisableRegister;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.networkalias.NetworkAddressAlias;
import org.apache.skywalking.oap.server.core.cache.AsyncProfilerTaskCache;
import org.apache.skywalking.oap.server.core.cache.NetworkAddressAliasCache;
import org.apache.skywalking.oap.server.core.cache.ProfileTaskCache;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTask;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.RunnableWithExceptionProtection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CacheUpdateTimer {
    INSTANCE;

    @Generated
    private static final Logger log;
    private AsyncProfilerTaskCache asyncProfilerTaskCache;
    private IAsyncProfilerTaskQueryDAO asyncProfilerTaskQueryDAO;
    private int ttl = 10;

    public void start(ModuleDefineHolder moduleDefineHolder, int ttl) {
        log.info("Cache updateServiceInventory timer start");
        long timeInterval = 10L;
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate((Runnable)new RunnableWithExceptionProtection(() -> this.update(moduleDefineHolder), t -> log.error("Cache update failure.", t)), 1L, 10L, TimeUnit.SECONDS);
        this.ttl = ttl;
    }

    private void update(ModuleDefineHolder moduleDefineHolder) {
        this.updateNetAddressAliasCache(moduleDefineHolder);
        if (!DisableRegister.INSTANCE.include("profile_task")) {
            this.updateProfileTask(moduleDefineHolder);
        }
        if (!DisableRegister.INSTANCE.include("async_profiler_task")) {
            this.updateAsyncProfilerTask(moduleDefineHolder);
        }
    }

    private void updateNetAddressAliasCache(ModuleDefineHolder moduleDefineHolder) {
        INetworkAddressAliasDAO networkAddressAliasDAO = (INetworkAddressAliasDAO)moduleDefineHolder.find("storage").provider().getService(INetworkAddressAliasDAO.class);
        NetworkAddressAliasCache addressInventoryCache = (NetworkAddressAliasCache)moduleDefineHolder.find("core").provider().getService(NetworkAddressAliasCache.class);
        long loadStartTime = addressInventoryCache.currentSize() == 0L ? TimeBucket.getMinuteTimeBucket(System.currentTimeMillis() - 86400000L * (long)this.ttl) : TimeBucket.getMinuteTimeBucket(System.currentTimeMillis() - 600000L);
        List<NetworkAddressAlias> addressInventories = networkAddressAliasDAO.loadLastUpdate(loadStartTime);
        addressInventoryCache.load(addressInventories);
    }

    private void updateProfileTask(ModuleDefineHolder moduleDefineHolder) {
        IProfileTaskQueryDAO profileTaskQueryDAO = (IProfileTaskQueryDAO)moduleDefineHolder.find("storage").provider().getService(IProfileTaskQueryDAO.class);
        ProfileTaskCache profileTaskCache = (ProfileTaskCache)moduleDefineHolder.find("core").provider().getService(ProfileTaskCache.class);
        try {
            List<ProfileTask> taskList = profileTaskQueryDAO.getTaskList(null, null, profileTaskCache.getCacheStartTimeBucket(), profileTaskCache.getCacheEndTimeBucket(), null);
            taskList.stream().collect(Collectors.groupingBy(t -> t.getServiceId())).entrySet().stream().forEach(e -> {
                String serviceId = (String)e.getKey();
                List profileTasks = (List)e.getValue();
                profileTaskCache.saveTaskList(serviceId, profileTasks);
            });
        }
        catch (IOException e2) {
            log.warn("Unable to update profile task cache", (Throwable)e2);
        }
    }

    private AsyncProfilerTaskCache getAsyncProfilerTaskCache(ModuleDefineHolder moduleDefineHolder) {
        if (this.asyncProfilerTaskCache == null) {
            this.asyncProfilerTaskCache = (AsyncProfilerTaskCache)moduleDefineHolder.find("core").provider().getService(AsyncProfilerTaskCache.class);
        }
        return this.asyncProfilerTaskCache;
    }

    private IAsyncProfilerTaskQueryDAO getAsyncProfilerTaskQueryDAO(ModuleDefineHolder moduleDefineHolder) {
        if (this.asyncProfilerTaskQueryDAO == null) {
            this.asyncProfilerTaskQueryDAO = (IAsyncProfilerTaskQueryDAO)moduleDefineHolder.find("storage").provider().getService(IAsyncProfilerTaskQueryDAO.class);
        }
        return this.asyncProfilerTaskQueryDAO;
    }

    private void updateAsyncProfilerTask(ModuleDefineHolder moduleDefineHolder) {
        AsyncProfilerTaskCache taskCache = this.getAsyncProfilerTaskCache(moduleDefineHolder);
        IAsyncProfilerTaskQueryDAO taskQueryDAO = this.getAsyncProfilerTaskQueryDAO(moduleDefineHolder);
        try {
            List<AsyncProfilerTask> taskList = taskQueryDAO.getTaskList(null, taskCache.getCacheStartTimeBucket(), taskCache.getCacheEndTimeBucket(), null);
            if (CollectionUtils.isEmpty(taskList)) {
                return;
            }
            for (AsyncProfilerTask task : taskList) {
                taskCache.saveTask(task.getServiceId(), task);
            }
        }
        catch (IOException e) {
            log.warn("Unable to update async profiler task cache", (Throwable)e);
        }
    }

    static {
        log = LoggerFactory.getLogger(CacheUpdateTimer.class);
    }
}

