/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.utils;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class NetUtil {
    private static final int DEFAULT_TIMEOUT_IN_SECONDS = 5000;

    public static boolean pingUrl(String address) {
        try {
            URL urlObj = new URL(address);
            HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int statusCode = connection.getResponseCode();
            NetUtil.cleanUpConnection(connection);
            return 200 <= statusCode && statusCode <= 399;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpConnection(HttpURLConnection conn) {
        InputStreamReader isr = null;
        InputStreamReader esr = null;
        try {
            isr = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);
            CharStreams.toString((Readable)isr);
        }
        catch (IOException e) {
            InputStream errorStream = conn.getErrorStream();
            if (errorStream != null) {
                esr = new InputStreamReader(errorStream, StandardCharsets.UTF_8);
                try {
                    CharStreams.toString((Readable)esr);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (esr != null) {
                try {
                    esr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

