/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.dsl;

import com.google.common.collect.ImmutableList;
import groovy.lang.GString;
import groovy.lang.GroovyShell;
import groovy.transform.CompileStatic;
import groovy.util.DelegatingScript;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.log.analyzer.dsl.Binding;
import org.apache.skywalking.oap.log.analyzer.dsl.LALPrecompiledExtension;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.LALDelegatingScript;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.filter.FilterSpec;
import org.apache.skywalking.oap.log.analyzer.provider.LogAnalyzerModuleConfig;
import org.apache.skywalking.oap.meter.analyzer.dsl.registry.ProcessRegistry;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;

public class DSL {
    private final DelegatingScript script;
    private final FilterSpec filterSpec;

    public static DSL of(ModuleManager moduleManager, LogAnalyzerModuleConfig config, String dsl) throws ModuleStartException {
        CompilerConfiguration cc = new CompilerConfiguration();
        ASTTransformationCustomizer customizer = new ASTTransformationCustomizer(Collections.singletonMap("extensions", Collections.singletonList(LALPrecompiledExtension.class.getName())), CompileStatic.class);
        cc.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
        SecureASTCustomizer secureASTCustomizer = new SecureASTCustomizer();
        secureASTCustomizer.setDisallowedStatements((List)ImmutableList.builder().add(WhileStatement.class).add(DoWhileStatement.class).add(ForStatement.class).build());
        secureASTCustomizer.setAllowedReceiversClasses((List)ImmutableList.builder().add(Object.class).add(Map.class).add(List.class).add(Array.class).add(GString.class).add(String.class).add(ProcessRegistry.class).build());
        cc.addCompilationCustomizers(new CompilationCustomizer[]{secureASTCustomizer});
        cc.setScriptBaseClass(LALDelegatingScript.class.getName());
        ImportCustomizer icz = new ImportCustomizer();
        icz.addImport("ProcessRegistry", ProcessRegistry.class.getName());
        cc.addCompilationCustomizers(new CompilationCustomizer[]{icz});
        GroovyShell sh = new GroovyShell(cc);
        DelegatingScript script = (DelegatingScript)sh.parse(dsl);
        FilterSpec filterSpec = new FilterSpec(moduleManager, config);
        script.setDelegate((Object)filterSpec);
        return new DSL(script, filterSpec);
    }

    public void bind(Binding binding) {
        this.filterSpec.bind(binding);
    }

    public void evaluate() {
        this.script.run();
    }

    @Generated
    private DSL(DelegatingScript script, FilterSpec filterSpec) {
        this.script = script;
        this.filterSpec = filterSpec;
    }
}

