/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.fetching;

import graphql.Internal;
import graphql.VisibleForTesting;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Internal
public class LambdaFetchingSupport {
    public static Optional<Function<Object, Object>> createGetter(Class<?> sourceClass, String propertyName) {
        Method candidateMethod = LambdaFetchingSupport.getCandidateMethod(sourceClass, propertyName);
        if (candidateMethod != null) {
            try {
                Function<Object, Object> getterFunction = LambdaFetchingSupport.mkCallFunction(sourceClass, candidateMethod.getName(), candidateMethod.getReturnType());
                return Optional.of(getterFunction);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static Method getCandidateMethod(Class<?> sourceClass, String propertyName) {
        Predicate<Method> recordLikePredicate = method -> LambdaFetchingSupport.isRecordLike(method) && propertyName.equals(LambdaFetchingSupport.decapitalize(method.getName()));
        List<Method> recordLikeMethods = LambdaFetchingSupport.findMethodsForProperty(sourceClass, recordLikePredicate);
        if (!recordLikeMethods.isEmpty()) {
            return recordLikeMethods.get(0);
        }
        Predicate<Method> getterPredicate = method -> LambdaFetchingSupport.isGetterNamed(method) && propertyName.equals(LambdaFetchingSupport.mkPropertyNameGetter(method));
        List<Method> allGetterMethods = LambdaFetchingSupport.findMethodsForProperty(sourceClass, getterPredicate);
        List<Method> pojoGetterMethods = allGetterMethods.stream().filter(LambdaFetchingSupport::isPossiblePojoMethod).collect(Collectors.toList());
        if (!pojoGetterMethods.isEmpty()) {
            Method method2 = (Method)pojoGetterMethods.get(0);
            if (LambdaFetchingSupport.isBooleanGetter(method2)) {
                method2 = LambdaFetchingSupport.findBestBooleanGetter(pojoGetterMethods);
            }
            return LambdaFetchingSupport.checkForSingleParameterPeer(method2, allGetterMethods);
        }
        return null;
    }

    private static Method checkForSingleParameterPeer(Method candidateMethod, List<Method> allMethods) {
        for (Method allMethod : allMethods) {
            if (allMethod.getParameterCount() <= 0) continue;
            return null;
        }
        return candidateMethod;
    }

    private static Method findBestBooleanGetter(List<Method> methods) {
        Optional<Method> isMethod = methods.stream().filter(method -> method.getName().startsWith("is")).findFirst();
        return isMethod.orElse(methods.get(0));
    }

    private static List<Method> findMethodsForProperty(Class<?> sourceClass, Predicate<Method> predicate) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> currentClass = sourceClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = currentClass.getDeclaredMethods()) {
                if (!predicate.test(declaredMethod)) continue;
                methods.add(declaredMethod);
            }
        }
        return methods.stream().sorted(Comparator.comparing(Method::getName)).collect(Collectors.toList());
    }

    private static boolean isPossiblePojoMethod(Method method) {
        return !LambdaFetchingSupport.isObjectMethod(method) && LambdaFetchingSupport.returnsSomething(method) && LambdaFetchingSupport.isGetterNamed(method) && LambdaFetchingSupport.hasNoParameters(method) && LambdaFetchingSupport.isPublic(method);
    }

    private static boolean isRecordLike(Method method) {
        return !LambdaFetchingSupport.isObjectMethod(method) && LambdaFetchingSupport.returnsSomething(method) && LambdaFetchingSupport.hasNoParameters(method) && LambdaFetchingSupport.isPublic(method);
    }

    private static boolean isBooleanGetter(Method method) {
        Class<?> returnType = method.getReturnType();
        return LambdaFetchingSupport.isGetterNamed(method) && (returnType.equals(Boolean.class) || returnType.equals(Boolean.TYPE));
    }

    private static boolean hasNoParameters(Method method) {
        return method.getParameterCount() == 0;
    }

    private static boolean isGetterNamed(Method method) {
        String name = method.getName();
        return name.startsWith("get") && name.length() > 4 || name.startsWith("is") && name.length() > 3;
    }

    private static boolean returnsSomething(Method method) {
        return !method.getReturnType().equals(Void.class);
    }

    private static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    private static boolean isObjectMethod(Method method) {
        return method.getDeclaringClass().equals(Object.class);
    }

    private static String mkPropertyNameGetter(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.substring(3);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
        }
        return LambdaFetchingSupport.decapitalize(name);
    }

    private static String decapitalize(String name) {
        if (name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    @VisibleForTesting
    static Function<Object, Object> mkCallFunction(Class<?> targetClass, String targetMethod, Class<?> targetMethodReturnType) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFetchingSupport.getLookup(targetClass);
        MethodHandle virtualMethodHandle = lookup.findVirtual(targetClass, targetMethod, MethodType.methodType(targetMethodReturnType));
        CallSite site = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), virtualMethodHandle, MethodType.methodType(targetMethodReturnType, targetClass));
        Function getterFunction = site.getTarget().invokeExact();
        return getterFunction;
    }

    private static MethodHandles.Lookup getLookup(Class<?> targetClass) {
        MethodHandles.Lookup lookupMe = MethodHandles.lookup();
        try {
            return MethodHandles.privateLookupIn(targetClass, lookupMe);
        }
        catch (IllegalAccessException e) {
            return lookupMe;
        }
    }
}

