/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.common.stream.FixedStreamMessage;
import com.linecorp.armeria.internal.common.stream.NoopSubscription;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@UnstableApi
public class EmptyFixedStreamMessage<T>
extends FixedStreamMessage<T> {
    @Override
    public boolean isComplete() {
        return this.whenComplete().isDone();
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        if (executor.inEventLoop()) {
            this.subscribe0(subscriber);
        } else {
            executor.execute(() -> this.subscribe0(subscriber));
        }
    }

    private void subscribe0(Subscriber<? super T> subscriber) {
        subscriber.onSubscribe((Subscription)NoopSubscription.get());
        subscriber.onComplete();
        this.whenComplete().complete(null);
    }

    @Override
    public CompletableFuture<List<T>> collect(EventExecutor executor, SubscriptionOption ... options) {
        this.whenComplete().complete(null);
        return UnmodifiableFuture.completedFuture(ImmutableList.of());
    }

    @Override
    public final boolean isEmpty() {
        return true;
    }

    @Override
    public long demand() {
        return 0L;
    }

    @Override
    final void cleanupObjects(@Nullable Throwable cause) {
    }

    @Override
    protected final List<T> drainAll(boolean withPooledObjects) {
        return ImmutableList.of();
    }

    public void request(long n) {
    }

    @Override
    public void cancel() {
        this.whenComplete().complete(null);
    }

    @Override
    public void abort() {
        this.whenComplete().complete(null);
    }

    @Override
    public void abort(Throwable cause) {
        this.whenComplete().complete(null);
    }
}

