/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.acl.Role;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Role", generator="Immutables")
@Immutable
public final class ImmutableRole
extends Role {
    private final String name;
    @Nullable
    private final String id;
    @Nullable
    private final String description;
    private final ImmutableList<Role.RolePolicyLink> policies;
    private final ImmutableList<Role.RoleServiceIdentity> serviceIdentities;
    private final ImmutableList<Role.RoleNodeIdentity> nodeIdentities;
    @Nullable
    private final String namespace;

    private ImmutableRole(String name, @Nullable String id, @Nullable String description, ImmutableList<Role.RolePolicyLink> policies, ImmutableList<Role.RoleServiceIdentity> serviceIdentities, ImmutableList<Role.RoleNodeIdentity> nodeIdentities, @Nullable String namespace) {
        this.name = name;
        this.id = id;
        this.description = description;
        this.policies = policies;
        this.serviceIdentities = serviceIdentities;
        this.nodeIdentities = nodeIdentities;
        this.namespace = namespace;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="Description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @JsonProperty(value="Policies")
    @JsonDeserialize(as=ImmutableList.class, contentAs=Role.RolePolicyLink.class)
    public ImmutableList<Role.RolePolicyLink> policies() {
        return this.policies;
    }

    @JsonProperty(value="ServiceIdentities")
    @JsonDeserialize(as=ImmutableList.class, contentAs=Role.RoleServiceIdentity.class)
    public ImmutableList<Role.RoleServiceIdentity> serviceIdentities() {
        return this.serviceIdentities;
    }

    @JsonProperty(value="NodeIdentities")
    @JsonDeserialize(as=ImmutableList.class, contentAs=Role.RoleNodeIdentity.class)
    public ImmutableList<Role.RoleNodeIdentity> nodeIdentities() {
        return this.nodeIdentities;
    }

    @Override
    @JsonProperty(value="Namespace")
    public Optional<String> namespace() {
        return Optional.ofNullable(this.namespace);
    }

    public final ImmutableRole withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRole(newValue, this.id, this.description, this.policies, this.serviceIdentities, this.nodeIdentities, this.namespace);
    }

    public final ImmutableRole withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableRole(this.name, newValue, this.description, this.policies, this.serviceIdentities, this.nodeIdentities, this.namespace);
    }

    public final ImmutableRole withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableRole(this.name, value, this.description, this.policies, this.serviceIdentities, this.nodeIdentities, this.namespace);
    }

    public final ImmutableRole withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableRole(this.name, this.id, newValue, this.policies, this.serviceIdentities, this.nodeIdentities, this.namespace);
    }

    public final ImmutableRole withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableRole(this.name, this.id, value, this.policies, this.serviceIdentities, this.nodeIdentities, this.namespace);
    }

    public final ImmutableRole withPolicies(Role.RolePolicyLink ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRole(this.name, this.id, this.description, (ImmutableList<Role.RolePolicyLink>)newValue, this.serviceIdentities, this.nodeIdentities, this.namespace);
    }

    public final ImmutableRole withPolicies(Iterable<? extends Role.RolePolicyLink> elements) {
        if (this.policies == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRole(this.name, this.id, this.description, (ImmutableList<Role.RolePolicyLink>)newValue, this.serviceIdentities, this.nodeIdentities, this.namespace);
    }

    public final ImmutableRole withServiceIdentities(Role.RoleServiceIdentity ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRole(this.name, this.id, this.description, this.policies, (ImmutableList<Role.RoleServiceIdentity>)newValue, this.nodeIdentities, this.namespace);
    }

    public final ImmutableRole withServiceIdentities(Iterable<? extends Role.RoleServiceIdentity> elements) {
        if (this.serviceIdentities == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRole(this.name, this.id, this.description, this.policies, (ImmutableList<Role.RoleServiceIdentity>)newValue, this.nodeIdentities, this.namespace);
    }

    public final ImmutableRole withNodeIdentities(Role.RoleNodeIdentity ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRole(this.name, this.id, this.description, this.policies, this.serviceIdentities, (ImmutableList<Role.RoleNodeIdentity>)newValue, this.namespace);
    }

    public final ImmutableRole withNodeIdentities(Iterable<? extends Role.RoleNodeIdentity> elements) {
        if (this.nodeIdentities == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRole(this.name, this.id, this.description, this.policies, this.serviceIdentities, (ImmutableList<Role.RoleNodeIdentity>)newValue, this.namespace);
    }

    public final ImmutableRole withNamespace(String value) {
        String newValue = Objects.requireNonNull(value, "namespace");
        if (Objects.equals(this.namespace, newValue)) {
            return this;
        }
        return new ImmutableRole(this.name, this.id, this.description, this.policies, this.serviceIdentities, this.nodeIdentities, newValue);
    }

    public final ImmutableRole withNamespace(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.namespace, value)) {
            return this;
        }
        return new ImmutableRole(this.name, this.id, this.description, this.policies, this.serviceIdentities, this.nodeIdentities, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRole && this.equalTo((ImmutableRole)another);
    }

    private boolean equalTo(ImmutableRole another) {
        return this.name.equals(another.name) && Objects.equals(this.id, another.id) && Objects.equals(this.description, another.description) && this.policies.equals(another.policies) && this.serviceIdentities.equals(another.serviceIdentities) && this.nodeIdentities.equals(another.nodeIdentities) && Objects.equals(this.namespace, another.namespace);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.policies.hashCode();
        h += (h << 5) + this.serviceIdentities.hashCode();
        h += (h << 5) + this.nodeIdentities.hashCode();
        h += (h << 5) + Objects.hashCode(this.namespace);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Role").omitNullValues().add("name", (Object)this.name).add("id", (Object)this.id).add("description", (Object)this.description).add("policies", this.policies).add("serviceIdentities", this.serviceIdentities).add("nodeIdentities", this.nodeIdentities).add("namespace", (Object)this.namespace).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRole fromJson(Json json) {
        Builder builder = ImmutableRole.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.policies != null) {
            builder.addAllPolicies(json.policies);
        }
        if (json.serviceIdentities != null) {
            builder.addAllServiceIdentities(json.serviceIdentities);
        }
        if (json.nodeIdentities != null) {
            builder.addAllNodeIdentities(json.nodeIdentities);
        }
        if (json.namespace != null) {
            builder.namespace(json.namespace);
        }
        return builder.build();
    }

    public static ImmutableRole copyOf(Role instance) {
        if (instance instanceof ImmutableRole) {
            return (ImmutableRole)instance;
        }
        return ImmutableRole.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Role", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        @Nullable
        private String id;
        @Nullable
        private String description;
        private ImmutableList.Builder<Role.RolePolicyLink> policies = ImmutableList.builder();
        private ImmutableList.Builder<Role.RoleServiceIdentity> serviceIdentities = ImmutableList.builder();
        private ImmutableList.Builder<Role.RoleNodeIdentity> nodeIdentities = ImmutableList.builder();
        @Nullable
        private String namespace;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Role instance) {
            Optional<String> descriptionOptional;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            if ((descriptionOptional = instance.description()).isPresent()) {
                this.description(descriptionOptional);
            }
            this.addAllPolicies(instance.policies());
            this.addAllServiceIdentities(instance.serviceIdentities());
            this.addAllNodeIdentities(instance.nodeIdentities());
            Optional<String> namespaceOptional = instance.namespace();
            if (namespaceOptional.isPresent()) {
                this.namespace(namespaceOptional);
            }
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="Description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPolicies(Role.RolePolicyLink element) {
            this.policies.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPolicies(Role.RolePolicyLink ... elements) {
            this.policies.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Policies")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Role.RolePolicyLink.class)
        @CanIgnoreReturnValue
        public final Builder policies(Iterable<? extends Role.RolePolicyLink> elements) {
            this.policies = ImmutableList.builder();
            return this.addAllPolicies(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPolicies(Iterable<? extends Role.RolePolicyLink> elements) {
            this.policies.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceIdentities(Role.RoleServiceIdentity element) {
            this.serviceIdentities.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceIdentities(Role.RoleServiceIdentity ... elements) {
            this.serviceIdentities.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="ServiceIdentities")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Role.RoleServiceIdentity.class)
        @CanIgnoreReturnValue
        public final Builder serviceIdentities(Iterable<? extends Role.RoleServiceIdentity> elements) {
            this.serviceIdentities = ImmutableList.builder();
            return this.addAllServiceIdentities(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllServiceIdentities(Iterable<? extends Role.RoleServiceIdentity> elements) {
            this.serviceIdentities.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodeIdentities(Role.RoleNodeIdentity element) {
            this.nodeIdentities.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodeIdentities(Role.RoleNodeIdentity ... elements) {
            this.nodeIdentities.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="NodeIdentities")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Role.RoleNodeIdentity.class)
        @CanIgnoreReturnValue
        public final Builder nodeIdentities(Iterable<? extends Role.RoleNodeIdentity> elements) {
            this.nodeIdentities = ImmutableList.builder();
            return this.addAllNodeIdentities(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNodeIdentities(Iterable<? extends Role.RoleNodeIdentity> elements) {
            this.nodeIdentities.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(String namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            return this;
        }

        @JsonProperty(value="Namespace")
        @CanIgnoreReturnValue
        public final Builder namespace(Optional<String> namespace) {
            this.namespace = namespace.orElse(null);
            return this;
        }

        public ImmutableRole build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRole(this.name, this.id, this.description, this.policies.build(), this.serviceIdentities.build(), this.nodeIdentities.build(), this.namespace);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Role, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Role", generator="Immutables")
    static final class Json
    extends Role {
        @Nullable
        String name;
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        List<Role.RolePolicyLink> policies = ImmutableList.of();
        @Nullable
        List<Role.RoleServiceIdentity> serviceIdentities = ImmutableList.of();
        @Nullable
        List<Role.RoleNodeIdentity> nodeIdentities = ImmutableList.of();
        @Nullable
        Optional<String> namespace = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="ID")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="Description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="Policies")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Role.RolePolicyLink.class)
        public void setPolicies(List<Role.RolePolicyLink> policies) {
            this.policies = policies;
        }

        @JsonProperty(value="ServiceIdentities")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Role.RoleServiceIdentity.class)
        public void setServiceIdentities(List<Role.RoleServiceIdentity> serviceIdentities) {
            this.serviceIdentities = serviceIdentities;
        }

        @JsonProperty(value="NodeIdentities")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Role.RoleNodeIdentity.class)
        public void setNodeIdentities(List<Role.RoleNodeIdentity> nodeIdentities) {
            this.nodeIdentities = nodeIdentities;
        }

        @JsonProperty(value="Namespace")
        public void setNamespace(Optional<String> namespace) {
            this.namespace = namespace;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Role.RolePolicyLink> policies() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Role.RoleServiceIdentity> serviceIdentities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Role.RoleNodeIdentity> nodeIdentities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> namespace() {
            throw new UnsupportedOperationException();
        }
    }
}

