/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.AbstractCriteria;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntList;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBTopologyQueryDAO
extends AbstractBanyanDBDAO
implements ITopologyQueryDAO {
    public BanyanDBTopologyQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(Duration duration, List<String> serviceIds) throws IOException {
        if (CollectionUtils.isEmpty(serviceIds)) {
            throw new UnexpectedException("Service id is empty");
        }
        AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> queryBuilder = this.buildServiceRelationsQuery(serviceIds);
        return this.queryServiceRelation(duration, queryBuilder, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(Duration duration, List<String> serviceIds) throws IOException {
        if (CollectionUtils.isEmpty(serviceIds)) {
            throw new UnexpectedException("Service id is empty");
        }
        AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> queryBuilder = this.buildServiceRelationsQuery(serviceIds);
        return this.queryServiceRelation(duration, queryBuilder, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(Duration duration) throws IOException {
        return this.queryServiceRelation(duration, BanyanDBTopologyQueryDAO.emptyMeasureQuery(), DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(Duration duration) throws IOException {
        return this.queryServiceRelation(duration, BanyanDBTopologyQueryDAO.emptyMeasureQuery(), DetectPoint.CLIENT);
    }

    private AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> buildServiceRelationsQuery(final List<String> serviceIds) {
        return new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.or(this.in("source_service_id", serviceIds)).or(this.in("dest_service_id", serviceIds));
                query.groupBy((Set)Sets.newLinkedHashSet(Arrays.asList("entity_id", "component_ids")));
            }
        };
    }

    List<Call.CallDetail> queryServiceRelation(Duration duration, AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> queryBuilder, DetectPoint detectPoint) throws IOException {
        String modelName;
        MetadataRegistry.Schema schema;
        MeasureQueryResponse resp;
        long startTB = 0L;
        long endTB = 0L;
        if (Objects.nonNull(duration)) {
            startTB = duration.getStartTimeBucketInSec();
            endTB = duration.getEndTimeBucketInSec();
        }
        TimestampRange timestampRange = null;
        if (startTB > 0L && endTB > 0L) {
            timestampRange = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
        }
        if ((resp = this.queryDebuggable(schema = MetadataRegistry.INSTANCE.findMetadata(modelName = detectPoint == DetectPoint.SERVER ? "service_relation_server_side" : "service_relation_client_side", duration.getStep()), (Set<String>)ImmutableSet.of((Object)"component_ids", (Object)"entity_id"), Collections.emptySet(), timestampRange, queryBuilder)).size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>(resp.size());
        for (DataPoint dataPoint : resp.getDataPoints()) {
            String entityId = (String)dataPoint.getTagValue("entity_id");
            IntList componentIds = new IntList((String)dataPoint.getTagValue("component_ids"));
            for (int i = 0; i < componentIds.size(); ++i) {
                Call.CallDetail call = new Call.CallDetail();
                call.buildFromServiceRelation(entityId, componentIds.get(i), detectPoint);
                calls.add(call);
            }
        }
        return calls;
    }

    public List<Call.CallDetail> loadInstanceRelationDetectedAtServerSide(String clientServiceId, String serverServiceId, Duration duration) throws IOException {
        AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> queryBuilder = this.buildInstanceRelationsQuery(clientServiceId, serverServiceId);
        return this.queryInstanceRelation(duration, queryBuilder, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadInstanceRelationDetectedAtClientSide(String clientServiceId, String serverServiceId, Duration duration) throws IOException {
        AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> queryBuilder = this.buildInstanceRelationsQuery(clientServiceId, serverServiceId);
        return this.queryInstanceRelation(duration, queryBuilder, DetectPoint.CLIENT);
    }

    private AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> buildInstanceRelationsQuery(final String clientServiceId, final String serverServiceId) {
        return new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                ArrayList<AbstractCriteria> instanceRelationsQueryConditions = new ArrayList<AbstractCriteria>(2);
                instanceRelationsQueryConditions.add(this.and(Lists.newArrayList((Object[])new PairQueryCondition[]{this.eq("source_service_id", clientServiceId), this.eq("dest_service_id", serverServiceId)})));
                instanceRelationsQueryConditions.add(this.and(Lists.newArrayList((Object[])new PairQueryCondition[]{this.eq("dest_service_id", clientServiceId), this.eq("source_service_id", serverServiceId)})));
                query.criteria(this.or(instanceRelationsQueryConditions));
            }
        };
    }

    List<Call.CallDetail> queryInstanceRelation(Duration duration, AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> queryBuilder, DetectPoint detectPoint) throws IOException {
        String modelName;
        MetadataRegistry.Schema schema;
        MeasureQueryResponse resp;
        long startTB = 0L;
        long endTB = 0L;
        if (Objects.nonNull(duration)) {
            startTB = duration.getStartTimeBucketInSec();
            endTB = duration.getEndTimeBucketInSec();
        }
        TimestampRange timestampRange = null;
        if (startTB > 0L && endTB > 0L) {
            timestampRange = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
        }
        if ((resp = this.queryDebuggable(schema = MetadataRegistry.INSTANCE.findMetadata(modelName = detectPoint == DetectPoint.SERVER ? "service_instance_relation_server_side" : "service_instance_relation_client_side", duration.getStep()), (Set<String>)ImmutableSet.of((Object)"entity_id"), Collections.emptySet(), timestampRange, queryBuilder)).size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>(resp.size());
        for (DataPoint dataPoint : resp.getDataPoints()) {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = (String)dataPoint.getTagValue("entity_id");
            call.buildFromInstanceRelation(entityId, detectPoint);
            calls.add(call);
        }
        return calls;
    }

    public List<Call.CallDetail> loadEndpointRelation(Duration duration, String destEndpointId) throws IOException {
        AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> queryBuilder = this.buildEndpointRelationsQueries(destEndpointId);
        return this.queryEndpointRelation(duration, queryBuilder, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadProcessRelationDetectedAtClientSide(String serviceInstanceId, Duration duration) throws IOException {
        return this.queryProcessRelation(duration, serviceInstanceId, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadProcessRelationDetectedAtServerSide(String serviceInstanceId, Duration duration) throws IOException {
        return this.queryProcessRelation(duration, serviceInstanceId, DetectPoint.SERVER);
    }

    private AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> buildEndpointRelationsQueries(final String destEndpointId) {
        return new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.or(this.eq("source_endpoint", destEndpointId)).or(this.eq("dest_endpoint", destEndpointId));
                query.groupBy((Set)Sets.newHashSet((Object[])new String[]{"entity_id"}));
            }
        };
    }

    List<Call.CallDetail> queryEndpointRelation(Duration duration, AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> queryBuilder, DetectPoint detectPoint) throws IOException {
        MetadataRegistry.Schema schema;
        MeasureQueryResponse resp;
        long startTB = 0L;
        long endTB = 0L;
        if (Objects.nonNull(duration)) {
            startTB = duration.getStartTimeBucketInSec();
            endTB = duration.getEndTimeBucketInSec();
        }
        TimestampRange timestampRange = null;
        if (startTB > 0L && endTB > 0L) {
            timestampRange = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
        }
        if ((resp = this.queryDebuggable(schema = MetadataRegistry.INSTANCE.findMetadata("endpoint_relation_server_side", duration.getStep()), (Set<String>)ImmutableSet.of((Object)"entity_id"), Collections.emptySet(), timestampRange, queryBuilder)).size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Call.CallDetail> resultSet = new ArrayList<Call.CallDetail>(resp.size());
        for (DataPoint dataPoint : resp.getDataPoints()) {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = (String)dataPoint.getTagValue("entity_id");
            call.buildFromEndpointRelation(entityId, detectPoint);
            resultSet.add(call);
        }
        return resultSet;
    }

    List<Call.CallDetail> queryProcessRelation(Duration duration, final String serviceInstanceId, DetectPoint detectPoint) throws IOException {
        String modelName;
        MetadataRegistry.Schema schema;
        MeasureQueryResponse resp;
        long startTB = 0L;
        long endTB = 0L;
        if (Objects.nonNull(duration)) {
            startTB = duration.getStartTimeBucketInSec();
            endTB = duration.getEndTimeBucketInSec();
        }
        TimestampRange timestampRange = null;
        if (startTB > 0L && endTB > 0L) {
            timestampRange = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
        }
        if ((resp = this.queryDebuggable(schema = MetadataRegistry.INSTANCE.findMetadata(modelName = detectPoint == DetectPoint.SERVER ? "process_relation_server_side" : "process_relation_client_side", DownSampling.Minute), (Set<String>)ImmutableSet.of((Object)"entity_id", (Object)"component_id"), Collections.emptySet(), timestampRange, new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("service_instance_id", serviceInstanceId));
                query.groupBy((Set)Sets.newLinkedHashSet(Arrays.asList("entity_id", "component_id")));
            }
        })).size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>(resp.size());
        for (DataPoint dataPoint : resp.getDataPoints()) {
            String entityId = (String)dataPoint.getTagValue("entity_id");
            Number componentIdNumber = (Number)dataPoint.getTagValue("component_id");
            int componentId = componentIdNumber.intValue();
            Call.CallDetail call = new Call.CallDetail();
            call.buildProcessRelation(entityId, componentId, detectPoint);
            calls.add(call);
        }
        return calls;
    }
}

