/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.regex.Pattern;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Angle;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.Formulas;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.ConformalProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.provider.ObliqueMercatorCenter;
import org.apache.sis.referencing.operation.provider.ObliqueMercatorTwoPoints;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public class ObliqueMercator
extends ConformalProjection {
    private static final long serialVersionUID = -2194259651400234956L;
    private final double B;
    private final double H;
    private final double sin\u03b30;
    private final double cos\u03b30;

    public ObliqueMercator(OperationMethod method, Parameters parameters) {
        this(ObliqueMercator.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        Variant variant = (Variant)ObliqueMercator.variant((OperationMethod)method, (ProjectionVariant[])Variant.values(), (ProjectionVariant)Variant.DEFAULT);
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, ObliqueMercatorCenter.SCALE_FACTOR);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, variant.center ? ObliqueMercatorCenter.EASTING_AT_CENTRE : ObliqueMercatorCenter.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, variant.center ? ObliqueMercatorCenter.NORTHING_AT_CENTRE : ObliqueMercatorCenter.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, variant);
    }

    private ObliqueMercator(Initializer initializer) {
        super(initializer);
        double \u03bb0;
        double \u03b30;
        double \u03b3c;
        double \u03b1c;
        Variant variant = (Variant)initializer.variant;
        double \u03bbc = Math.toRadians(initializer.getAndStore((ParameterDescriptor<? extends Number>)ObliqueMercatorCenter.LONGITUDE_OF_CENTRE));
        double \u03c6c = Math.toRadians(initializer.getAndStore((ParameterDescriptor<? extends Number>)ObliqueMercatorCenter.LATITUDE_OF_CENTRE));
        double sin\u03c6 = Math.sin(\u03c6c);
        double cos\u03c6 = Math.cos(\u03c6c);
        double cos2\u03c6 = cos\u03c6 * cos\u03c6;
        this.B = Math.sqrt(1.0 + this.eccentricitySquared * (cos2\u03c6 * cos2\u03c6) / (1.0 - this.eccentricitySquared));
        double Br = this.B * initializer.axisLengthRatio().doubleValue();
        double r\u03bd2 = initializer.r\u03bd2(sin\u03c6).doubleValue();
        double A = Br / r\u03bd2;
        double D = Br / (cos\u03c6 * Math.sqrt(r\u03bd2));
        double sD1 = Math.sqrt(Math.max(D * D - 1.0, 0.0));
        double F = D + Math.copySign(sD1, \u03c6c);
        this.H = F * Math.pow(this.exp\u03a8(\u03c6c, this.eccentricity * sin\u03c6), -this.B);
        if (!variant.twoPoints) {
            \u03b1c = initializer.getAndStore((ParameterDescriptor<? extends Number>)ObliqueMercatorCenter.AZIMUTH);
            \u03b3c = Math.toRadians(initializer.getAndStore((ParameterDescriptor<Double>)ObliqueMercatorCenter.RECTIFIED_GRID_ANGLE, \u03b1c));
            \u03b30 = Math.asin(Math.sin(\u03b1c = Math.toRadians(\u03b1c)) / D);
            double Gt = (F - 1.0 / F) * 0.5 * Math.tan(\u03b30);
            double aGt = Math.abs(Gt);
            if (aGt > 1.0 && aGt <= 1.0000000015706707) {
                Gt = Math.copySign(1.0, Gt);
            }
            if (Double.isNaN(\u03bb0 = \u03bbc - Math.asin(Gt) / this.B)) {
                String name = ObliqueMercatorCenter.AZIMUTH.getName().getCode();
                Angle value = new Angle(Math.toDegrees(\u03b1c));
                throw new InvalidParameterValueException(Resources.format((short)25, name, value), name, (Object)value);
            }
        } else {
            double \u03c61 = Math.toRadians(initializer.getAndStore(ObliqueMercatorTwoPoints.LAT_OF_1ST_POINT));
            double \u03c62 = Math.toRadians(initializer.getAndStore(ObliqueMercatorTwoPoints.LAT_OF_2ND_POINT));
            double \u03bb1 = Math.toRadians(initializer.getAndStore(ObliqueMercatorTwoPoints.LONG_OF_1ST_POINT));
            double \u03bb2 = Math.toRadians(initializer.getAndStore(ObliqueMercatorTwoPoints.LONG_OF_2ND_POINT));
            double H1 = Math.pow(this.exp\u03a8(\u03c61, Math.sin(this.eccentricity * \u03c61)), -this.B);
            double L = Math.pow(this.exp\u03a8(\u03c62, Math.sin(this.eccentricity * \u03c62)), -this.B);
            double E2 = this.H * this.H;
            double LH = L * H1;
            double J = (E2 - LH) / (E2 + LH);
            double P = (L - H1) / (L + H1);
            double \u0394\u03bb = \u03bb1 - \u03bb2;
            if (Math.abs(\u0394\u03bb) > Math.PI) {
                \u03bb2 += Math.copySign(Math.PI * 2, \u0394\u03bb);
                \u0394\u03bb = \u03bb1 - \u03bb2;
            }
            if (Math.abs(\u0394\u03bb = \u03bb1 - (\u03bb0 = (\u03bb1 + \u03bb2) / 2.0 - Math.atan(J * Math.tan(this.B * \u0394\u03bb / 2.0) / P) / this.B)) > Math.PI) {
                \u03bb0 += Math.copySign(Math.PI * 2, \u0394\u03bb);
                \u0394\u03bb = \u03bb1 - \u03bb0;
            }
            \u03b30 = Math.atan(2.0 * Math.sin(this.B * \u0394\u03bb) / (this.H / H1 - H1 / this.H));
            \u03b1c = \u03b3c = Math.asin(D * Math.sin(\u03b30));
        }
        this.sin\u03b30 = Math.sin(\u03b30);
        this.cos\u03b30 = Math.cos(\u03b30);
        this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION).convertAfter(0, null, -\u03bb0);
        MatrixSIS denormalize = this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        Matrix3 rotation = new Matrix3();
        rotation.m00 = rotation.m11 = Math.cos(\u03b3c);
        rotation.m01 = Math.sin(\u03b3c);
        rotation.m10 = -rotation.m01;
        denormalize.setMatrix(denormalize.multiply(rotation));
        double ArB = A / this.B;
        if (variant.center) {
            double uc = Math.abs(Math.abs(\u03b1c) - 1.5707963267948966) < 1.5706706731410455E-9 ? A * (\u03bbc - \u03bb0) : ArB * Math.atan2(sD1, Math.cos(\u03b1c));
            denormalize.convertBefore(1, null, -Math.copySign(uc, \u03c6c));
        }
        denormalize.convertBefore(0, ArB, null);
        denormalize.convertBefore(1, ArB, null);
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"B", "H", "\u03b3\u2080"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.B, this.H, this.\u03b30()};
    }

    private double \u03b30() {
        return Math.abs(this.sin\u03b30) < Math.abs(this.cos\u03b30) ? Math.asin(this.sin\u03b30) : Math.acos(this.cos\u03b30);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03c6 = Math.sin(\u03c6);
        double Q = this.H * Math.pow(this.exp\u03a8(\u03c6, this.eccentricity * sin\u03c6), this.B);
        double iQ = 1.0 / Q;
        double S = (Q - iQ) * 0.5;
        double T = (Q + iQ) * 0.5;
        double V = Math.sin(this.B * \u03bb);
        double U = (S * this.sin\u03b30 - V * this.cos\u03b30) / T;
        double dV_d\u03bb = Math.cos(this.B * \u03bb);
        if (dstPts != null) {
            dstPts[dstOff] = MathFunctions.atanh((double)(-U));
            dstPts[dstOff + 1] = Math.atan2(S * this.cos\u03b30 + V * this.sin\u03b30, dV_d\u03bb);
        }
        if (!derivate) {
            return null;
        }
        double dQ_d\u03c6 = this.B * Q * this.dy_d\u03c6(sin\u03c6, Math.cos(\u03c6));
        double dU_d\u03bb = -this.B * (this.cos\u03b30 / T) * dV_d\u03bb;
        double dU_d\u03c6 = dQ_d\u03c6 * (this.sin\u03b30 + (this.sin\u03b30 + U) / (Q * Q) - U) / (2.0 * T);
        double dS_d\u03c6 = 0.5 * dQ_d\u03c6 * (1.0 + 1.0 / (Q * Q));
        double M = S * this.cos\u03b30 + V * this.sin\u03b30;
        double L = Formulas.fastHypot(dV_d\u03bb, M);
        double M_L = M / L;
        double P = L + dV_d\u03bb;
        double D = P * P + M * M;
        double dy_d\u03bb = 2.0 * this.B * (dV_d\u03bb * (this.sin\u03b30 * P + (V - this.sin\u03b30 * M) * M_L) + V * M) / D;
        double dy_d\u03c6 = 2.0 * this.cos\u03b30 * dS_d\u03c6 * (P - M * M_L) / D;
        double R = U * U - 1.0;
        return new Matrix2(dU_d\u03bb / R, dU_d\u03c6 / R, dy_d\u03bb, dy_d\u03c6);
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        double Q = Math.exp(-x);
        double Qi = 1.0 / Q;
        double S = (Q - Qi) * 0.5;
        double T = (Q + Qi) * 0.5;
        double V = Math.sin(y);
        double U = (V * this.cos\u03b30 + S * this.sin\u03b30) / T;
        double \u03bb = -Math.atan2(S * this.cos\u03b30 - V * this.sin\u03b30, Math.cos(y)) / this.B;
        double \u03c6 = Math.abs(U) >= 1.0 ? Math.copySign(1.5707963267948966, U) : this.\u03c6(Math.pow(this.H / Math.sqrt((1.0 + U) / (1.0 - U)), 1.0 / this.B));
        dstPts[dstOff] = \u03bb;
        dstPts[dstOff + 1] = \u03c6;
    }

    private static enum Variant implements ProjectionVariant
    {
        DEFAULT(".*\\bvariant\\s*A\\b.*", "9812", false, false),
        CENTER(".*\\bvariant\\s*B\\b.*", "9815", false, true),
        TWO_POINTS(".*\\bTwo\\s*Point\\s*Natural\\b.*", null, true, false),
        TWO_POINTS_CENTER(".*\\bTwo\\s*Point\\s*Center\\b.*", null, true, true);

        private final Pattern operationName;
        private final String identifier;
        final boolean twoPoints;
        final boolean center;

        private Variant(String operationName, String identifier, boolean twoPoints, boolean center) {
            this.operationName = Pattern.compile(operationName, 2);
            this.identifier = identifier;
            this.twoPoints = twoPoints;
            this.center = center;
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }
}

