/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.util.Objects;
import javax.measure.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.MapProjectionDescriptor;
import org.apache.sis.referencing.Builder;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;

public class ParameterBuilder
extends Builder<ParameterBuilder> {
    private boolean required;

    public ParameterBuilder() {
    }

    public ParameterBuilder(GeneralParameterDescriptor descriptor) {
        super((IdentifiedObject)descriptor);
        if (descriptor != null) {
            this.required = descriptor.getMinimumOccurs() != 0;
        }
    }

    public ParameterBuilder setRequired(boolean required) {
        this.required = required;
        return this;
    }

    private static Double valueOf(double value) {
        return Double.isNaN(value) ? null : Double.valueOf(value);
    }

    public <T> ParameterDescriptor<T> create(Class<T> valueClass, T defaultValue) {
        return this.create(valueClass, null, null, defaultValue);
    }

    public ParameterDescriptor<Double> create(double defaultValue, Unit<?> unit) {
        MeasurementRange valueDomain = unit != null ? MeasurementRange.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)false, unit) : null;
        return this.create((Class)Double.class, (Range<?>)valueDomain, null, (Object)ParameterBuilder.valueOf(defaultValue));
    }

    public ParameterDescriptor<Double> createStrictlyPositive(double defaultValue, Unit<?> unit) {
        Object valueDomain = unit != null ? MeasurementRange.createGreaterThan((double)0.0, unit) : NumberRange.create((double)0.0, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)false);
        return this.create((Class)Double.class, (Range<?>)valueDomain, null, (Object)ParameterBuilder.valueOf(defaultValue));
    }

    public ParameterDescriptor<Double> createBounded(double minimumValue, double maximumValue, double defaultValue, Unit<?> unit) {
        Object valueDomain = unit != null ? MeasurementRange.create((double)minimumValue, (boolean)true, (double)maximumValue, (boolean)true, unit) : (minimumValue != Double.NEGATIVE_INFINITY || maximumValue != Double.POSITIVE_INFINITY ? NumberRange.create((double)minimumValue, (boolean)true, (double)maximumValue, (boolean)true) : null);
        return this.create((Class)Double.class, (Range<?>)valueDomain, null, (Object)ParameterBuilder.valueOf(defaultValue));
    }

    public ParameterDescriptor<Integer> createBounded(int minimumValue, int maximumValue, int defaultValue) {
        return this.create((Class)Integer.class, (Range<?>)NumberRange.create((int)minimumValue, (boolean)true, (int)maximumValue, (boolean)true), null, defaultValue);
    }

    public <T extends Comparable<? super T>> ParameterDescriptor<T> createBounded(Class<T> valueClass, T minimumValue, T maximumValue, T defaultValue) {
        ArgumentChecks.ensureNonNull((String)"valueClass", valueClass);
        Object valueDomain = minimumValue == null && maximumValue == null ? null : (Number.class.isAssignableFrom(valueClass) ? new NumberRange(valueClass, (Number)((Object)minimumValue), true, (Number)((Object)maximumValue), true) : new Range(valueClass, minimumValue, true, maximumValue, true));
        return this.create(valueClass, (Range<?>)valueDomain, null, defaultValue);
    }

    public <T extends Comparable<? super T>> ParameterDescriptor<T> createBounded(Range<T> valueDomain, T defaultValue) {
        return this.create(valueDomain.getElementType(), valueDomain, null, defaultValue);
    }

    public <T> ParameterDescriptor<T> createEnumerated(Class<T> valueClass, T[] validValues, T defaultValue) {
        return this.create(Objects.requireNonNull(valueClass), null, validValues, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ParameterDescriptor<T> create(Class<T> valueClass, Range<?> valueDomain, T[] validValues, T defaultValue) {
        DefaultParameterDescriptor<T> descriptor;
        this.onCreate(false);
        try {
            descriptor = new DefaultParameterDescriptor<T>(this.properties, this.required ? 1 : 0, 1, valueClass, valueDomain, validValues, defaultValue);
        }
        finally {
            this.onCreate(true);
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterDescriptorGroup createGroup(int minimumOccurs, int maximumOccurs, GeneralParameterDescriptor ... parameters) {
        DefaultParameterDescriptorGroup group;
        this.onCreate(false);
        try {
            group = new DefaultParameterDescriptorGroup(this.properties, minimumOccurs, maximumOccurs, parameters);
        }
        finally {
            this.onCreate(true);
        }
        return group;
    }

    public ParameterDescriptorGroup createGroup(GeneralParameterDescriptor ... parameters) {
        return this.createGroup(this.required ? 1 : 0, 1, parameters);
    }

    public ParameterDescriptorGroup createGroupWithSameParameters(ParameterDescriptorGroup parameters) {
        DefaultParameterDescriptorGroup group;
        this.onCreate(false);
        try {
            group = new DefaultParameterDescriptorGroup(this.properties, parameters);
        }
        finally {
            this.onCreate(true);
        }
        return group;
    }

    public ParameterDescriptorGroup createGroupForMapProjection(ParameterDescriptor<?> ... parameters) {
        MapProjectionDescriptor group;
        this.onCreate(false);
        try {
            group = new MapProjectionDescriptor(this.properties, parameters);
        }
        finally {
            this.onCreate(true);
        }
        return group;
    }
}

