/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

app.controller('opsController', ['$scope', '$location', '$http', 'Notification', 'remoteApi', 'tools', '$window', function ($scope, $location, $http, Notification, remoteApi, tools, $window) {
    $scope.namesvrAddrList = [];
    $scope.useVIPChannel = true;
    $scope.useTLS = false;
    $scope.userRole = $window.sessionStorage.getItem("userrole");
    $scope.writeOperationEnabled =  $scope.userRole == null ? true : ($scope.userRole == 1 ? true : false);
    $scope.inputReadonly = !$scope.writeOperationEnabled;
    $scope.newNamesrvAddr = "";
    $http({
        method: "GET",
        url: "ops/homePage.query"
    }).success(function (resp) {
        if (resp.status == 0) {
            $scope.namesvrAddrList = resp.data.namesvrAddrList;
            $scope.useVIPChannel = resp.data.useVIPChannel;
            $scope.useTLS = resp.data.useTLS;
            $scope.selectedNamesrv = resp.data.currentNamesrv;
        } else {
            Notification.error({message: resp.errMsg, delay: 2000});
        }
    });

    $scope.eleChange = function (data){
        $scope.namesvrAddrList = data;
    }

    $scope.updateNameSvrAddr = function () {
        $http({
            method: "POST",
            url: "ops/updateNameSvrAddr.do",
            params: {nameSvrAddrList: $scope.selectedNamesrv}
        }).success(function (resp) {
            if (resp.status == 0) {
                Notification.info({message: "SUCCESS", delay: 2000});
            } else {
                Notification.error({message: resp.errMsg, delay: 2000});
            }
        });
    };

    $scope.addNameSvrAddr = function () {
        $http({
            method: "POST",
            url: "ops/addNameSvrAddr.do",
            params: {newNamesrvAddr: $scope.newNamesrvAddr}
        }).success(function (resp) {
            if (resp.status == 0) {
                if ($scope.namesvrAddrList.indexOf($scope.newNamesrvAddr) == -1) {
                    $scope.namesvrAddrList.push($scope.newNamesrvAddr);
                }
                $("#namesrvAddr").val("");
                $scope.newNamesrvAddr = "";
                Notification.info({message: "SUCCESS", delay: 2000});
            } else {
                Notification.error({message: resp.errMsg, delay: 2000});
            }
        });
    };

    $scope.updateIsVIPChannel = function () {
        $http({
            method: "POST",
            url: "ops/updateIsVIPChannel.do",
            params: {useVIPChannel: $scope.useVIPChannel}
        }).success(function (resp) {
            if (resp.status == 0) {
                Notification.info({message: "SUCCESS", delay: 2000});
            } else {
                Notification.error({message: resp.errMsg, delay: 2000});
            }
        });
    };
    $scope.updateUseTLS = function () {
        $http({
            method: "POST",
            url: "ops/updateUseTLS.do",
            params: {useTLS: $scope.useTLS}
        }).success(function (resp) {
            if (resp.status == 0) {
                Notification.info({message: "SUCCESS", delay: 2000});
            } else {
                Notification.error({message: resp.errMsg, delay: 2000});
            }
        });
    }
}]);
