/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.core;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Iterator;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.core.IteratorImpl;
import com.alipay.sofa.jraft.entity.EnumOutter;
import com.alipay.sofa.jraft.entity.LogEntry;
import java.nio.ByteBuffer;

public class IteratorWrapper
implements Iterator {
    private final IteratorImpl impl;

    public IteratorWrapper(IteratorImpl iterImpl) {
        this.impl = iterImpl;
    }

    @Override
    public boolean hasNext() {
        return this.impl.isGood() && this.impl.entry().getType() == EnumOutter.EntryType.ENTRY_TYPE_DATA;
    }

    @Override
    public ByteBuffer next() {
        if (this.impl.getAutoCommitPerLog() && !this.impl.hasError()) {
            this.commit();
        }
        ByteBuffer data = this.getData();
        if (this.hasNext()) {
            this.impl.next();
        }
        return data;
    }

    @Override
    public void setAutoCommitPerLog(boolean status) {
        this.impl.setAutoCommitPerLog(status);
    }

    @Override
    public ByteBuffer getData() {
        LogEntry entry = this.impl.entry();
        return entry != null ? entry.getData() : null;
    }

    @Override
    public long getIndex() {
        return this.impl.getIndex();
    }

    @Override
    public long getTerm() {
        return this.impl.entry().getId().getTerm();
    }

    @Override
    public boolean commit() {
        return this.impl.commit();
    }

    @Override
    public void commitAndSnapshotSync(Closure done) {
        this.impl.commitAndSnapshotSync(done);
    }

    @Override
    public Closure done() {
        return this.impl.done();
    }

    @Override
    public void setErrorAndRollback(long ntail, Status st) {
        this.impl.setErrorAndRollback(ntail, st);
    }
}

