/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.pop;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.broker.pop.PopConsumerRecord;
import org.apache.rocketmq.remoting.protocol.header.ExtraInfoUtil;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;

public class PopConsumerContext {
    private final String clientHost;
    private final long popTime;
    private final long invisibleTime;
    private final String groupId;
    private final boolean fifo;
    private final String attemptId;
    private final AtomicLong restCount;
    private final StringBuilder startOffsetInfo;
    private final StringBuilder msgOffsetInfo;
    private final StringBuilder orderCountInfo;
    private List<GetMessageResult> getMessageResultList;
    private List<PopConsumerRecord> popConsumerRecordList;

    public PopConsumerContext(String clientHost, long popTime, long invisibleTime, String groupId, boolean fifo, String attemptId) {
        this.clientHost = clientHost;
        this.popTime = popTime;
        this.invisibleTime = invisibleTime;
        this.groupId = groupId;
        this.fifo = fifo;
        this.attemptId = attemptId;
        this.restCount = new AtomicLong(0L);
        this.startOffsetInfo = new StringBuilder();
        this.msgOffsetInfo = new StringBuilder();
        this.orderCountInfo = new StringBuilder();
    }

    public boolean isFound() {
        return this.getMessageResultList != null && !this.getMessageResultList.isEmpty();
    }

    public void addGetMessageResult(GetMessageResult result, String topicId, int queueId, PopConsumerRecord.RetryType retryType, long offset) {
        if (result.getStatus() != GetMessageStatus.FOUND || result.getMessageQueueOffset().isEmpty()) {
            return;
        }
        if (this.getMessageResultList == null) {
            this.getMessageResultList = new ArrayList<GetMessageResult>();
        }
        if (this.popConsumerRecordList == null) {
            this.popConsumerRecordList = new ArrayList<PopConsumerRecord>();
        }
        this.getMessageResultList.add(result);
        this.addRestCount(result.getMaxOffset() - result.getNextBeginOffset());
        for (int i = 0; i < result.getMessageQueueOffset().size(); ++i) {
            this.popConsumerRecordList.add(new PopConsumerRecord(this.popTime, this.groupId, topicId, queueId, retryType.getCode(), this.invisibleTime, (Long)result.getMessageQueueOffset().get(i), this.attemptId));
        }
        ExtraInfoUtil.buildStartOffsetInfo((StringBuilder)this.startOffsetInfo, (String)topicId, (int)queueId, (long)offset);
        ExtraInfoUtil.buildMsgOffsetInfo((StringBuilder)this.msgOffsetInfo, (String)topicId, (int)queueId, (List)result.getMessageQueueOffset());
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void addRestCount(long delta) {
        this.restCount.addAndGet(delta);
    }

    public long getRestCount() {
        return this.restCount.get();
    }

    public long getPopTime() {
        return this.popTime;
    }

    public boolean isFifo() {
        return this.fifo;
    }

    public long getInvisibleTime() {
        return this.invisibleTime;
    }

    public String getAttemptId() {
        return this.attemptId;
    }

    public int getMessageCount() {
        return this.getMessageResultList != null ? this.getMessageResultList.stream().mapToInt(GetMessageResult::getMessageCount).sum() : 0;
    }

    public String getStartOffsetInfo() {
        return this.startOffsetInfo.toString();
    }

    public String getMsgOffsetInfo() {
        return this.msgOffsetInfo.toString();
    }

    public StringBuilder getOrderCountInfoBuilder() {
        return this.orderCountInfo;
    }

    public String getOrderCountInfo() {
        return this.orderCountInfo.toString();
    }

    public List<GetMessageResult> getGetMessageResultList() {
        return this.getMessageResultList;
    }

    public List<PopConsumerRecord> getPopConsumerRecordList() {
        return this.popConsumerRecordList;
    }

    public String toString() {
        return "PopConsumerContext{clientHost=" + this.clientHost + ", popTime=" + this.popTime + ", invisibleTime=" + this.invisibleTime + ", groupId=" + this.groupId + ", isFifo=" + this.fifo + ", attemptId=" + this.attemptId + ", restCount=" + this.restCount + ", startOffsetInfo=" + this.startOffsetInfo + ", msgOffsetInfo=" + this.msgOffsetInfo + ", orderCountInfo=" + this.orderCountInfo + ", getMessageResultList=" + (this.getMessageResultList != null ? this.getMessageResultList.size() : 0) + ", popConsumerRecordList=" + (this.popConsumerRecordList != null ? this.popConsumerRecordList.size() : 0) + '}';
    }
}

