/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by code-generation. DO NOT EDIT.
using org.apache.plc4net.types;

namespace org.apache.plc4net.drivers.knxnetip.readwrite.model
{

    public enum KnxPropertyDataType
    {
        PDT_UNKNOWN = 0,
        PDT_CONTROL = 1,
        PDT_CHAR = 2,
        PDT_UNSIGNED_CHAR = 3,
        PDT_INT = 4,
        PDT_UNSIGNED_INT = 5,
        PDT_KNX_FLOAT = 6,
        PDT_DATE = 7,
        PDT_TIME = 8,
        PDT_LONG = 9,
        PDT_UNSIGNED_LONG = 10,
        PDT_FLOAT = 11,
        PDT_DOUBLE = 12,
        PDT_CHAR_BLOCK = 13,
        PDT_POLL_GROUP_SETTINGS = 14,
        PDT_SHORT_CHAR_BLOCK = 15,
        PDT_DATE_TIME = 16,
        PDT_VARIABLE_LENGTH = 17,
        PDT_GENERIC_01 = 18,
        PDT_GENERIC_02 = 19,
        PDT_GENERIC_03 = 20,
        PDT_GENERIC_04 = 21,
        PDT_GENERIC_05 = 22,
        PDT_GENERIC_06 = 23,
        PDT_GENERIC_07 = 24,
        PDT_GENERIC_08 = 25,
        PDT_GENERIC_09 = 26,
        PDT_GENERIC_10 = 27,
        PDT_GENERIC_11 = 28,
        PDT_GENERIC_12 = 29,
        PDT_GENERIC_13 = 30,
        PDT_GENERIC_14 = 31,
        PDT_GENERIC_15 = 32,
        PDT_GENERIC_16 = 33,
        PDT_GENERIC_17 = 34,
        PDT_GENERIC_18 = 35,
        PDT_GENERIC_19 = 36,
        PDT_GENERIC_20 = 37,
        PDT_UTF_8 = 38,
        PDT_VERSION = 39,
        PDT_ALARM_INFO = 40,
        PDT_BINARY_INFORMATION = 41,
        PDT_BITSET8 = 42,
        PDT_BITSET16 = 43,
        PDT_ENUM8 = 44,
        PDT_SCALING = 45,
        PDT_NE_VL = 46,
        PDT_NE_FL = 47,
        PDT_FUNCTION = 48,
        PDT_ESCAPE = 49,
    }

    public static class KnxPropertyDataTypeInfo
    {

        public static byte? Number(this KnxPropertyDataType value)
        {
            switch (value)
            {
                case KnxPropertyDataType.PDT_UNKNOWN: { /* '0' */
                    return 0;
                }
                case KnxPropertyDataType.PDT_CONTROL: { /* '1' */
                    return 0;
                }
                case KnxPropertyDataType.PDT_UNSIGNED_LONG: { /* '10' */
                    return 9;
                }
                case KnxPropertyDataType.PDT_FLOAT: { /* '11' */
                    return 10;
                }
                case KnxPropertyDataType.PDT_DOUBLE: { /* '12' */
                    return 11;
                }
                case KnxPropertyDataType.PDT_CHAR_BLOCK: { /* '13' */
                    return 12;
                }
                case KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS: { /* '14' */
                    return 13;
                }
                case KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK: { /* '15' */
                    return 14;
                }
                case KnxPropertyDataType.PDT_DATE_TIME: { /* '16' */
                    return 15;
                }
                case KnxPropertyDataType.PDT_VARIABLE_LENGTH: { /* '17' */
                    return 16;
                }
                case KnxPropertyDataType.PDT_GENERIC_01: { /* '18' */
                    return 17;
                }
                case KnxPropertyDataType.PDT_GENERIC_02: { /* '19' */
                    return 18;
                }
                case KnxPropertyDataType.PDT_CHAR: { /* '2' */
                    return 1;
                }
                case KnxPropertyDataType.PDT_GENERIC_03: { /* '20' */
                    return 19;
                }
                case KnxPropertyDataType.PDT_GENERIC_04: { /* '21' */
                    return 20;
                }
                case KnxPropertyDataType.PDT_GENERIC_05: { /* '22' */
                    return 21;
                }
                case KnxPropertyDataType.PDT_GENERIC_06: { /* '23' */
                    return 22;
                }
                case KnxPropertyDataType.PDT_GENERIC_07: { /* '24' */
                    return 23;
                }
                case KnxPropertyDataType.PDT_GENERIC_08: { /* '25' */
                    return 24;
                }
                case KnxPropertyDataType.PDT_GENERIC_09: { /* '26' */
                    return 25;
                }
                case KnxPropertyDataType.PDT_GENERIC_10: { /* '27' */
                    return 26;
                }
                case KnxPropertyDataType.PDT_GENERIC_11: { /* '28' */
                    return 27;
                }
                case KnxPropertyDataType.PDT_GENERIC_12: { /* '29' */
                    return 28;
                }
                case KnxPropertyDataType.PDT_UNSIGNED_CHAR: { /* '3' */
                    return 2;
                }
                case KnxPropertyDataType.PDT_GENERIC_13: { /* '30' */
                    return 29;
                }
                case KnxPropertyDataType.PDT_GENERIC_14: { /* '31' */
                    return 30;
                }
                case KnxPropertyDataType.PDT_GENERIC_15: { /* '32' */
                    return 31;
                }
                case KnxPropertyDataType.PDT_GENERIC_16: { /* '33' */
                    return 32;
                }
                case KnxPropertyDataType.PDT_GENERIC_17: { /* '34' */
                    return 33;
                }
                case KnxPropertyDataType.PDT_GENERIC_18: { /* '35' */
                    return 34;
                }
                case KnxPropertyDataType.PDT_GENERIC_19: { /* '36' */
                    return 35;
                }
                case KnxPropertyDataType.PDT_GENERIC_20: { /* '37' */
                    return 36;
                }
                case KnxPropertyDataType.PDT_UTF_8: { /* '38' */
                    return 47;
                }
                case KnxPropertyDataType.PDT_VERSION: { /* '39' */
                    return 48;
                }
                case KnxPropertyDataType.PDT_INT: { /* '4' */
                    return 3;
                }
                case KnxPropertyDataType.PDT_ALARM_INFO: { /* '40' */
                    return 49;
                }
                case KnxPropertyDataType.PDT_BINARY_INFORMATION: { /* '41' */
                    return 50;
                }
                case KnxPropertyDataType.PDT_BITSET8: { /* '42' */
                    return 51;
                }
                case KnxPropertyDataType.PDT_BITSET16: { /* '43' */
                    return 52;
                }
                case KnxPropertyDataType.PDT_ENUM8: { /* '44' */
                    return 53;
                }
                case KnxPropertyDataType.PDT_SCALING: { /* '45' */
                    return 54;
                }
                case KnxPropertyDataType.PDT_NE_VL: { /* '46' */
                    return 60;
                }
                case KnxPropertyDataType.PDT_NE_FL: { /* '47' */
                    return 61;
                }
                case KnxPropertyDataType.PDT_FUNCTION: { /* '48' */
                    return 62;
                }
                case KnxPropertyDataType.PDT_ESCAPE: { /* '49' */
                    return 63;
                }
                case KnxPropertyDataType.PDT_UNSIGNED_INT: { /* '5' */
                    return 4;
                }
                case KnxPropertyDataType.PDT_KNX_FLOAT: { /* '6' */
                    return 5;
                }
                case KnxPropertyDataType.PDT_DATE: { /* '7' */
                    return 6;
                }
                case KnxPropertyDataType.PDT_TIME: { /* '8' */
                    return 7;
                }
                case KnxPropertyDataType.PDT_LONG: { /* '9' */
                    return 8;
                }
                default: {
                    return 0;
                }
            }
        }

        public static byte? SizeInBytes(this KnxPropertyDataType value)
        {
            switch (value)
            {
                case KnxPropertyDataType.PDT_UNKNOWN: { /* '0' */
                    return 0;
                }
                case KnxPropertyDataType.PDT_CONTROL: { /* '1' */
                    return 10;
                }
                case KnxPropertyDataType.PDT_UNSIGNED_LONG: { /* '10' */
                    return 4;
                }
                case KnxPropertyDataType.PDT_FLOAT: { /* '11' */
                    return 4;
                }
                case KnxPropertyDataType.PDT_DOUBLE: { /* '12' */
                    return 8;
                }
                case KnxPropertyDataType.PDT_CHAR_BLOCK: { /* '13' */
                    return 10;
                }
                case KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS: { /* '14' */
                    return 3;
                }
                case KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK: { /* '15' */
                    return 5;
                }
                case KnxPropertyDataType.PDT_DATE_TIME: { /* '16' */
                    return 8;
                }
                case KnxPropertyDataType.PDT_VARIABLE_LENGTH: { /* '17' */
                    return 0;
                }
                case KnxPropertyDataType.PDT_GENERIC_01: { /* '18' */
                    return 1;
                }
                case KnxPropertyDataType.PDT_GENERIC_02: { /* '19' */
                    return 2;
                }
                case KnxPropertyDataType.PDT_CHAR: { /* '2' */
                    return 1;
                }
                case KnxPropertyDataType.PDT_GENERIC_03: { /* '20' */
                    return 3;
                }
                case KnxPropertyDataType.PDT_GENERIC_04: { /* '21' */
                    return 4;
                }
                case KnxPropertyDataType.PDT_GENERIC_05: { /* '22' */
                    return 5;
                }
                case KnxPropertyDataType.PDT_GENERIC_06: { /* '23' */
                    return 6;
                }
                case KnxPropertyDataType.PDT_GENERIC_07: { /* '24' */
                    return 7;
                }
                case KnxPropertyDataType.PDT_GENERIC_08: { /* '25' */
                    return 8;
                }
                case KnxPropertyDataType.PDT_GENERIC_09: { /* '26' */
                    return 9;
                }
                case KnxPropertyDataType.PDT_GENERIC_10: { /* '27' */
                    return 10;
                }
                case KnxPropertyDataType.PDT_GENERIC_11: { /* '28' */
                    return 11;
                }
                case KnxPropertyDataType.PDT_GENERIC_12: { /* '29' */
                    return 12;
                }
                case KnxPropertyDataType.PDT_UNSIGNED_CHAR: { /* '3' */
                    return 1;
                }
                case KnxPropertyDataType.PDT_GENERIC_13: { /* '30' */
                    return 13;
                }
                case KnxPropertyDataType.PDT_GENERIC_14: { /* '31' */
                    return 14;
                }
                case KnxPropertyDataType.PDT_GENERIC_15: { /* '32' */
                    return 15;
                }
                case KnxPropertyDataType.PDT_GENERIC_16: { /* '33' */
                    return 16;
                }
                case KnxPropertyDataType.PDT_GENERIC_17: { /* '34' */
                    return 17;
                }
                case KnxPropertyDataType.PDT_GENERIC_18: { /* '35' */
                    return 18;
                }
                case KnxPropertyDataType.PDT_GENERIC_19: { /* '36' */
                    return 19;
                }
                case KnxPropertyDataType.PDT_GENERIC_20: { /* '37' */
                    return 20;
                }
                case KnxPropertyDataType.PDT_UTF_8: { /* '38' */
                    return 0;
                }
                case KnxPropertyDataType.PDT_VERSION: { /* '39' */
                    return 2;
                }
                case KnxPropertyDataType.PDT_INT: { /* '4' */
                    return 2;
                }
                case KnxPropertyDataType.PDT_ALARM_INFO: { /* '40' */
                    return 6;
                }
                case KnxPropertyDataType.PDT_BINARY_INFORMATION: { /* '41' */
                    return 1;
                }
                case KnxPropertyDataType.PDT_BITSET8: { /* '42' */
                    return 1;
                }
                case KnxPropertyDataType.PDT_BITSET16: { /* '43' */
                    return 2;
                }
                case KnxPropertyDataType.PDT_ENUM8: { /* '44' */
                    return 1;
                }
                case KnxPropertyDataType.PDT_SCALING: { /* '45' */
                    return 1;
                }
                case KnxPropertyDataType.PDT_NE_VL: { /* '46' */
                    return 0;
                }
                case KnxPropertyDataType.PDT_NE_FL: { /* '47' */
                    return 0;
                }
                case KnxPropertyDataType.PDT_FUNCTION: { /* '48' */
                    return 0;
                }
                case KnxPropertyDataType.PDT_ESCAPE: { /* '49' */
                    return 0;
                }
                case KnxPropertyDataType.PDT_UNSIGNED_INT: { /* '5' */
                    return 2;
                }
                case KnxPropertyDataType.PDT_KNX_FLOAT: { /* '6' */
                    return 2;
                }
                case KnxPropertyDataType.PDT_DATE: { /* '7' */
                    return 3;
                }
                case KnxPropertyDataType.PDT_TIME: { /* '8' */
                    return 3;
                }
                case KnxPropertyDataType.PDT_LONG: { /* '9' */
                    return 4;
                }
                default: {
                    return 0;
                }
            }
        }

        public static string Name(this KnxPropertyDataType value)
        {
            switch (value)
            {
                case KnxPropertyDataType.PDT_UNKNOWN: { /* '0' */
                    return "Unknown Property Data Type";
                }
                case KnxPropertyDataType.PDT_CONTROL: { /* '1' */
                    return "PDT_CONTROL";
                }
                case KnxPropertyDataType.PDT_UNSIGNED_LONG: { /* '10' */
                    return "PDT_UNSIGNED_LONG";
                }
                case KnxPropertyDataType.PDT_FLOAT: { /* '11' */
                    return "PDT_FLOAT";
                }
                case KnxPropertyDataType.PDT_DOUBLE: { /* '12' */
                    return "PDT_DOUBLE";
                }
                case KnxPropertyDataType.PDT_CHAR_BLOCK: { /* '13' */
                    return "PDT_CHAR_BLOCK";
                }
                case KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS: { /* '14' */
                    return "PDT_POLL_GROUP_SETTINGS";
                }
                case KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK: { /* '15' */
                    return "PDT_SHORT_CHAR_BLOCK";
                }
                case KnxPropertyDataType.PDT_DATE_TIME: { /* '16' */
                    return "PDT_DATE_TIME";
                }
                case KnxPropertyDataType.PDT_VARIABLE_LENGTH: { /* '17' */
                    return "PDT_VARIABLE_LENGTH";
                }
                case KnxPropertyDataType.PDT_GENERIC_01: { /* '18' */
                    return "PDT_GENERIC_01";
                }
                case KnxPropertyDataType.PDT_GENERIC_02: { /* '19' */
                    return "PDT_GENERIC_02";
                }
                case KnxPropertyDataType.PDT_CHAR: { /* '2' */
                    return "PDT_CHAR";
                }
                case KnxPropertyDataType.PDT_GENERIC_03: { /* '20' */
                    return "PDT_GENERIC_03";
                }
                case KnxPropertyDataType.PDT_GENERIC_04: { /* '21' */
                    return "PDT_GENERIC_04";
                }
                case KnxPropertyDataType.PDT_GENERIC_05: { /* '22' */
                    return "PDT_GENERIC_05";
                }
                case KnxPropertyDataType.PDT_GENERIC_06: { /* '23' */
                    return "PDT_GENERIC_06";
                }
                case KnxPropertyDataType.PDT_GENERIC_07: { /* '24' */
                    return "PDT_GENERIC_07";
                }
                case KnxPropertyDataType.PDT_GENERIC_08: { /* '25' */
                    return "PDT_GENERIC_08";
                }
                case KnxPropertyDataType.PDT_GENERIC_09: { /* '26' */
                    return "PDT_GENERIC_09";
                }
                case KnxPropertyDataType.PDT_GENERIC_10: { /* '27' */
                    return "PDT_GENERIC_10";
                }
                case KnxPropertyDataType.PDT_GENERIC_11: { /* '28' */
                    return "PDT_GENERIC_11";
                }
                case KnxPropertyDataType.PDT_GENERIC_12: { /* '29' */
                    return "PDT_GENERIC_12";
                }
                case KnxPropertyDataType.PDT_UNSIGNED_CHAR: { /* '3' */
                    return "PDT_UNSIGNED_CHAR";
                }
                case KnxPropertyDataType.PDT_GENERIC_13: { /* '30' */
                    return "PDT_GENERIC_13";
                }
                case KnxPropertyDataType.PDT_GENERIC_14: { /* '31' */
                    return "PDT_GENERIC_14";
                }
                case KnxPropertyDataType.PDT_GENERIC_15: { /* '32' */
                    return "PDT_GENERIC_15";
                }
                case KnxPropertyDataType.PDT_GENERIC_16: { /* '33' */
                    return "PDT_GENERIC_16";
                }
                case KnxPropertyDataType.PDT_GENERIC_17: { /* '34' */
                    return "PDT_GENERIC_17";
                }
                case KnxPropertyDataType.PDT_GENERIC_18: { /* '35' */
                    return "PDT_GENERIC_18";
                }
                case KnxPropertyDataType.PDT_GENERIC_19: { /* '36' */
                    return "PDT_GENERIC_19";
                }
                case KnxPropertyDataType.PDT_GENERIC_20: { /* '37' */
                    return "PDT_GENERIC_20";
                }
                case KnxPropertyDataType.PDT_UTF_8: { /* '38' */
                    return "PDT_UTF-8";
                }
                case KnxPropertyDataType.PDT_VERSION: { /* '39' */
                    return "PDT_VERSION";
                }
                case KnxPropertyDataType.PDT_INT: { /* '4' */
                    return "PDT_INT";
                }
                case KnxPropertyDataType.PDT_ALARM_INFO: { /* '40' */
                    return "PDT_ALARM_INFO";
                }
                case KnxPropertyDataType.PDT_BINARY_INFORMATION: { /* '41' */
                    return "PDT_BINARY_INFORMATION";
                }
                case KnxPropertyDataType.PDT_BITSET8: { /* '42' */
                    return "PDT_BITSET8";
                }
                case KnxPropertyDataType.PDT_BITSET16: { /* '43' */
                    return "PDT_BITSET16";
                }
                case KnxPropertyDataType.PDT_ENUM8: { /* '44' */
                    return "PDT_ENUM8";
                }
                case KnxPropertyDataType.PDT_SCALING: { /* '45' */
                    return "PDT_SCALING";
                }
                case KnxPropertyDataType.PDT_NE_VL: { /* '46' */
                    return "PDT_NE_VL";
                }
                case KnxPropertyDataType.PDT_NE_FL: { /* '47' */
                    return "PDT_NE_FL";
                }
                case KnxPropertyDataType.PDT_FUNCTION: { /* '48' */
                    return "PDT_FUNCTION";
                }
                case KnxPropertyDataType.PDT_ESCAPE: { /* '49' */
                    return "PDT_ESCAPE";
                }
                case KnxPropertyDataType.PDT_UNSIGNED_INT: { /* '5' */
                    return "PDT_UNSIGNED_INT";
                }
                case KnxPropertyDataType.PDT_KNX_FLOAT: { /* '6' */
                    return "PDT_KNX_FLOAT";
                }
                case KnxPropertyDataType.PDT_DATE: { /* '7' */
                    return "PDT_DATE";
                }
                case KnxPropertyDataType.PDT_TIME: { /* '8' */
                    return "PDT_TIME";
                }
                case KnxPropertyDataType.PDT_LONG: { /* '9' */
                    return "PDT_LONG";
                }
                default: {
                    return null;
                }
            }
        }
    }

}

