/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ctrlX CORE - Data Layer API
 * This is the base API for the ctrlX Data Layer access on ctrlX CORE devices <ul> <li>Click 'Authorize' to open the 'Available authorizations' dialog.</li> <li>Enter 'username' and 'password'. The 'Client credentials location' selector together with the 'client_id' and 'client_secret' fields as well as the 'Bearer' section can be ignored.</li> <li>Click 'Authorize' and then 'Close' to close the 'Available authorizations' dialog.</li> <li>Try out those GET, PUT, ... operations you're interested in.</li> </ul>
 *
 * The version of the OpenAPI document: 2.1.0
 * Contact: support@boschrexroth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * List of available operations
 */
@JsonPropertyOrder({
  AllowedOperations.JSON_PROPERTY_READ,
  AllowedOperations.JSON_PROPERTY_WRITE,
  AllowedOperations.JSON_PROPERTY_CREATE,
  AllowedOperations.JSON_PROPERTY_DELETE,
  AllowedOperations.JSON_PROPERTY_BROWSE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-18T13:34:36.056861+01:00[Europe/Berlin]")
public class AllowedOperations {
  public static final String JSON_PROPERTY_READ = "read";
  private Boolean read;

  public static final String JSON_PROPERTY_WRITE = "write";
  private Boolean write;

  public static final String JSON_PROPERTY_CREATE = "create";
  private Boolean create;

  public static final String JSON_PROPERTY_DELETE = "delete";
  private Boolean delete;

  public static final String JSON_PROPERTY_BROWSE = "browse";
  private Boolean browse;

  public AllowedOperations() {
  }

  public AllowedOperations read(Boolean read) {
    
    this.read = read;
    return this;
  }

   /**
   * Node can be read
   * @return read
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_READ)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getRead() {
    return read;
  }


  @JsonProperty(JSON_PROPERTY_READ)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRead(Boolean read) {
    this.read = read;
  }


  public AllowedOperations write(Boolean write) {
    
    this.write = write;
    return this;
  }

   /**
   * Node can be written
   * @return write
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_WRITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getWrite() {
    return write;
  }


  @JsonProperty(JSON_PROPERTY_WRITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWrite(Boolean write) {
    this.write = write;
  }


  public AllowedOperations create(Boolean create) {
    
    this.create = create;
    return this;
  }

   /**
   * Node can be created
   * @return create
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCreate() {
    return create;
  }


  @JsonProperty(JSON_PROPERTY_CREATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreate(Boolean create) {
    this.create = create;
  }


  public AllowedOperations delete(Boolean delete) {
    
    this.delete = delete;
    return this;
  }

   /**
   * Node can be deleted
   * @return delete
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DELETE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getDelete() {
    return delete;
  }


  @JsonProperty(JSON_PROPERTY_DELETE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDelete(Boolean delete) {
    this.delete = delete;
  }


  public AllowedOperations browse(Boolean browse) {
    
    this.browse = browse;
    return this;
  }

   /**
   * Node can be browsed
   * @return browse
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_BROWSE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBrowse() {
    return browse;
  }


  @JsonProperty(JSON_PROPERTY_BROWSE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBrowse(Boolean browse) {
    this.browse = browse;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AllowedOperations allowedOperations = (AllowedOperations) o;
    return Objects.equals(this.read, allowedOperations.read) &&
        Objects.equals(this.write, allowedOperations.write) &&
        Objects.equals(this.create, allowedOperations.create) &&
        Objects.equals(this.delete, allowedOperations.delete) &&
        Objects.equals(this.browse, allowedOperations.browse);
  }

  @Override
  public int hashCode() {
    return Objects.hash(read, write, create, delete, browse);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AllowedOperations {\n");
    sb.append("    read: ").append(toIndentedString(read)).append("\n");
    sb.append("    write: ").append(toIndentedString(write)).append("\n");
    sb.append("    create: ").append(toIndentedString(create)).append("\n");
    sb.append("    delete: ").append(toIndentedString(delete)).append("\n");
    sb.append("    browse: ").append(toIndentedString(browse)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `read` to the URL query string
    if (getRead() != null) {
      try {
        joiner.add(String.format("%sread%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRead()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `write` to the URL query string
    if (getWrite() != null) {
      try {
        joiner.add(String.format("%swrite%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWrite()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `create` to the URL query string
    if (getCreate() != null) {
      try {
        joiner.add(String.format("%screate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `delete` to the URL query string
    if (getDelete() != null) {
      try {
        joiner.add(String.format("%sdelete%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDelete()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `browse` to the URL query string
    if (getBrowse() != null) {
      try {
        joiner.add(String.format("%sbrowse%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBrowse()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

