/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableMan is an enum
type OpcuaNodeIdServicesVariableMan int32

type IOpcuaNodeIdServicesVariableMan interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableMan_ManAddrIfSubtype_EnumValues OpcuaNodeIdServicesVariableMan = 18952
)

var OpcuaNodeIdServicesVariableManValues []OpcuaNodeIdServicesVariableMan

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableManValues = []OpcuaNodeIdServicesVariableMan{
		OpcuaNodeIdServicesVariableMan_ManAddrIfSubtype_EnumValues,
	}
}

func OpcuaNodeIdServicesVariableManByValue(value int32) (enum OpcuaNodeIdServicesVariableMan, ok bool) {
	switch value {
	case 18952:
		return OpcuaNodeIdServicesVariableMan_ManAddrIfSubtype_EnumValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableManByName(value string) (enum OpcuaNodeIdServicesVariableMan, ok bool) {
	switch value {
	case "ManAddrIfSubtype_EnumValues":
		return OpcuaNodeIdServicesVariableMan_ManAddrIfSubtype_EnumValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableManKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableManValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableMan(structType any) OpcuaNodeIdServicesVariableMan {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableMan {
		if sOpcuaNodeIdServicesVariableMan, ok := typ.(OpcuaNodeIdServicesVariableMan); ok {
			return sOpcuaNodeIdServicesVariableMan
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableMan) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableMan) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableManParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableMan, error) {
	return OpcuaNodeIdServicesVariableManParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableManParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableMan, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableMan", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableMan")
	}
	if enum, ok := OpcuaNodeIdServicesVariableManByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableMan")
		return OpcuaNodeIdServicesVariableMan(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableMan) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableMan) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableMan", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableMan) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableMan) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableMan_ManAddrIfSubtype_EnumValues:
		return "ManAddrIfSubtype_EnumValues"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableMan) String() string {
	return e.PLC4XEnumName()
}
