/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetTimerStateChangeValueDate is the corresponding interface of BACnetTimerStateChangeValueDate
type BACnetTimerStateChangeValueDate interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetTimerStateChangeValue
	// GetDateValue returns DateValue (property field)
	GetDateValue() BACnetApplicationTagDate
	// IsBACnetTimerStateChangeValueDate is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetTimerStateChangeValueDate()
	// CreateBuilder creates a BACnetTimerStateChangeValueDateBuilder
	CreateBACnetTimerStateChangeValueDateBuilder() BACnetTimerStateChangeValueDateBuilder
}

// _BACnetTimerStateChangeValueDate is the data-structure of this message
type _BACnetTimerStateChangeValueDate struct {
	BACnetTimerStateChangeValueContract
	DateValue BACnetApplicationTagDate
}

var _ BACnetTimerStateChangeValueDate = (*_BACnetTimerStateChangeValueDate)(nil)
var _ BACnetTimerStateChangeValueRequirements = (*_BACnetTimerStateChangeValueDate)(nil)

// NewBACnetTimerStateChangeValueDate factory function for _BACnetTimerStateChangeValueDate
func NewBACnetTimerStateChangeValueDate(peekedTagHeader BACnetTagHeader, dateValue BACnetApplicationTagDate, objectTypeArgument BACnetObjectType) *_BACnetTimerStateChangeValueDate {
	if dateValue == nil {
		panic("dateValue of type BACnetApplicationTagDate for BACnetTimerStateChangeValueDate must not be nil")
	}
	_result := &_BACnetTimerStateChangeValueDate{
		BACnetTimerStateChangeValueContract: NewBACnetTimerStateChangeValue(peekedTagHeader, objectTypeArgument),
		DateValue:                           dateValue,
	}
	_result.BACnetTimerStateChangeValueContract.(*_BACnetTimerStateChangeValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetTimerStateChangeValueDateBuilder is a builder for BACnetTimerStateChangeValueDate
type BACnetTimerStateChangeValueDateBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dateValue BACnetApplicationTagDate) BACnetTimerStateChangeValueDateBuilder
	// WithDateValue adds DateValue (property field)
	WithDateValue(BACnetApplicationTagDate) BACnetTimerStateChangeValueDateBuilder
	// WithDateValueBuilder adds DateValue (property field) which is build by the builder
	WithDateValueBuilder(func(BACnetApplicationTagDateBuilder) BACnetApplicationTagDateBuilder) BACnetTimerStateChangeValueDateBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetTimerStateChangeValueBuilder
	// Build builds the BACnetTimerStateChangeValueDate or returns an error if something is wrong
	Build() (BACnetTimerStateChangeValueDate, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetTimerStateChangeValueDate
}

// NewBACnetTimerStateChangeValueDateBuilder() creates a BACnetTimerStateChangeValueDateBuilder
func NewBACnetTimerStateChangeValueDateBuilder() BACnetTimerStateChangeValueDateBuilder {
	return &_BACnetTimerStateChangeValueDateBuilder{_BACnetTimerStateChangeValueDate: new(_BACnetTimerStateChangeValueDate)}
}

type _BACnetTimerStateChangeValueDateBuilder struct {
	*_BACnetTimerStateChangeValueDate

	parentBuilder *_BACnetTimerStateChangeValueBuilder

	collectedErr []error
}

var _ (BACnetTimerStateChangeValueDateBuilder) = (*_BACnetTimerStateChangeValueDateBuilder)(nil)

func (b *_BACnetTimerStateChangeValueDateBuilder) setParent(contract BACnetTimerStateChangeValueContract) {
	b.BACnetTimerStateChangeValueContract = contract
	contract.(*_BACnetTimerStateChangeValue)._SubType = b._BACnetTimerStateChangeValueDate
}

func (b *_BACnetTimerStateChangeValueDateBuilder) WithMandatoryFields(dateValue BACnetApplicationTagDate) BACnetTimerStateChangeValueDateBuilder {
	return b.WithDateValue(dateValue)
}

func (b *_BACnetTimerStateChangeValueDateBuilder) WithDateValue(dateValue BACnetApplicationTagDate) BACnetTimerStateChangeValueDateBuilder {
	b.DateValue = dateValue
	return b
}

func (b *_BACnetTimerStateChangeValueDateBuilder) WithDateValueBuilder(builderSupplier func(BACnetApplicationTagDateBuilder) BACnetApplicationTagDateBuilder) BACnetTimerStateChangeValueDateBuilder {
	builder := builderSupplier(b.DateValue.CreateBACnetApplicationTagDateBuilder())
	var err error
	b.DateValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagDateBuilder failed"))
	}
	return b
}

func (b *_BACnetTimerStateChangeValueDateBuilder) Build() (BACnetTimerStateChangeValueDate, error) {
	if b.DateValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'dateValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetTimerStateChangeValueDate.deepCopy(), nil
}

func (b *_BACnetTimerStateChangeValueDateBuilder) MustBuild() BACnetTimerStateChangeValueDate {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetTimerStateChangeValueDateBuilder) Done() BACnetTimerStateChangeValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetTimerStateChangeValueBuilder().(*_BACnetTimerStateChangeValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetTimerStateChangeValueDateBuilder) buildForBACnetTimerStateChangeValue() (BACnetTimerStateChangeValue, error) {
	return b.Build()
}

func (b *_BACnetTimerStateChangeValueDateBuilder) DeepCopy() any {
	_copy := b.CreateBACnetTimerStateChangeValueDateBuilder().(*_BACnetTimerStateChangeValueDateBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetTimerStateChangeValueDateBuilder creates a BACnetTimerStateChangeValueDateBuilder
func (b *_BACnetTimerStateChangeValueDate) CreateBACnetTimerStateChangeValueDateBuilder() BACnetTimerStateChangeValueDateBuilder {
	if b == nil {
		return NewBACnetTimerStateChangeValueDateBuilder()
	}
	return &_BACnetTimerStateChangeValueDateBuilder{_BACnetTimerStateChangeValueDate: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetTimerStateChangeValueDate) GetParent() BACnetTimerStateChangeValueContract {
	return m.BACnetTimerStateChangeValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetTimerStateChangeValueDate) GetDateValue() BACnetApplicationTagDate {
	return m.DateValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetTimerStateChangeValueDate(structType any) BACnetTimerStateChangeValueDate {
	if casted, ok := structType.(BACnetTimerStateChangeValueDate); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetTimerStateChangeValueDate); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetTimerStateChangeValueDate) GetTypeName() string {
	return "BACnetTimerStateChangeValueDate"
}

func (m *_BACnetTimerStateChangeValueDate) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetTimerStateChangeValueContract.(*_BACnetTimerStateChangeValue).getLengthInBits(ctx))

	// Simple field (dateValue)
	lengthInBits += m.DateValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetTimerStateChangeValueDate) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetTimerStateChangeValueDate) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetTimerStateChangeValue, objectTypeArgument BACnetObjectType) (__bACnetTimerStateChangeValueDate BACnetTimerStateChangeValueDate, err error) {
	m.BACnetTimerStateChangeValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetTimerStateChangeValueDate"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetTimerStateChangeValueDate")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dateValue, err := ReadSimpleField[BACnetApplicationTagDate](ctx, "dateValue", ReadComplex[BACnetApplicationTagDate](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagDate](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dateValue' field"))
	}
	m.DateValue = dateValue

	if closeErr := readBuffer.CloseContext("BACnetTimerStateChangeValueDate"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetTimerStateChangeValueDate")
	}

	return m, nil
}

func (m *_BACnetTimerStateChangeValueDate) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetTimerStateChangeValueDate) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetTimerStateChangeValueDate"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetTimerStateChangeValueDate")
		}

		if err := WriteSimpleField[BACnetApplicationTagDate](ctx, "dateValue", m.GetDateValue(), WriteComplex[BACnetApplicationTagDate](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dateValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetTimerStateChangeValueDate"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetTimerStateChangeValueDate")
		}
		return nil
	}
	return m.BACnetTimerStateChangeValueContract.(*_BACnetTimerStateChangeValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetTimerStateChangeValueDate) IsBACnetTimerStateChangeValueDate() {}

func (m *_BACnetTimerStateChangeValueDate) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetTimerStateChangeValueDate) deepCopy() *_BACnetTimerStateChangeValueDate {
	if m == nil {
		return nil
	}
	_BACnetTimerStateChangeValueDateCopy := &_BACnetTimerStateChangeValueDate{
		m.BACnetTimerStateChangeValueContract.(*_BACnetTimerStateChangeValue).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagDate](m.DateValue),
	}
	_BACnetTimerStateChangeValueDateCopy.BACnetTimerStateChangeValueContract.(*_BACnetTimerStateChangeValue)._SubType = m
	return _BACnetTimerStateChangeValueDateCopy
}

func (m *_BACnetTimerStateChangeValueDate) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
