/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Set;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.asm.AsmHelper;
import org.apache.openjpa.util.asm.ClassNodeTracker;
import org.apache.openjpa.util.asm.EnhancementProject;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.asm9.ClassVisitor;

public class PCClassFileTransformer
implements ClassFileTransformer {
    private static final Localizer _loc = Localizer.forPackage(PCClassFileTransformer.class);
    private final MetaDataRepository _repos;
    private final PCEnhancer.Flags _flags;
    private final ClassLoader _tmpLoader;
    private final Log _log;
    private final Set _names;

    public PCClassFileTransformer(MetaDataRepository repos, Options opts, ClassLoader loader) {
        this(repos, PCClassFileTransformer.toFlags(opts), loader, opts.removeBooleanProperty("scanDevPath", "ScanDevPath", false));
    }

    private static PCEnhancer.Flags toFlags(Options opts) {
        PCEnhancer.Flags flags = new PCEnhancer.Flags();
        flags.addDefaultConstructor = opts.removeBooleanProperty("addDefaultConstructor", "AddDefaultConstructor", flags.addDefaultConstructor);
        flags.enforcePropertyRestrictions = opts.removeBooleanProperty("enforcePropertyRestrictions", "EnforcePropertyRestrictions", flags.enforcePropertyRestrictions);
        return flags;
    }

    public PCClassFileTransformer(MetaDataRepository repos, PCEnhancer.Flags flags, ClassLoader tmpLoader, boolean devscan) {
        this._repos = repos;
        this._tmpLoader = tmpLoader;
        this._log = repos.getConfiguration().getLog("openjpa.Enhance");
        this._flags = flags;
        this._names = repos.getPersistentTypeNames(devscan, tmpLoader);
        if (this._names == null && this._log.isInfoEnabled()) {
            this._log.info(_loc.get("runtime-enhance-pcclasses"));
        }
    }

    public static PCClassFileTransformer newInstance(MetaDataRepository repos, Options parseProperties, ClassLoader tmpLoader) {
        return parseProperties != null && parseProperties.getBooleanProperty("Reentrant") ? new Reentrant(repos, parseProperties, tmpLoader) : new PCClassFileTransformer(repos, parseProperties, tmpLoader);
    }

    public byte[] transform(ClassLoader loader, String className, Class redef, ProtectionDomain domain, byte[] bytes) throws IllegalClassFormatException {
        if (loader == this._tmpLoader) {
            return null;
        }
        if (className == null) {
            return null;
        }
        return this.transform0(className, redef, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] transform0(String className, Class redef, byte[] bytes) throws IllegalClassFormatException {
        Object returnBytes = null;
        try {
            PCEnhancer enhancer;
            ClassLoader oldLoader;
            block16: {
                byte[] byArray;
                Boolean enhance = this.needsEnhance(className, redef, bytes);
                if (enhance != null && this._log.isTraceEnabled()) {
                    this._log.trace(_loc.get("needs-runtime-enhance", className, enhance));
                }
                if (enhance != Boolean.TRUE) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                oldLoader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
                AccessController.doPrivileged(J2DoPrivHelper.setContextClassLoaderAction(this._tmpLoader));
                try {
                    EnhancementProject project = new EnhancementProject();
                    ClassNodeTracker bc = project.loadClass(bytes, this._tmpLoader);
                    enhancer = new PCEnhancer(this._repos.getConfiguration(), bc, this._repos);
                    enhancer.setAddDefaultConstructor(this._flags.addDefaultConstructor);
                    enhancer.setEnforcePropertyRestrictions(this._flags.enforcePropertyRestrictions);
                    if (enhancer.run() != 0) break block16;
                    byArray = null;
                }
                catch (Throwable throwable) {
                    try {
                        AccessController.doPrivileged(J2DoPrivHelper.setContextClassLoaderAction(oldLoader));
                        throw throwable;
                    }
                    catch (Throwable t) {
                        this._log.warn(_loc.get("cft-exception-thrown", className), t);
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        if (t instanceof IllegalClassFormatException) {
                            throw (IllegalClassFormatException)t;
                        }
                        throw new GeneralException(t);
                    }
                }
                AccessController.doPrivileged(J2DoPrivHelper.setContextClassLoaderAction(oldLoader));
                return byArray;
            }
            ClassNodeTracker cnt = enhancer.getPCBytecode();
            byte[] byArray = AsmHelper.toByteArray(cnt);
            AccessController.doPrivileged(J2DoPrivHelper.setContextClassLoaderAction(oldLoader));
            return byArray;
        }
        finally {
            if (returnBytes != null && this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("runtime-enhance-complete", className, bytes.length, (returnBytes).length));
            }
        }
    }

    private Boolean needsEnhance(String clsName, Class redef, byte[] bytes) {
        if (redef != null && PersistenceCapable.class.isAssignableFrom(redef)) {
            return null;
        }
        if (this._names != null) {
            if (this._names.contains(clsName.replace('/', '.'))) {
                return !PCClassFileTransformer.isEnhanced(bytes);
            }
            return null;
        }
        if (clsName.startsWith("java/") || clsName.startsWith("javax/") || clsName.startsWith("jakarta/")) {
            return null;
        }
        if (PCClassFileTransformer.isEnhanced(bytes)) {
            return Boolean.FALSE;
        }
        try {
            Class<?> c = Class.forName(clsName.replace('/', '.'), false, this._tmpLoader);
            if (this._repos.getMetaData(c, null, false) != null) {
                return Boolean.TRUE;
            }
            return null;
        }
        catch (ClassNotFoundException | LinkageError cnfe) {
            return Boolean.FALSE;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new GeneralException(t);
        }
    }

    private static boolean isEnhanced(byte[] b) {
        if (b == null) {
            return false;
        }
        ClassReader cr = new ClassReader(b);
        try {
            cr.accept(new ClassVisitor(589824){

                @Override
                public void visit(int i, int i1, String name, String s, String parent, String[] interfaces) {
                    boolean enhanced;
                    boolean bl = enhanced = interfaces != null && interfaces.length > 0 && Arrays.asList(interfaces).contains("org/apache/openjpa/enhance/PersistenceCapable");
                    if (!(enhanced || name == null || parent == null || "java/lang/Object".equals(parent) || name.equals(parent))) {
                        enhanced = PCClassFileTransformer.isEnhanced(AsmHelper.getClassBytes(parent));
                    }
                    throw new EnhancedStatusException(enhanced);
                }
            }, 0);
            return false;
        }
        catch (EnhancedStatusException e) {
            return e.status;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class Reentrant
    extends PCClassFileTransformer {
        private final ThreadLocal<Boolean> transforming = new ThreadLocal();

        public Reentrant(MetaDataRepository repos, Options opts, ClassLoader loader) {
            super(repos, opts, loader);
        }

        public Reentrant(MetaDataRepository repos, PCEnhancer.Flags flags, ClassLoader tmpLoader, boolean devscan) {
            super(repos, flags, tmpLoader, devscan);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected byte[] transform0(String className, Class redef, byte[] bytes) throws IllegalClassFormatException {
            if (this.transforming.get() != null) {
                return bytes;
            }
            this.transforming.set(true);
            try {
                byte[] byArray = super.transform0(className, redef, bytes);
                return byArray;
            }
            finally {
                this.transforming.remove();
            }
        }
    }

    private static class EnhancedStatusException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final boolean status;

        private EnhancedStatusException(boolean status) {
            this.status = status;
        }
    }
}

