/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmAssociation;
import org.apache.olingo.odata2.api.edm.EdmComplexType;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmServiceMetadata;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.exception.ODataException;

public abstract class EdmImpl
implements Edm {
    private Map<String, EdmEntityContainer> edmEntityContainers = new HashMap<String, EdmEntityContainer>();
    private Map<FullQualifiedName, EdmEntityType> edmEntityTypes = new HashMap<FullQualifiedName, EdmEntityType>();
    private Map<FullQualifiedName, EdmComplexType> edmComplexTypes = new HashMap<FullQualifiedName, EdmComplexType>();
    private Map<FullQualifiedName, EdmAssociation> edmAssociations = new HashMap<FullQualifiedName, EdmAssociation>();
    private Map<String, String> aliasToNamespaceInfo;
    private List<EdmEntitySet> edmEntitySets;
    private List<EdmFunctionImport> edmFunctionImports;
    protected EdmServiceMetadata edmServiceMetadata;

    public EdmImpl(EdmServiceMetadata edmServiceMetadata) {
        this.edmServiceMetadata = edmServiceMetadata;
    }

    public EdmEntityContainer getEntityContainer(String name) throws EdmException {
        if (this.edmEntityContainers.containsKey(name)) {
            return this.edmEntityContainers.get(name);
        }
        EdmEntityContainer edmEntityContainer = null;
        try {
            edmEntityContainer = this.createEntityContainer(name);
            if (edmEntityContainer != null) {
                if (name == null && this.edmEntityContainers.containsKey(edmEntityContainer.getName())) {
                    edmEntityContainer = this.edmEntityContainers.get(edmEntityContainer.getName());
                    this.edmEntityContainers.put(name, edmEntityContainer);
                } else if (this.edmEntityContainers.containsKey(null) && this.edmEntityContainers.get(null) != null && name != null && name.equals(this.edmEntityContainers.get(null).getName())) {
                    edmEntityContainer = this.edmEntityContainers.get(null);
                    this.edmEntityContainers.put(name, edmEntityContainer);
                } else {
                    this.edmEntityContainers.put(name, edmEntityContainer);
                }
            }
        }
        catch (EdmException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new EdmException(EdmException.COMMON, (Throwable)e);
        }
        return edmEntityContainer;
    }

    public EdmEntityType getEntityType(String namespaceOrAlias, String name) throws EdmException {
        String finalNamespace = this.getNamespaceForAlias(namespaceOrAlias);
        FullQualifiedName fqName = new FullQualifiedName(finalNamespace, name);
        if (this.edmEntityTypes.containsKey(fqName)) {
            return this.edmEntityTypes.get(fqName);
        }
        EdmEntityType edmEntityType = null;
        try {
            edmEntityType = this.createEntityType(fqName);
            if (edmEntityType != null) {
                this.edmEntityTypes.put(fqName, edmEntityType);
            }
        }
        catch (EdmException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new EdmException(EdmException.COMMON, (Throwable)e);
        }
        return edmEntityType;
    }

    private String getNamespaceForAlias(String namespaceOrAlias) throws EdmException {
        String namespace;
        if (this.aliasToNamespaceInfo == null) {
            try {
                this.aliasToNamespaceInfo = this.createAliasToNamespaceInfo();
                if (this.aliasToNamespaceInfo == null) {
                    this.aliasToNamespaceInfo = new HashMap<String, String>();
                }
            }
            catch (EdmException e) {
                throw e;
            }
            catch (ODataException e) {
                throw new EdmException(EdmException.COMMON, (Throwable)e);
            }
        }
        if ((namespace = this.aliasToNamespaceInfo.get(namespaceOrAlias)) == null) {
            namespace = namespaceOrAlias;
        }
        return namespace;
    }

    public EdmComplexType getComplexType(String namespaceOrAlias, String name) throws EdmException {
        String finalNamespace = this.getNamespaceForAlias(namespaceOrAlias);
        FullQualifiedName fqName = new FullQualifiedName(finalNamespace, name);
        if (this.edmComplexTypes.containsKey(fqName)) {
            return this.edmComplexTypes.get(fqName);
        }
        EdmComplexType edmComplexType = null;
        try {
            edmComplexType = this.createComplexType(fqName);
            if (edmComplexType != null) {
                this.edmComplexTypes.put(fqName, edmComplexType);
            }
        }
        catch (EdmException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new EdmException(EdmException.COMMON, (Throwable)e);
        }
        return edmComplexType;
    }

    public EdmAssociation getAssociation(String namespaceOrAlias, String name) throws EdmException {
        String finalNamespace = this.getNamespaceForAlias(namespaceOrAlias);
        FullQualifiedName fqName = new FullQualifiedName(finalNamespace, name);
        if (this.edmAssociations.containsKey(fqName)) {
            return this.edmAssociations.get(fqName);
        }
        EdmAssociation edmAssociation = null;
        try {
            edmAssociation = this.createAssociation(fqName);
            if (edmAssociation != null) {
                this.edmAssociations.put(fqName, edmAssociation);
            }
        }
        catch (EdmException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new EdmException(EdmException.COMMON, (Throwable)e);
        }
        return edmAssociation;
    }

    public EdmServiceMetadata getServiceMetadata() {
        return this.edmServiceMetadata;
    }

    public EdmEntityContainer getDefaultEntityContainer() throws EdmException {
        return this.getEntityContainer(null);
    }

    public List<EdmEntitySet> getEntitySets() throws EdmException {
        try {
            if (this.edmEntitySets == null) {
                this.edmEntitySets = this.createEntitySets();
            }
        }
        catch (EdmException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new EdmException(EdmException.COMMON, (Throwable)e);
        }
        return this.edmEntitySets;
    }

    public List<EdmFunctionImport> getFunctionImports() throws EdmException {
        try {
            if (this.edmFunctionImports == null) {
                this.edmFunctionImports = this.createFunctionImports();
            }
        }
        catch (EdmException e) {
            throw e;
        }
        catch (ODataException e) {
            throw new EdmException(EdmException.COMMON, (Throwable)e);
        }
        return this.edmFunctionImports;
    }

    protected abstract EdmEntityContainer createEntityContainer(String var1) throws ODataException;

    protected abstract EdmEntityType createEntityType(FullQualifiedName var1) throws ODataException;

    protected abstract EdmComplexType createComplexType(FullQualifiedName var1) throws ODataException;

    protected abstract EdmAssociation createAssociation(FullQualifiedName var1) throws ODataException;

    protected abstract List<EdmEntitySet> createEntitySets() throws ODataException;

    protected abstract List<EdmFunctionImport> createFunctionImports() throws ODataException;

    protected abstract Map<String, String> createAliasToNamespaceInfo() throws ODataException;
}

