/****************************************************************************
 * arch/arm64/src/imx9/hardware/imx93/imx93_iomux.h
 *
 * Licensed to the Apache Software Foundation     (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_ARM64_SRC_IMX9_HARDWARE_IMX93_IMX93_IOMUX_H
#define __ARCH_ARM64_SRC_IMX9_HARDWARE_IMX93_IMX93_IOMUX_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* Register offsets */

#define IOMUXC_MUX_CTL_DAP_TDI_OFFSET           (0x0000)
#define IOMUXC_MUX_CTL_DAP_TMS_SWDIO_OFFSET     (0x0004)
#define IOMUXC_MUX_CTL_DAP_TCLK_SWCLK_OFFSET    (0x0008)
#define IOMUXC_MUX_CTL_DAP_TDO_TRACESWO_OFFSET  (0x000C)
#define IOMUXC_MUX_CTL_GPIO_IO00_OFFSET         (0x0010)
#define IOMUXC_MUX_CTL_GPIO_IO01_OFFSET         (0x0014)
#define IOMUXC_MUX_CTL_GPIO_IO02_OFFSET         (0x0018)
#define IOMUXC_MUX_CTL_GPIO_IO03_OFFSET         (0x001C)
#define IOMUXC_MUX_CTL_GPIO_IO04_OFFSET         (0x0020)
#define IOMUXC_MUX_CTL_GPIO_IO05_OFFSET         (0x0024)
#define IOMUXC_MUX_CTL_GPIO_IO06_OFFSET         (0x0028)
#define IOMUXC_MUX_CTL_GPIO_IO07_OFFSET         (0x002C)
#define IOMUXC_MUX_CTL_GPIO_IO08_OFFSET         (0x0030)
#define IOMUXC_MUX_CTL_GPIO_IO09_OFFSET         (0x0034)
#define IOMUXC_MUX_CTL_GPIO_IO10_OFFSET         (0x0038)
#define IOMUXC_MUX_CTL_GPIO_IO11_OFFSET         (0x003C)
#define IOMUXC_MUX_CTL_GPIO_IO12_OFFSET         (0x0040)
#define IOMUXC_MUX_CTL_GPIO_IO13_OFFSET         (0x0044)
#define IOMUXC_MUX_CTL_GPIO_IO14_OFFSET         (0x0048)
#define IOMUXC_MUX_CTL_GPIO_IO15_OFFSET         (0x004C)
#define IOMUXC_MUX_CTL_GPIO_IO16_OFFSET         (0x0050)
#define IOMUXC_MUX_CTL_GPIO_IO17_OFFSET         (0x0054)
#define IOMUXC_MUX_CTL_GPIO_IO18_OFFSET         (0x0058)
#define IOMUXC_MUX_CTL_GPIO_IO19_OFFSET         (0x005C)
#define IOMUXC_MUX_CTL_GPIO_IO20_OFFSET         (0x0060)
#define IOMUXC_MUX_CTL_GPIO_IO21_OFFSET         (0x0064)
#define IOMUXC_MUX_CTL_GPIO_IO22_OFFSET         (0x0068)
#define IOMUXC_MUX_CTL_GPIO_IO23_OFFSET         (0x006C)
#define IOMUXC_MUX_CTL_GPIO_IO24_OFFSET         (0x0070)
#define IOMUXC_MUX_CTL_GPIO_IO25_OFFSET         (0x0074)
#define IOMUXC_MUX_CTL_GPIO_IO26_OFFSET         (0x0078)
#define IOMUXC_MUX_CTL_GPIO_IO27_OFFSET         (0x007C)
#define IOMUXC_MUX_CTL_GPIO_IO28_OFFSET         (0x0080)
#define IOMUXC_MUX_CTL_GPIO_IO29_OFFSET         (0x0084)
#define IOMUXC_MUX_CTL_CCM_CLKO1_OFFSET         (0x0088)
#define IOMUXC_MUX_CTL_CCM_CLKO2_OFFSET         (0x008C)
#define IOMUXC_MUX_CTL_CCM_CLKO3_OFFSET         (0x0090)
#define IOMUXC_MUX_CTL_CCM_CLKO4_OFFSET         (0x0094)
#define IOMUXC_MUX_CTL_ENET1_MDC_OFFSET         (0x0098)
#define IOMUXC_MUX_CTL_ENET1_MDIO_OFFSET        (0x009C)
#define IOMUXC_MUX_CTL_ENET1_TD3_OFFSET         (0x00A0)
#define IOMUXC_MUX_CTL_ENET1_TD2_OFFSET         (0x00A4)
#define IOMUXC_MUX_CTL_ENET1_TD1_OFFSET         (0x00A8)
#define IOMUXC_MUX_CTL_ENET1_TD0_OFFSET         (0x00AC)
#define IOMUXC_MUX_CTL_ENET1_TX_CTL_OFFSET      (0x00B0)
#define IOMUXC_MUX_CTL_ENET1_TXC_OFFSET         (0x00B4)
#define IOMUXC_MUX_CTL_ENET1_RX_CTL_OFFSET      (0x00B8)
#define IOMUXC_MUX_CTL_ENET1_RXC_OFFSET         (0x00BC)
#define IOMUXC_MUX_CTL_ENET1_RD0_OFFSET         (0x00C0)
#define IOMUXC_MUX_CTL_ENET1_RD1_OFFSET         (0x00C4)
#define IOMUXC_MUX_CTL_ENET1_RD2_OFFSET         (0x00C8)
#define IOMUXC_MUX_CTL_ENET1_RD3_OFFSET         (0x00CC)
#define IOMUXC_MUX_CTL_ENET2_MDC_OFFSET         (0x00D0)
#define IOMUXC_MUX_CTL_ENET2_MDIO_OFFSET        (0x00D4)
#define IOMUXC_MUX_CTL_ENET2_TD3_OFFSET         (0x00D8)
#define IOMUXC_MUX_CTL_ENET2_TD2_OFFSET         (0x00DC)
#define IOMUXC_MUX_CTL_ENET2_TD1_OFFSET         (0x00E0)
#define IOMUXC_MUX_CTL_ENET2_TD0_OFFSET         (0x00E4)
#define IOMUXC_MUX_CTL_ENET2_TX_CTL_OFFSET      (0x00E8)
#define IOMUXC_MUX_CTL_ENET2_TXC_OFFSET         (0x00EC)
#define IOMUXC_MUX_CTL_ENET2_RX_CTL_OFFSET      (0x00F0)
#define IOMUXC_MUX_CTL_ENET2_RXC_OFFSET         (0x00F4)
#define IOMUXC_MUX_CTL_ENET2_RD0_OFFSET         (0x00F8)
#define IOMUXC_MUX_CTL_ENET2_RD1_OFFSET         (0x00FC)
#define IOMUXC_MUX_CTL_ENET2_RD2_OFFSET         (0x0100)
#define IOMUXC_MUX_CTL_ENET2_RD3_OFFSET         (0x0104)
#define IOMUXC_MUX_CTL_SD1_CLK_OFFSET           (0x0108)
#define IOMUXC_MUX_CTL_SD1_CMD_OFFSET           (0x010C)
#define IOMUXC_MUX_CTL_SD1_DATA0_OFFSET         (0x0110)
#define IOMUXC_MUX_CTL_SD1_DATA1_OFFSET         (0x0114)
#define IOMUXC_MUX_CTL_SD1_DATA2_OFFSET         (0x0118)
#define IOMUXC_MUX_CTL_SD1_DATA3_OFFSET         (0x011C)
#define IOMUXC_MUX_CTL_SD1_DATA4_OFFSET         (0x0120)
#define IOMUXC_MUX_CTL_SD1_DATA5_OFFSET         (0x0124)
#define IOMUXC_MUX_CTL_SD1_DATA6_OFFSET         (0x0128)
#define IOMUXC_MUX_CTL_SD1_DATA7_OFFSET         (0x012C)
#define IOMUXC_MUX_CTL_SD1_STROBE_OFFSET        (0x0130)
#define IOMUXC_MUX_CTL_SD2_VSELECT_OFFSET       (0x0134)
#define IOMUXC_MUX_CTL_SD3_CLK_OFFSET           (0x0138)
#define IOMUXC_MUX_CTL_SD3_CMD_OFFSET           (0x013C)
#define IOMUXC_MUX_CTL_SD3_DATA0_OFFSET         (0x0140)
#define IOMUXC_MUX_CTL_SD3_DATA1_OFFSET         (0x0144)
#define IOMUXC_MUX_CTL_SD3_DATA2_OFFSET         (0x0148)
#define IOMUXC_MUX_CTL_SD3_DATA3_OFFSET         (0x014C)
#define IOMUXC_MUX_CTL_SD2_CD_B_OFFSET          (0x0150)
#define IOMUXC_MUX_CTL_SD2_CLK_OFFSET           (0x0154)
#define IOMUXC_MUX_CTL_SD2_CMD_OFFSET           (0x0158)
#define IOMUXC_MUX_CTL_SD2_DATA0_OFFSET         (0x015C)
#define IOMUXC_MUX_CTL_SD2_DATA1_OFFSET         (0x0160)
#define IOMUXC_MUX_CTL_SD2_DATA2_OFFSET         (0x0164)
#define IOMUXC_MUX_CTL_SD2_DATA3_OFFSET         (0x0168)
#define IOMUXC_MUX_CTL_SD2_RESET_B_OFFSET       (0x016C)
#define IOMUXC_MUX_CTL_I2C1_SCL_OFFSET          (0x0170)
#define IOMUXC_MUX_CTL_I2C1_SDA_OFFSET          (0x0174)
#define IOMUXC_MUX_CTL_I2C2_SCL_OFFSET          (0x0178)
#define IOMUXC_MUX_CTL_I2C2_SDA_OFFSET          (0x017C)
#define IOMUXC_MUX_CTL_UART1_RXD_OFFSET         (0x0180)
#define IOMUXC_MUX_CTL_UART1_TXD_OFFSET         (0x0184)
#define IOMUXC_MUX_CTL_UART2_RXD_OFFSET         (0x0188)
#define IOMUXC_MUX_CTL_UART2_TXD_OFFSET         (0x018C)
#define IOMUXC_MUX_CTL_PDM_CLK_OFFSET           (0x0190)
#define IOMUXC_MUX_CTL_PDM_BIT_STREAM0_OFFSET   (0x0194)
#define IOMUXC_MUX_CTL_PDM_BIT_STREAM1_OFFSET   (0x0198)
#define IOMUXC_MUX_CTL_SAI1_TXFS_OFFSET         (0x019C)
#define IOMUXC_MUX_CTL_SAI1_TXC_OFFSET          (0x01A0)
#define IOMUXC_MUX_CTL_SAI1_TXD0_OFFSET         (0x01A4)
#define IOMUXC_MUX_CTL_SAI1_RXD0_OFFSET         (0x01A8)
#define IOMUXC_MUX_CTL_WDOG_ANY_OFFSET          (0x01AC)

#define IOMUXC_PAD_CTL_DAP_TDI_OFFSET           (0x01B0)
#define IOMUXC_PAD_CTL_DAP_TMS_SWDIO_OFFSET     (0x01B4)
#define IOMUXC_PAD_CTL_DAP_TCLK_SWCLK_OFFSET    (0x01B8)
#define IOMUXC_PAD_CTL_DAP_TDO_TRACESWO_OFFSET  (0x01BC)
#define IOMUXC_PAD_CTL_GPIO_IO00_OFFSET         (0x01C0)
#define IOMUXC_PAD_CTL_GPIO_IO01_OFFSET         (0x01C4)
#define IOMUXC_PAD_CTL_GPIO_IO02_OFFSET         (0x01C8)
#define IOMUXC_PAD_CTL_GPIO_IO03_OFFSET         (0x01CC)
#define IOMUXC_PAD_CTL_GPIO_IO04_OFFSET         (0x01D0)
#define IOMUXC_PAD_CTL_GPIO_IO05_OFFSET         (0x01D4)
#define IOMUXC_PAD_CTL_GPIO_IO06_OFFSET         (0x01D8)
#define IOMUXC_PAD_CTL_GPIO_IO07_OFFSET         (0x01DC)
#define IOMUXC_PAD_CTL_GPIO_IO08_OFFSET         (0x01E0)
#define IOMUXC_PAD_CTL_GPIO_IO09_OFFSET         (0x01E4)
#define IOMUXC_PAD_CTL_GPIO_IO10_OFFSET         (0x01E8)
#define IOMUXC_PAD_CTL_GPIO_IO11_OFFSET         (0x01EC)
#define IOMUXC_PAD_CTL_GPIO_IO12_OFFSET         (0x01F0)
#define IOMUXC_PAD_CTL_GPIO_IO13_OFFSET         (0x01F4)
#define IOMUXC_PAD_CTL_GPIO_IO14_OFFSET         (0x01F8)
#define IOMUXC_PAD_CTL_GPIO_IO15_OFFSET         (0x01FC)
#define IOMUXC_PAD_CTL_GPIO_IO16_OFFSET         (0x0200)
#define IOMUXC_PAD_CTL_GPIO_IO17_OFFSET         (0x0204)
#define IOMUXC_PAD_CTL_GPIO_IO18_OFFSET         (0x0208)
#define IOMUXC_PAD_CTL_GPIO_IO19_OFFSET         (0x020C)
#define IOMUXC_PAD_CTL_GPIO_IO20_OFFSET         (0x0210)
#define IOMUXC_PAD_CTL_GPIO_IO21_OFFSET         (0x0214)
#define IOMUXC_PAD_CTL_GPIO_IO22_OFFSET         (0x0218)
#define IOMUXC_PAD_CTL_GPIO_IO23_OFFSET         (0x021C)
#define IOMUXC_PAD_CTL_GPIO_IO24_OFFSET         (0x0220)
#define IOMUXC_PAD_CTL_GPIO_IO25_OFFSET         (0x0224)
#define IOMUXC_PAD_CTL_GPIO_IO26_OFFSET         (0x0228)
#define IOMUXC_PAD_CTL_GPIO_IO27_OFFSET         (0x022C)
#define IOMUXC_PAD_CTL_GPIO_IO28_OFFSET         (0x0230)
#define IOMUXC_PAD_CTL_GPIO_IO29_OFFSET         (0x0234)
#define IOMUXC_PAD_CTL_CCM_CLKO1_OFFSET         (0x0238)
#define IOMUXC_PAD_CTL_CCM_CLKO2_OFFSET         (0x023C)
#define IOMUXC_PAD_CTL_CCM_CLKO3_OFFSET         (0x0240)
#define IOMUXC_PAD_CTL_CCM_CLKO4_OFFSET         (0x0244)
#define IOMUXC_PAD_CTL_ENET1_MDC_OFFSET         (0x0248)
#define IOMUXC_PAD_CTL_ENET1_MDIO_OFFSET        (0x024C)
#define IOMUXC_PAD_CTL_ENET1_TD3_OFFSET         (0x0250)
#define IOMUXC_PAD_CTL_ENET1_TD2_OFFSET         (0x0254)
#define IOMUXC_PAD_CTL_ENET1_TD1_OFFSET         (0x0258)
#define IOMUXC_PAD_CTL_ENET1_TD0_OFFSET         (0x025C)
#define IOMUXC_PAD_CTL_ENET1_TX_CTL_OFFSET      (0x0260)
#define IOMUXC_PAD_CTL_ENET1_TXC_OFFSET         (0x0264)
#define IOMUXC_PAD_CTL_ENET1_RX_CTL_OFFSET      (0x0268)
#define IOMUXC_PAD_CTL_ENET1_RXC_OFFSET         (0x026C)
#define IOMUXC_PAD_CTL_ENET1_RD0_OFFSET         (0x0270)
#define IOMUXC_PAD_CTL_ENET1_RD1_OFFSET         (0x0274)
#define IOMUXC_PAD_CTL_ENET1_RD2_OFFSET         (0x0278)
#define IOMUXC_PAD_CTL_ENET1_RD3_OFFSET         (0x027C)
#define IOMUXC_PAD_CTL_ENET2_MDC_OFFSET         (0x0280)
#define IOMUXC_PAD_CTL_ENET2_MDIO_OFFSET        (0x0284)
#define IOMUXC_PAD_CTL_ENET2_TD3_OFFSET         (0x0288)
#define IOMUXC_PAD_CTL_ENET2_TD2_OFFSET         (0x028C)
#define IOMUXC_PAD_CTL_ENET2_TD1_OFFSET         (0x01B0)
#define IOMUXC_PAD_CTL_ENET2_TD0_OFFSET         (0x01B0)
#define IOMUXC_PAD_CTL_ENET2_TX_CTL_OFFSET      (0x01B0)
#define IOMUXC_PAD_CTL_ENET2_TXC_OFFSET         (0x029C)
#define IOMUXC_PAD_CTL_ENET2_RX_CTL_OFFSET      (0x02A0)
#define IOMUXC_PAD_CTL_ENET2_RXC_OFFSET         (0x02A4)
#define IOMUXC_PAD_CTL_ENET2_RD0_OFFSET         (0x02A8)
#define IOMUXC_PAD_CTL_ENET2_RD1_OFFSET         (0x02AC)
#define IOMUXC_PAD_CTL_ENET2_RD2_OFFSET         (0x02B0)
#define IOMUXC_PAD_CTL_ENET2_RD3_OFFSET         (0x02B4)
#define IOMUXC_PAD_CTL_SD1_CLK_OFFSET           (0x02B8)
#define IOMUXC_PAD_CTL_SD1_CMD_OFFSET           (0x02BC)
#define IOMUXC_PAD_CTL_SD1_DATA0_OFFSET         (0x02C0)
#define IOMUXC_PAD_CTL_SD1_DATA1_OFFSET         (0x02C4)
#define IOMUXC_PAD_CTL_SD1_DATA2_OFFSET         (0x02C8)
#define IOMUXC_PAD_CTL_SD1_DATA3_OFFSET         (0x02CC)
#define IOMUXC_PAD_CTL_SD1_DATA4_OFFSET         (0x02D0)
#define IOMUXC_PAD_CTL_SD1_DATA5_OFFSET         (0x02D4)
#define IOMUXC_PAD_CTL_SD1_DATA6_OFFSET         (0x02D8)
#define IOMUXC_PAD_CTL_SD1_DATA7_OFFSET         (0x02DC)
#define IOMUXC_PAD_CTL_SD1_STROBE_OFFSET        (0x02E0)
#define IOMUXC_PAD_CTL_SD2_VSELECT_OFFSET       (0x02E4)
#define IOMUXC_PAD_CTL_SD3_CLK_OFFSET           (0x02E8)
#define IOMUXC_PAD_CTL_SD3_CMD_OFFSET           (0x02EC)
#define IOMUXC_PAD_CTL_SD3_DATA0_OFFSET         (0x02F0)
#define IOMUXC_PAD_CTL_SD3_DATA1_OFFSET         (0x02F4)
#define IOMUXC_PAD_CTL_SD3_DATA2_OFFSET         (0x02F8)
#define IOMUXC_PAD_CTL_SD3_DATA3_OFFSET         (0x02FC)
#define IOMUXC_PAD_CTL_SD2_CD_B_OFFSET          (0x0300)
#define IOMUXC_PAD_CTL_SD2_CLK_OFFSET           (0x0304)
#define IOMUXC_PAD_CTL_SD2_CMD_OFFSET           (0x0308)
#define IOMUXC_PAD_CTL_SD2_DATA0_OFFSET         (0x030C)
#define IOMUXC_PAD_CTL_SD2_DATA1_OFFSET         (0x0310)
#define IOMUXC_PAD_CTL_SD2_DATA2_OFFSET         (0x0314)
#define IOMUXC_PAD_CTL_SD2_DATA3_OFFSET         (0x0318)
#define IOMUXC_PAD_CTL_SD2_RESET_B_OFFSET       (0x031C)
#define IOMUXC_PAD_CTL_I2C1_SCL_OFFSET          (0x0320)
#define IOMUXC_PAD_CTL_I2C1_SDA_OFFSET          (0x0324)
#define IOMUXC_PAD_CTL_I2C2_SCL_OFFSET          (0x0328)
#define IOMUXC_PAD_CTL_I2C2_SDA_OFFSET          (0x032C)
#define IOMUXC_PAD_CTL_UART1_RXD_OFFSET         (0x0330)
#define IOMUXC_PAD_CTL_UART1_TXD_OFFSET         (0x0334)
#define IOMUXC_PAD_CTL_UART2_RXD_OFFSET         (0x0338)
#define IOMUXC_PAD_CTL_UART2_TXD_OFFSET         (0x033C)
#define IOMUXC_PAD_CTL_PDM_CLK_OFFSET           (0x0340)
#define IOMUXC_PAD_CTL_PDM_BIT_STREAM0_OFFSET   (0x0344)
#define IOMUXC_PAD_CTL_PDM_BIT_STREAM1_OFFSET   (0x0348)
#define IOMUXC_PAD_CTL_SAI1_TXFS_OFFSET         (0x034C)
#define IOMUXC_PAD_CTL_SAI1_TXC_OFFSET          (0x0350)
#define IOMUXC_PAD_CTL_SAI1_TXD0_OFFSET         (0x0354)
#define IOMUXC_PAD_CTL_SAI1_RXD0_OFFSET         (0x0358)
#define IOMUXC_PAD_CTL_WDOG_ANY_OFFSET          (0x035C)

#define CAN1_IPP_IND_CANRX_SELECT_INPUT_OFFSET          (0x0360)
#define CAN2_IPP_IND_CANRX_SELECT_INPUT_OFFSET          (0x0364)
#define CCMSRCGPCMIX_EXT1_CLK_SELECT_INPUT_OFFSET       (0x0368)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_0_OFFSET    (0x036C)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_1_OFFSET    (0x0370)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_2_OFFSET    (0x0374)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_3_OFFSET    (0x0378)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_4_OFFSET    (0x037C)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_5_OFFSET    (0x0380)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_6_OFFSET    (0x0384)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_7_OFFSET    (0x0388)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_8_OFFSET    (0x038C)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_9_OFFSET    (0x0390)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_10_OFFSET   (0x0394)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_11_OFFSET   (0x0398)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_13_OFFSET   (0x039C)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_14_OFFSET   (0x03A0)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_15_OFFSET   (0x03A4)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_16_OFFSET   (0x03A8)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_17_OFFSET   (0x03AC)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_18_OFFSET   (0x03B0)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_20_OFFSET   (0x03B4)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_22_OFFSET   (0x03B8)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_23_OFFSET   (0x03BC)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_24_OFFSET   (0x03C0)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_25_OFFSET   (0x03C4)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_27_OFFSET   (0x03C8)
#define I3C2_PIN_SCL_IN_SELECT_INPUT_OFFSET             (0x03CC)
#define I3C2_PIN_SDA_IN_SELECT_INPUT_OFFSET             (0x03D0)
#define JTAG_MUX_TCK_SELECT_INPUT_OFFSET                (0x03D4)
#define JTAG_MUX_TDI_SELECT_INPUT_OFFSET                (0x03D8)
#define JTAG_MUX_TMS_SELECT_INPUT_OFFSET                (0x03DC)
#define LP12C3_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET    (0x03E0)
#define LPI12C3_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET   (0x03E4)
#define LP12C5_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET    (0x03E8)
#define LP12C5_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET    (0x03EC)
#define LPI2C6_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET    (0x03F0)
#define LPI2C6_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET    (0x03F4)
#define LPI2C7_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET    (0x03F8)
#define LPI2C7_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET    (0x03FC)
#define LPI2C8_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET    (0x0400)
#define LPI2C8_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET    (0x0404)
#define LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_O_OFFSET    (0x0408)
#define LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_1_OFFSET    (0x040C)
#define LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_2_OFFSET    (0x0410)
#define LPUART3_IPP_IND_LPUART_CTS_N_SELECT_INP_OFFSET  (0x0414)
#define LPUART3_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET  (0x0418)
#define LPUART3_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET  (0x041C)
#define LPUART4_IPP_IND_LPUART_CTS_N_SELECT_INP_OFFSET  (0x0420)
#define LPUART4_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET  (0x0424)
#define LPUART4_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET  (0x0428)
#define LPUARTS_IPP_IND_LPUART_CTS_N_SELECT_INP_OFFSET  (0x042C)
#define LPUARTS_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET  (0x0430)
#define LPUARTS_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET  (0x0434)
#define SAI1_IPP_IND_SAI_MCLK_SELECT_INPUT_OFFSET       (0x0448)
#define SAI3_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET     (0x044c)
#define SAI3_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET     (0x0450)
#define SPDIF_SPDIF_I_SELECT_INPUT_OFFSET               (0x0454)
#define USDHC3_IPP_CARD_CLK_IN_SELECT_INPUT_OFFSET      (0x0458)
#define USDHC3_IPP_CMD_IN_SELECT_INPUT_OFFSET           (0x045C)
#define USDHC3_IPP_DATO_IN_SELECT_INPUT_OFFSET          (0x0460)
#define USDHC3_IPP_DAT1_IN_SELECT_INPUT_OFFSET          (0x0464)
#define USDHC3_IPP_DAT2_IN_SELECT_INPUT_OFFSET          (0x0468)
#define USDHC3_IPP_DAT3_IN_SELECT_INPUT_OFFSET          (0x046C)

/* Register addresses */

#define IOMUXC_MUX_CTL_DAP_TDI          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_DAP_TDI_OFFSET)
#define IOMUXC_MUX_CTL_DAP_TMS_SWDIO    (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_DAP_TMS_SWDIO_OFFSET)
#define IOMUXC_MUX_CTL_DAP_TCLK_SWCLK   (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_DAP_TCLK_SWCLK_OFFSET)
#define IOMUXC_MUX_CTL_DAP_TDO_TRACESWO (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_DAP_TDO_TRACESWO_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO00        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO00_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO01        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO01_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO02        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO02_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO03        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO03_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO04        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO04_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO05        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO05_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO06        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO06_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO07        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO07_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO08        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO08_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO09        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO09_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO10        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO10_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO11        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO11_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO12        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO12_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO13        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO13_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO14        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO14_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO15        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO15_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO16        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO16_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO17        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO17_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO18        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO18_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO19        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO19_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO20        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO20_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO21        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO21_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO22        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO22_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO23        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO23_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO24        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO24_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO25        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO25_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO26        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO26_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO27        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO27_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO28        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO28_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO29        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO29_OFFSET)
#define IOMUXC_MUX_CTL_CCM_CLKO1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_CCM_CLKO1_OFFSET)
#define IOMUXC_MUX_CTL_CCM_CLKO2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_CCM_CLKO2_OFFSET)
#define IOMUXC_MUX_CTL_CCM_CLKO3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_CCM_CLKO3_OFFSET)
#define IOMUXC_MUX_CTL_CCM_CLKO4        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_CCM_CLKO4_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_MDC        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_MDC_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_MDIO       (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_MDIO_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_TD3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_TD3_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_TD2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_TD2_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_TD1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_TD1_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_TD0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_TD0_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_TX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_TX_CTL_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_TXC        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_TXC_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_RX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_RX_CTL_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_RXC        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_RXC_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_RD0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_RD0_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_RD1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_RD1_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_RD2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_RD2_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_RD3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_RD3_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_MDC        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_MDC_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_MDIO       (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_MDIO_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_TD3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_TD3_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_TD2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_TD2_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_TD1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_TD1_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_TD0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_TD0_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_TX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_TX_CTL_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_TXC        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_TXC_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_RX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_RX_CTL_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_RXC        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_RXC_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_RD0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_RD0_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_RD1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_RD1_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_RD2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_RD2_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_RD3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_RD3_OFFSET)
#define IOMUXC_MUX_CTL_SD1_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_CLK_OFFSET)
#define IOMUXC_MUX_CTL_SD1_CMD          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_CMD_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA0_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA1_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA2_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA3_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA4        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA4_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA5        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA5_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA6        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA6_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA7        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA7_OFFSET)
#define IOMUXC_MUX_CTL_SD1_STROBE       (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_STROBE_OFFSET)
#define IOMUXC_MUX_CTL_SD2_VSELECT      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_VSELECT_OFFSET)
#define IOMUXC_MUX_CTL_SD3_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD3_CLK_OFFSET)
#define IOMUXC_MUX_CTL_SD3_CMD          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD3_CMD_OFFSET)
#define IOMUXC_MUX_CTL_SD3_DATA0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD3_DATA0_OFFSET)
#define IOMUXC_MUX_CTL_SD3_DATA1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD3_DATA1_OFFSET)
#define IOMUXC_MUX_CTL_SD3_DATA2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD3_DATA2_OFFSET)
#define IOMUXC_MUX_CTL_SD3_DATA3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD3_DATA3_OFFSET)
#define IOMUXC_MUX_CTL_SD2_CD_B         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_CD_B_OFFSET)
#define IOMUXC_MUX_CTL_SD2_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_CLK_OFFSET)
#define IOMUXC_MUX_CTL_SD2_CMD          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_CMD_OFFSET)
#define IOMUXC_MUX_CTL_SD2_DATA0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_DATA0_OFFSET)
#define IOMUXC_MUX_CTL_SD2_DATA1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_DATA1_OFFSET)
#define IOMUXC_MUX_CTL_SD2_DATA2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_DATA2_OFFSET)
#define IOMUXC_MUX_CTL_SD2_DATA3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_DATA3_OFFSET)
#define IOMUXC_MUX_CTL_SD2_RESET_B      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_RESET_B_OFFSET)
#define IOMUXC_MUX_CTL_I2C1_SCL         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_I2C1_SCL_OFFSET)
#define IOMUXC_MUX_CTL_I2C1_SDA         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_I2C1_SDA_OFFSET)
#define IOMUXC_MUX_CTL_I2C2_SCL         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_I2C2_SCL_OFFSET)
#define IOMUXC_MUX_CTL_I2C2_SDA         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_I2C2_SDA_OFFSET)
#define IOMUXC_MUX_CTL_UART1_RXD        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_UART1_RXD_OFFSET)
#define IOMUXC_MUX_CTL_UART1_TXD        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_UART1_TXD_OFFSET)
#define IOMUXC_MUX_CTL_UART2_RXD        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_UART2_RXD_OFFSET)
#define IOMUXC_MUX_CTL_UART2_TXD        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_UART2_TXD_OFFSET)
#define IOMUXC_MUX_CTL_PDM_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_PDM_CLK_OFFSET)
#define IOMUXC_MUX_CTL_PDM_BIT_STREAM0  (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_PDM_BIT_STREAM0_OFFSET)
#define IOMUXC_MUX_CTL_PDM_BIT_STREAM1  (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_PDM_BIT_STREAM1_OFFSET)
#define IOMUXC_MUX_CTL_SAI1_TXFS        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SAI1_TXFS_OFFSET)
#define IOMUXC_MUX_CTL_SAI1_TXC         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SAI1_TXC_OFFSET)
#define IOMUXC_MUX_CTL_SAI1_TXD0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SAI1_TXD0_OFFSET)
#define IOMUXC_MUX_CTL_SAI1_RXD0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SAI1_RXD0_OFFSET)
#define IOMUXC_MUX_CTL_WDOG_ANY         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_WDOG_ANY_OFFSET)

#define IOMUXC_PAD_CTL_DAP_TDI          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_DAP_TDI_OFFSET)
#define IOMUXC_PAD_CTL_DAP_TMS_SWDIO    (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_DAP_TMS_SWDIO_OFFSET)
#define IOMUXC_PAD_CTL_DAP_TCLK_SWCLK   (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_DAP_TCLK_SWCLK_OFFSET)
#define IOMUXC_PAD_CTL_DAP_TDO_TRACESWO (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_DAP_TDO_TRACESWO_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO00        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO00_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO01        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO01_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO02        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO02_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO03        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO03_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO04        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO04_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO05        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO05_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO06        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO06_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO07        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO07_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO08        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO08_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO09        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO09_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO10        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO10_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO11        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO11_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO12        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO12_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO13        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO13_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO14        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO14_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO15        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO15_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO16        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO16_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO17        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO17_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO18        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO18_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO19        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO19_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO20        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO20_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO21        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO21_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO22        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO22_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO23        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO23_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO24        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO24_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO25        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO25_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO26        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO26_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO27        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO27_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO28        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO28_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO29        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO29_OFFSET)
#define IOMUXC_PAD_CTL_CCM_CLKO1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_CCM_CLKO1_OFFSET)
#define IOMUXC_PAD_CTL_CCM_CLKO2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_CCM_CLKO2_OFFSET)
#define IOMUXC_PAD_CTL_CCM_CLKO3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_CCM_CLKO3_OFFSET)
#define IOMUXC_PAD_CTL_CCM_CLKO4        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_CCM_CLKO4_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_MDC        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_MDC_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_MDIO       (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_MDIO_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_TD3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_TD3_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_TD2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_TD2_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_TD1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_TD1_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_TD0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_TD0_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_TX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_TX_CTL_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_TXC        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_TXC_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_RX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_RX_CTL_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_RXC        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_RXC_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_RD0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_RD0_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_RD1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_RD1_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_RD2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_RD2_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_RD3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_RD3_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_MDC        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_MDC_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_MDIO       (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_MDIO_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_TD3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_TD3_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_TD2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_TD2_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_TD1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_TD1_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_TD0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_TD0_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_TX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_TX_CTL_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_TXC        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_TXC_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_RX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_RX_CTL_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_RXC        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_RXC_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_RD0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_RD0_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_RD1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_RD1_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_RD2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_RD2_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_RD3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_RD3_OFFSET)
#define IOMUXC_PAD_CTL_SD1_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_CLK_OFFSET)
#define IOMUXC_PAD_CTL_SD1_CMD          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_CMD_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA0_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA1_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA2_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA3_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA4        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA4_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA5        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA5_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA6        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA6_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA7        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA7_OFFSET)
#define IOMUXC_PAD_CTL_SD1_STROBE       (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_STROBE_OFFSET)
#define IOMUXC_PAD_CTL_SD2_VSELECT      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_VSELECT_OFFSET)
#define IOMUXC_PAD_CTL_SD3_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD3_CLK_OFFSET)
#define IOMUXC_PAD_CTL_SD3_CMD          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD3_CMD_OFFSET)
#define IOMUXC_PAD_CTL_SD3_DATA0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD3_DATA0_OFFSET)
#define IOMUXC_PAD_CTL_SD3_DATA1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD3_DATA1_OFFSET)
#define IOMUXC_PAD_CTL_SD3_DATA2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD3_DATA2_OFFSET)
#define IOMUXC_PAD_CTL_SD3_DATA3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD3_DATA3_OFFSET)
#define IOMUXC_PAD_CTL_SD2_CD_B         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_CD_B_OFFSET)
#define IOMUXC_PAD_CTL_SD2_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_CLK_OFFSET)
#define IOMUXC_PAD_CTL_SD2_CMD          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_CMD_OFFSET)
#define IOMUXC_PAD_CTL_SD2_DATA0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_DATA0_OFFSET)
#define IOMUXC_PAD_CTL_SD2_DATA1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_DATA1_OFFSET)
#define IOMUXC_PAD_CTL_SD2_DATA2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_DATA2_OFFSET)
#define IOMUXC_PAD_CTL_SD2_DATA3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_DATA3_OFFSET)
#define IOMUXC_PAD_CTL_SD2_RESET_B      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_RESET_B_OFFSET)
#define IOMUXC_PAD_CTL_I2C1_SCL         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_I2C1_SCL_OFFSET)
#define IOMUXC_PAD_CTL_I2C1_SDA         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_I2C1_SDA_OFFSET)
#define IOMUXC_PAD_CTL_I2C2_SCL         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_I2C2_SCL_OFFSET)
#define IOMUXC_PAD_CTL_I2C2_SDA         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_I2C2_SDA_OFFSET)
#define IOMUXC_PAD_CTL_UART1_RXD        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_UART1_RXD_OFFSET)
#define IOMUXC_PAD_CTL_UART1_TXD        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_UART1_TXD_OFFSET)
#define IOMUXC_PAD_CTL_UART2_RXD        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_UART2_RXD_OFFSET)
#define IOMUXC_PAD_CTL_UART2_TXD        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_UART2_TXD_OFFSET)
#define IOMUXC_PAD_CTL_PDM_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_PDM_CLK_OFFSET)
#define IOMUXC_PAD_CTL_PDM_BIT_STREAM0  (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_PDM_BIT_STREAM0_OFFSET)
#define IOMUXC_PAD_CTL_PDM_BIT_STREAM1  (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_PDM_BIT_STREAM1_OFFSET)
#define IOMUXC_PAD_CTL_SAI1_TXFS        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SAI1_TXFS_OFFSET)
#define IOMUXC_PAD_CTL_SAI1_TXC         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SAI1_TXC_OFFSET)
#define IOMUXC_PAD_CTL_SAI1_TXD0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SAI1_TXD0_OFFSET)
#define IOMUXC_PAD_CTL_SAI1_RXD0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SAI1_RXD0_OFFSET)
#define IOMUXC_PAD_CTL_WDOG_ANY         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_WDOG_ANY_OFFSET)

#define CAN1_IPP_IND_CANRX_SELECT_INPUT         (IMX9_IOMUXC1_BASE + CAN1_IPP_IND_CANRX_SELECT_INPUT_OFFSET)
#define CAN2_IPP_IND_CANRX_SELECT_INPUT         (IMX9_IOMUXC1_BASE + CAN2_IPP_IND_CANRX_SELECT_INPUT_OFFSET)
#define CCMSRCGPCMIX_EXT1_CLK_SELECT_INPUT      (IMX9_IOMUXC1_BASE + CCMSRCGPCMIX_EXT1_CLK_SELECT_INPUT_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_0   (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_0_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_1   (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_1_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_2   (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_2_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_3   (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_3_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_4   (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_4_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_5   (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_5_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_6   (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_6_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_7   (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_7_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_8   (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_8_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_9   (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_9_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_10  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_10_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_11  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_11_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_13  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_13_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_14  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_14_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_15  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_15_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_16  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_16_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_17  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_17_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_18  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_18_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_20  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_20_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_22  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_22_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_23  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_23_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_24  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_24_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_25  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_25_OFFSET)
#define FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_27  (IMX9_IOMUXC1_BASE + FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_27_OFFSET)
#define I3C2_PIN_SCL_IN_SELECT_INPUT            (IMX9_IOMUXC1_BASE + 13C2_PIN_SCL_IN_SELECT_INPUT_OFFSET)
#define I3C2_PIN_SDA_IN_SELECT_INPUT            (IMX9_IOMUXC1_BASE + 13C2_PIN_SDA_IN_SELECT_INPUT_OFFSET)
#define JTAG_MUX_TCK_SELECT_INPUT               (IMX9_IOMUXC1_BASE + JTAG_MUX_TCK_SELECT_INPUT_OFFSET)
#define JTAG_MUX_TDI_SELECT_INPUT               (IMX9_IOMUXC1_BASE + JTAG_MUX_TDI_SELECT_INPUT_OFFSET)
#define JTAG_MUX_TMS_SELECT_INPUT               (IMX9_IOMUXC1_BASE + JTAG_MUX_TMS_SELECT_INPUT_OFFSET)
#define LP12C3_IPP_IND_LPI2C_SCL_SELECT_INPUT   (IMX9_IOMUXC1_BASE + LP12C3_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET)
#define LPI12C3_IPP_IND_LPI2C_SDA_SELECT_INPUT  (IMX9_IOMUXC1_BASE + LPI12C3_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET)
#define LP12C5_IPP_IND_LPI2C_SCL_SELECT_INPUT   (IMX9_IOMUXC1_BASE + LP12C5_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET)
#define LP12C5_IPP_IND_LPI2C_SDA_SELECT_INPUT   (IMX9_IOMUXC1_BASE + LP12C5_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET)
#define LPI2C6_IPP_IND_LPI2C_SCL_SELECT_INPUT   (IMX9_IOMUXC1_BASE + LPI2C6_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET)
#define LPI2C6_IPP_IND_LPI2C_SDA_SELECT_INPUT   (IMX9_IOMUXC1_BASE + LPI2C6_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET)
#define LPI2C7_IPP_IND_LPI2C_SCL_SELECT_INPUT   (IMX9_IOMUXC1_BASE + LPI2C7_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET)
#define LPI2C7_IPP_IND_LPI2C_SDA_SELECT_INPUT   (IMX9_IOMUXC1_BASE + LPI2C7_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET)
#define LPI2C8_IPP_IND_LPI2C_SCL_SELECT_INPUT   (IMX9_IOMUXC1_BASE + LPI2C8_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET)
#define LPI2C8_IPP_IND_LPI2C_SDA_SELECT_INPUT   (IMX9_IOMUXC1_BASE + LPI2C8_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET)
#define LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_O   (IMX9_IOMUXC1_BASE + LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_O_OFFSET)
#define LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_1   (IMX9_IOMUXC1_BASE + LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_1_OFFSET)
#define LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_2   (IMX9_IOMUXC1_BASE + LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_2_OFFSET)
#define LPUART3_IPP_IND_LPUART_CTS_N_SELECT_INP (IMX9_IOMUXC1_BASE + LPUART3_IPP_IND_LPUART_CTS_N_SELECT_INP_OFFSET)
#define LPUART3_IPP_IND_LPUART_RXD_SELECT_INPUT (IMX9_IOMUXC1_BASE + LPUART3_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET)
#define LPUART3_IPP_IND_LPUART_TXD_SELECT_INPUT (IMX9_IOMUXC1_BASE + LPUART3_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET)
#define LPUART4_IPP_IND_LPUART_CTS_N_SELECT_INP (IMX9_IOMUXC1_BASE + LPUART4_IPP_IND_LPUART_CTS_N_SELECT_INP_OFFSET)
#define LPUART4_IPP_IND_LPUART_RXD_SELECT_INPUT (IMX9_IOMUXC1_BASE + LPUART4_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET)
#define LPUART4_IPP_IND_LPUART_TXD_SELECT_INPUT (IMX9_IOMUXC1_BASE + LPUART4_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET)
#define LPUARTS_IPP_IND_LPUART_CTS_N_SELECT_INP (IMX9_IOMUXC1_BASE + LPUARTS_IPP_IND_LPUART_CTS_N_SELECT_INP_OFFSET)
#define LPUARTS_IPP_IND_LPUART_RXD_SELECT_INPUT (IMX9_IOMUXC1_BASE + LPUARTS_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET)
#define LPUARTS_IPP_IND_LPUART_TXD_SELECT_INPUT (IMX9_IOMUXC1_BASE + LPUARTS_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET)
#define SAI1_IPP_IND_SAI_MCLK_SELECT_INPUT      (IMX9_IOMUXC1_BASE + SAI1_IPP_IND_SAI_MCLK_SELECT_INPUT_OFFSET)
#define SAI3_IPP_IND_SAI_RXBCLK_SELECT_INPUT    (IMX9_IOMUXC1_BASE + SAI3_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET)
#define SAI3_IPP_IND_SAI_RXSYNC_SELECT_INPUT    (IMX9_IOMUXC1_BASE + SAI3_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET)
#define SPDIF_SPDIF_I_SELECT_INPUT              (IMX9_IOMUXC1_BASE + SPDIF_SPDIF_I_SELECT_INPUT_OFFSET)
#define USDHC3_IPP_CARD_CLK_IN_SELECT_INPUT     (IMX9_IOMUXC1_BASE + USDHC3_IPP_CARD_CLK_IN_SELECT_INPUT_OFFSET)
#define USDHC3_IPP_CMD_IN_SELECT_INPUT          (IMX9_IOMUXC1_BASE + USDHC3_IPP_CMD_IN_SELECT_INPUT_OFFSET)
#define USDHC3_IPP_DATO_IN_SELECT_INPUT         (IMX9_IOMUXC1_BASE + USDHC3_IPP_DATO_IN_SELECT_INPUT_OFFSET)
#define USDHC3_IPP_DAT1_IN_SELECT_INPUT         (IMX9_IOMUXC1_BASE + USDHC3_IPP_DAT1_IN_SELECT_INPUT_OFFSET)
#define USDHC3_IPP_DAT2_IN_SELECT_INPUT         (IMX9_IOMUXC1_BASE + USDHC3_IPP_DAT2_IN_SELECT_INPUT_OFFSET)
#define USDHC3_IPP_DAT3_IN_SELECT_INPUT         (IMX9_IOMUXC1_BASE + USDHC3_IPP_DAT3_IN_SELECT_INPUT_OFFSET)

#endif /* __ARCH_ARM64_SRC_IMX9_HARDWARE_IMX93_IMX93_IOMUX_H */
