/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BigIntegerConverter
implements Converter {
    public static final BigIntegerConverter INSTANCE = new BigIntegerConverter();

    BigIntegerConverter() {
    }

    @Override
    public Object convert(JSON jSON, JSON.Context context, Object object, Class<?> clazz, Type type) throws Exception {
        Object object2;
        if (object instanceof Map) {
            object = ((Map)object).get(null);
        } else if (object instanceof List) {
            object2 = (List)object;
            Object object3 = object = !object2.isEmpty() ? (Object)object2.get(0) : null;
        }
        if (object instanceof String && (object2 = context.getNumberFormat()) != null) {
            object = ((NumberFormat)object2).parse((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toBigIntegerExact();
        }
        if (object instanceof BigInteger) {
            return object;
        }
        if (object instanceof Number) {
            return BigInteger.valueOf(((Number)object).longValue());
        }
        if (object instanceof String) {
            object2 = object.toString().trim();
            if (((String)object2).length() > 0) {
                int n = 0;
                if (((String)object2).charAt(0) == '+') {
                    ++n;
                }
                if (((String)object2).startsWith("0x", n)) {
                    return new BigInteger(((String)object2).substring(n + 2), 16);
                }
                return new BigInteger(((String)object2).substring(n));
            }
            return null;
        }
        if (object != null) {
            throw new UnsupportedOperationException("Cannot convert " + object.getClass() + " to " + type);
        }
        return null;
    }
}

