/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.lang.invoke.MethodHandles;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.crawl.MD5Signature;
import org.apache.nutch.crawl.Signature;
import org.apache.nutch.util.ObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private SignatureFactory() {
    }

    public static synchronized Signature getSignature(Configuration conf) {
        String clazz = conf.get("db.signature.class", MD5Signature.class.getName());
        ObjectCache objectCache = ObjectCache.get(conf);
        Signature impl = (Signature)objectCache.getObject(clazz);
        if (impl == null) {
            try {
                LOG.info("Using Signature impl: {}", (Object)clazz);
                Class<?> implClass = Class.forName(clazz);
                impl = (Signature)implClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                impl.setConf(conf);
                objectCache.setObject(clazz, impl);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't create " + clazz, e);
            }
        }
        return impl;
    }
}

