/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import java.util.function.LongConsumer;
import org.apache.lucene.index.IndexReader;
import org.opensearch.common.Nullable;
import org.opensearch.common.util.BigArrays;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.sort.SortOrder;

public class CompositeValuesSourceConfig {
    private final String name;
    @Nullable
    private final MappedFieldType fieldType;
    private final ValuesSource vs;
    private final DocValueFormat format;
    private final int reverseMul;
    private final boolean missingBucket;
    private final MissingOrder missingOrder;
    private final boolean hasScript;
    private final SingleDimensionValuesSourceProvider singleDimensionValuesSourceProvider;

    CompositeValuesSourceConfig(String name, @Nullable MappedFieldType fieldType, ValuesSource vs, DocValueFormat format, SortOrder order, boolean missingBucket, MissingOrder missingOrder, boolean hasScript, SingleDimensionValuesSourceProvider singleDimensionValuesSourceProvider) {
        this.name = name;
        this.fieldType = fieldType;
        this.vs = vs;
        this.format = format;
        this.reverseMul = order == SortOrder.ASC ? 1 : -1;
        this.missingBucket = missingBucket;
        this.hasScript = hasScript;
        this.singleDimensionValuesSourceProvider = singleDimensionValuesSourceProvider;
        this.missingOrder = missingOrder;
    }

    String name() {
        return this.name;
    }

    MappedFieldType fieldType() {
        return this.fieldType;
    }

    ValuesSource valuesSource() {
        return this.vs;
    }

    DocValueFormat format() {
        return this.format;
    }

    boolean missingBucket() {
        return this.missingBucket;
    }

    MissingOrder missingOrder() {
        return this.missingOrder;
    }

    boolean hasScript() {
        return this.hasScript;
    }

    int reverseMul() {
        assert (this.reverseMul == -1 || this.reverseMul == 1);
        return this.reverseMul;
    }

    SingleDimensionValuesSource<?> createValuesSource(BigArrays bigArrays, IndexReader reader, int size, LongConsumer addRequestCircuitBreakerBytes) {
        return this.singleDimensionValuesSourceProvider.createValuesSource(bigArrays, reader, size, addRequestCircuitBreakerBytes, this);
    }

    @FunctionalInterface
    public static interface SingleDimensionValuesSourceProvider {
        public SingleDimensionValuesSource<?> createValuesSource(BigArrays var1, IndexReader var2, int var3, LongConsumer var4, CompositeValuesSourceConfig var5);
    }
}

