/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryViewerPrinter;
import org.apache.hadoop.mapreduce.jobhistory.HumanReadableHistoryViewerPrinter;
import org.apache.hadoop.mapreduce.jobhistory.JSONHistoryViewerPrinter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.util.HostUtil;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HistoryViewer {
    private FileSystem fs;
    private JobHistoryParser.JobInfo job;
    private HistoryViewerPrinter jhvp;
    public static final String HUMAN_FORMAT = "human";
    public static final String JSON_FORMAT = "json";

    public HistoryViewer(String historyFile, Configuration conf, boolean printAll) throws IOException {
        this(historyFile, conf, printAll, HUMAN_FORMAT);
    }

    public HistoryViewer(String historyFile, Configuration conf, boolean printAll, String format) throws IOException {
        block5: {
            String errorMsg = "Unable to initialize History Viewer";
            try {
                Path jobFile = new Path(historyFile);
                this.fs = jobFile.getFileSystem(conf);
                String[] jobDetails = jobFile.getName().split("_");
                if (jobDetails.length < 2) {
                    System.err.println("Ignore unrecognized file: " + jobFile.getName());
                    throw new IOException(errorMsg);
                }
                JobHistoryParser parser = new JobHistoryParser(this.fs, jobFile);
                this.job = parser.parse();
                String scheme = WebAppUtils.getHttpSchemePrefix((Configuration)this.fs.getConf());
                if (HUMAN_FORMAT.equalsIgnoreCase(format)) {
                    this.jhvp = new HumanReadableHistoryViewerPrinter(this.job, printAll, scheme);
                    break block5;
                }
                if (JSON_FORMAT.equalsIgnoreCase(format)) {
                    this.jhvp = new JSONHistoryViewerPrinter(this.job, printAll, scheme);
                    break block5;
                }
                System.err.println("Invalid format specified: " + format);
                throw new IllegalArgumentException(errorMsg);
            }
            catch (IOException e) {
                throw new IOException(errorMsg, e);
            }
        }
    }

    public void print() throws IOException {
        this.print(System.out);
    }

    public void print(PrintStream ps) throws IOException {
        this.jhvp.print(ps);
    }

    public static String getTaskLogsUrl(String scheme, JobHistoryParser.TaskAttemptInfo attempt) {
        if (attempt.getHttpPort() == -1 || attempt.getTrackerName().equals("") || attempt.getAttemptId() == null) {
            return null;
        }
        String taskTrackerName = HostUtil.convertTrackerNameToHostName(attempt.getTrackerName());
        return HostUtil.getTaskLogUrl(scheme, taskTrackerName, Integer.toString(attempt.getHttpPort()), attempt.getAttemptId().toString());
    }

    public static class FilteredJob {
        private Map<String, Set<TaskID>> badNodesToFilteredTasks = new HashMap<String, Set<TaskID>>();
        private String filter;

        public Map<String, Set<TaskID>> getFilteredMap() {
            return this.badNodesToFilteredTasks;
        }

        public String getFilter() {
            return this.filter;
        }

        public FilteredJob(JobHistoryParser.JobInfo job, String status) {
            this.filter = status;
            Map<TaskID, JobHistoryParser.TaskInfo> tasks = job.getAllTasks();
            for (JobHistoryParser.TaskInfo task : tasks.values()) {
                Map<TaskAttemptID, JobHistoryParser.TaskAttemptInfo> attempts = task.getAllTaskAttempts();
                for (JobHistoryParser.TaskAttemptInfo attempt : attempts.values()) {
                    if (!attempt.getTaskStatus().equals(status)) continue;
                    String hostname = attempt.getHostname();
                    TaskID id = attempt.getAttemptId().getTaskID();
                    Set<TaskID> set = this.badNodesToFilteredTasks.get(hostname);
                    if (set == null) {
                        set = new TreeSet<TaskID>();
                        set.add(id);
                        this.badNodesToFilteredTasks.put(hostname, set);
                        continue;
                    }
                    set.add(id);
                }
            }
        }
    }

    public static class AnalyzedJob {
        private long avgMapTime;
        private long avgReduceTime;
        private long avgShuffleTime;
        private JobHistoryParser.TaskAttemptInfo[] mapTasks;
        private JobHistoryParser.TaskAttemptInfo[] reduceTasks;

        public long getAvgMapTime() {
            return this.avgMapTime;
        }

        public long getAvgReduceTime() {
            return this.avgReduceTime;
        }

        public long getAvgShuffleTime() {
            return this.avgShuffleTime;
        }

        public JobHistoryParser.TaskAttemptInfo[] getMapTasks() {
            return this.mapTasks;
        }

        public JobHistoryParser.TaskAttemptInfo[] getReduceTasks() {
            return this.reduceTasks;
        }

        public AnalyzedJob(JobHistoryParser.JobInfo job) {
            Map<TaskID, JobHistoryParser.TaskInfo> tasks = job.getAllTasks();
            int succeededMaps = (int)job.getSucceededMaps();
            int succeededReduces = (int)job.getSucceededReduces();
            this.mapTasks = new JobHistoryParser.TaskAttemptInfo[succeededMaps];
            this.reduceTasks = new JobHistoryParser.TaskAttemptInfo[succeededReduces];
            int mapIndex = 0;
            int reduceIndex = 0;
            this.avgMapTime = 0L;
            this.avgReduceTime = 0L;
            this.avgShuffleTime = 0L;
            block0: for (JobHistoryParser.TaskInfo task : tasks.values()) {
                Map<TaskAttemptID, JobHistoryParser.TaskAttemptInfo> attempts = task.getAllTaskAttempts();
                for (JobHistoryParser.TaskAttemptInfo attempt : attempts.values()) {
                    if (!attempt.getTaskStatus().equals(TaskStatus.State.SUCCEEDED.toString())) continue;
                    long avgFinishTime = attempt.getFinishTime() - attempt.getStartTime();
                    if (attempt.getTaskType().equals((Object)TaskType.MAP)) {
                        this.mapTasks[mapIndex++] = attempt;
                        this.avgMapTime += avgFinishTime;
                        continue block0;
                    }
                    if (!attempt.getTaskType().equals((Object)TaskType.REDUCE)) continue block0;
                    this.reduceTasks[reduceIndex++] = attempt;
                    this.avgShuffleTime += attempt.getShuffleFinishTime() - attempt.getStartTime();
                    this.avgReduceTime += attempt.getFinishTime() - attempt.getShuffleFinishTime();
                    continue block0;
                }
            }
            if (succeededMaps > 0) {
                this.avgMapTime /= (long)succeededMaps;
            }
            if (succeededReduces > 0) {
                this.avgReduceTime /= (long)succeededReduces;
                this.avgShuffleTime /= (long)succeededReduces;
            }
        }
    }

    public static class SummarizedJob {
        Map<TaskID, JobHistoryParser.TaskInfo> tasks;
        int totalMaps = 0;
        int totalReduces = 0;
        int totalCleanups = 0;
        int totalSetups = 0;
        int numFailedMaps = 0;
        int numKilledMaps = 0;
        int numFailedReduces = 0;
        int numKilledReduces = 0;
        int numFinishedCleanups = 0;
        int numFailedCleanups = 0;
        int numKilledCleanups = 0;
        int numFinishedSetups = 0;
        int numFailedSetups = 0;
        int numKilledSetups = 0;
        long mapStarted = 0L;
        long mapFinished = 0L;
        long reduceStarted = 0L;
        long reduceFinished = 0L;
        long cleanupStarted = 0L;
        long cleanupFinished = 0L;
        long setupStarted = 0L;
        long setupFinished = 0L;

        public int getTotalMaps() {
            return this.totalMaps;
        }

        public int getTotalReduces() {
            return this.totalReduces;
        }

        public int getTotalCleanups() {
            return this.totalCleanups;
        }

        public int getTotalSetups() {
            return this.totalSetups;
        }

        public int getNumFailedMaps() {
            return this.numFailedMaps;
        }

        public int getNumKilledMaps() {
            return this.numKilledMaps;
        }

        public int getNumFailedReduces() {
            return this.numFailedReduces;
        }

        public int getNumKilledReduces() {
            return this.numKilledReduces;
        }

        public int getNumFinishedCleanups() {
            return this.numFinishedCleanups;
        }

        public int getNumFailedCleanups() {
            return this.numFailedCleanups;
        }

        public int getNumKilledCleanups() {
            return this.numKilledCleanups;
        }

        public int getNumFinishedSetups() {
            return this.numFinishedSetups;
        }

        public int getNumFailedSetups() {
            return this.numFailedSetups;
        }

        public int getNumKilledSetups() {
            return this.numKilledSetups;
        }

        public long getMapStarted() {
            return this.mapStarted;
        }

        public long getMapFinished() {
            return this.mapFinished;
        }

        public long getReduceStarted() {
            return this.reduceStarted;
        }

        public long getReduceFinished() {
            return this.reduceFinished;
        }

        public long getCleanupStarted() {
            return this.cleanupStarted;
        }

        public long getCleanupFinished() {
            return this.cleanupFinished;
        }

        public long getSetupStarted() {
            return this.setupStarted;
        }

        public long getSetupFinished() {
            return this.setupFinished;
        }

        public SummarizedJob(JobHistoryParser.JobInfo job) {
            this.tasks = job.getAllTasks();
            for (JobHistoryParser.TaskInfo task : this.tasks.values()) {
                Map<TaskAttemptID, JobHistoryParser.TaskAttemptInfo> attempts = task.getAllTaskAttempts();
                for (JobHistoryParser.TaskAttemptInfo attempt : attempts.values()) {
                    long startTime = attempt.getStartTime();
                    long finishTime = attempt.getFinishTime();
                    if (attempt.getTaskType().equals((Object)TaskType.MAP)) {
                        if (this.mapStarted == 0L || this.mapStarted > startTime) {
                            this.mapStarted = startTime;
                        }
                        if (this.mapFinished < finishTime) {
                            this.mapFinished = finishTime;
                        }
                        ++this.totalMaps;
                        if (attempt.getTaskStatus().equals(TaskStatus.State.FAILED.toString())) {
                            ++this.numFailedMaps;
                            continue;
                        }
                        if (!attempt.getTaskStatus().equals(TaskStatus.State.KILLED.toString())) continue;
                        ++this.numKilledMaps;
                        continue;
                    }
                    if (attempt.getTaskType().equals((Object)TaskType.REDUCE)) {
                        if (this.reduceStarted == 0L || this.reduceStarted > startTime) {
                            this.reduceStarted = startTime;
                        }
                        if (this.reduceFinished < finishTime) {
                            this.reduceFinished = finishTime;
                        }
                        ++this.totalReduces;
                        if (attempt.getTaskStatus().equals(TaskStatus.State.FAILED.toString())) {
                            ++this.numFailedReduces;
                            continue;
                        }
                        if (!attempt.getTaskStatus().equals(TaskStatus.State.KILLED.toString())) continue;
                        ++this.numKilledReduces;
                        continue;
                    }
                    if (attempt.getTaskType().equals((Object)TaskType.JOB_CLEANUP)) {
                        if (this.cleanupStarted == 0L || this.cleanupStarted > startTime) {
                            this.cleanupStarted = startTime;
                        }
                        if (this.cleanupFinished < finishTime) {
                            this.cleanupFinished = finishTime;
                        }
                        ++this.totalCleanups;
                        if (attempt.getTaskStatus().equals(TaskStatus.State.SUCCEEDED.toString())) {
                            ++this.numFinishedCleanups;
                            continue;
                        }
                        if (attempt.getTaskStatus().equals(TaskStatus.State.FAILED.toString())) {
                            ++this.numFailedCleanups;
                            continue;
                        }
                        if (!attempt.getTaskStatus().equals(TaskStatus.State.KILLED.toString())) continue;
                        ++this.numKilledCleanups;
                        continue;
                    }
                    if (!attempt.getTaskType().equals((Object)TaskType.JOB_SETUP)) continue;
                    if (this.setupStarted == 0L || this.setupStarted > startTime) {
                        this.setupStarted = startTime;
                    }
                    if (this.setupFinished < finishTime) {
                        this.setupFinished = finishTime;
                    }
                    ++this.totalSetups;
                    if (attempt.getTaskStatus().equals(TaskStatus.State.SUCCEEDED.toString())) {
                        ++this.numFinishedSetups;
                        continue;
                    }
                    if (attempt.getTaskStatus().equals(TaskStatus.State.FAILED.toString())) {
                        ++this.numFailedSetups;
                        continue;
                    }
                    if (!attempt.getTaskStatus().equals(TaskStatus.State.KILLED.toString())) continue;
                    ++this.numKilledSetups;
                }
            }
        }
    }
}

