/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps;

import crawlercommons.sitemaps.SiteMap;
import crawlercommons.sitemaps.extension.Extension;
import crawlercommons.sitemaps.extension.ExtensionMetadata;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteMapURL
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SiteMapURL.class);
    public static final double DEFAULT_PRIORITY = 0.5;
    private URL url;
    private Date lastModified;
    private ChangeFrequency changeFreq;
    private double priority = 0.5;
    private boolean valid;
    private Map<Extension, ExtensionMetadata[]> attributes;

    public SiteMapURL(String url, boolean valid) {
        this.setUrl(url);
        this.setValid(valid);
    }

    public SiteMapURL(URL url, boolean valid) {
        this.setUrl(url);
        this.setValid(valid);
    }

    public SiteMapURL(String url, String lastModified, String changeFreq, String priority, boolean valid) {
        this(url, valid);
        this.setLastModified(lastModified);
        this.setChangeFrequency(changeFreq);
        this.setPriority(priority);
    }

    public SiteMapURL(URL url, Date lastModified, ChangeFrequency changeFreq, double priority, boolean valid) {
        this(url, valid);
        this.setLastModified(lastModified);
        this.setChangeFrequency(changeFreq);
        this.setPriority(priority);
    }

    public SiteMapURL(URL url, ZonedDateTime lastModified, ChangeFrequency changeFreq, double priority, boolean valid) {
        this(url, Date.from(lastModified.toInstant()), changeFreq, priority, valid);
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setUrl(String url) {
        try {
            this.url = new URI(url).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            LOG.error("Bad url: [{}], Exception: {}", (Object)url, (Object)e.toString());
            this.url = null;
        }
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = SiteMap.convertToDate(lastModified);
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public void setLastModified(ZonedDateTime lastModified) {
        if (lastModified != null) {
            this.lastModified = Date.from(lastModified.toInstant());
        }
    }

    public double getPriority() {
        return this.priority;
    }

    public void setPriority(double priority) {
        if (priority < 0.0 || priority > 1.0 || Double.isNaN(priority)) {
            this.priority = 0.5;
            LOG.warn("Can't set the priority to {}, Priority should be between 0 to 1, reverting to default priority value: {}", (Object)priority, (Object)0.5);
        } else {
            this.priority = priority;
        }
    }

    public void setPriority(String priorityStr) {
        try {
            if (priorityStr == null || priorityStr.isEmpty()) {
                LOG.debug("This item contains no priority (which is ok as text sitemaps don't have priority for example), defaulting priority value to: {}", (Object)0.5);
                this.priority = 0.5;
            } else {
                this.setPriority(Double.parseDouble(priorityStr));
            }
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Can't set the priority, because I can't understand this value: {}, Priority should be between 0 to 1, reverting to default priority value: {}", (Object)priorityStr, (Object)0.5);
            this.priority = 0.5;
        }
    }

    public ChangeFrequency getChangeFrequency() {
        return this.changeFreq;
    }

    public void setChangeFrequency(ChangeFrequency changeFreq) {
        this.changeFreq = changeFreq;
    }

    public void setChangeFrequency(String changeFreq) {
        if (changeFreq != null) {
            this.changeFreq = (changeFreq = changeFreq.toUpperCase(Locale.ROOT)).contains("ALWAYS") ? ChangeFrequency.ALWAYS : (changeFreq.contains("HOURLY") ? ChangeFrequency.HOURLY : (changeFreq.contains("DAILY") ? ChangeFrequency.DAILY : (changeFreq.contains("WEEKLY") ? ChangeFrequency.WEEKLY : (changeFreq.contains("MONTHLY") ? ChangeFrequency.MONTHLY : (changeFreq.contains("YEARLY") ? ChangeFrequency.YEARLY : (changeFreq.contains("NEVER") ? ChangeFrequency.NEVER : null))))));
        }
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void addAttributesForExtension(Extension extension, ExtensionMetadata[] attributes) {
        if (this.attributes == null) {
            this.attributes = new TreeMap<Extension, ExtensionMetadata[]>();
        }
        this.attributes.put(extension, attributes);
    }

    public Map<Extension, ExtensionMetadata[]> getAttributes() {
        return this.attributes;
    }

    public ExtensionMetadata[] getAttributesForExtension(Extension extension) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get((Object)extension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SiteMapURL that = (SiteMapURL)o;
        if (this.url == that.url) {
            return true;
        }
        return this.url != null && that.url != null && this.url.toString().equals(that.url.toString());
    }

    public int hashCode() {
        if (this.url == null) {
            return "".hashCode();
        }
        return this.url.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("url = \"").append(this.url).append("\"");
        sb.append(", lastMod = ").append(this.lastModified == null ? "null" : SiteMap.W3C_FULLDATE_FORMATTER_UTC.format(this.lastModified.toInstant()));
        sb.append(", changeFreq = ").append((Object)this.changeFreq);
        sb.append(", priority = ").append(this.priority);
        if (this.attributes != null) {
            for (Map.Entry<Extension, ExtensionMetadata[]> e : this.attributes.entrySet()) {
                for (ExtensionMetadata m : e.getValue()) {
                    sb.append(", ").append(m.toString());
                }
            }
        }
        return sb.toString();
    }

    public static enum ChangeFrequency {
        ALWAYS,
        HOURLY,
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY,
        NEVER;

    }
}

