/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.net;

import com.barchart.udt.ExceptionUDT;
import com.barchart.udt.SocketUDT;
import com.barchart.udt.TypeUDT;
import com.barchart.udt.anno.ThreadSafe;
import com.barchart.udt.net.IceCommon;
import com.barchart.udt.net.IceSocket;
import com.barchart.udt.net.NetInputStreamUDT;
import com.barchart.udt.net.NetOutputStreamUDT;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetSocketUDT
extends Socket
implements IceSocket,
IceCommon {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @ThreadSafe(value="this")
    protected InputStream inputStream;
    @ThreadSafe(value="this")
    protected OutputStream outputStream;
    protected final SocketUDT socketUDT;

    public NetSocketUDT() throws ExceptionUDT {
        this(new SocketUDT(TypeUDT.STREAM));
        this.socketUDT.setBlocking(true);
    }

    protected NetSocketUDT(SocketUDT socketUDT) {
        this.socketUDT = socketUDT;
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        if (bindpoint == null) {
            bindpoint = new InetSocketAddress(0);
        }
        this.socketUDT.bind((InetSocketAddress)bindpoint);
    }

    @Override
    public synchronized void close() throws IOException {
        this.socketUDT.close();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.socketUDT.connect((InetSocketAddress)endpoint);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        throw new UnsupportedOperationException("feature not available");
    }

    @Override
    public SocketChannel getChannel() {
        throw new UnsupportedOperationException("feature not available");
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socketUDT.getRemoteInetAddress();
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new NetInputStreamUDT(this.socketUDT);
        }
        return this.inputStream;
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return true;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socketUDT.getLocalInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socketUDT.getLocalInetPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        try {
            return this.socketUDT.getLocalSocketAddress();
        }
        catch (ExceptionUDT e) {
            return null;
        }
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return false;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new NetOutputStreamUDT(this.socketUDT);
        }
        return this.outputStream;
    }

    @Override
    public int getPort() {
        return this.socketUDT.getRemoteInetPort();
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.socketUDT.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        try {
            return this.socketUDT.getRemoteSocketAddress();
        }
        catch (ExceptionUDT e) {
            return null;
        }
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.socketUDT.getReuseAddress();
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.socketUDT.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.socketUDT.getSoLinger();
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.socketUDT.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return 0;
    }

    @Override
    public boolean isBound() {
        return this.socketUDT.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.socketUDT.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.socketUDT.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socketUDT.isClosed();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socketUDT.isClosed();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.log.debug("Sending urgent data not supported in Barchart UDT...");
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.log.debug("Keep alive not supported in Barchart UDT...");
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.log.debug("OOB inline  not supported in Barchart UDT...");
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.socketUDT.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.socketUDT.setReuseAddress(on);
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.socketUDT.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socketUDT.setSoLinger(on, linger);
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.socketUDT.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.log.debug("TCP no delay not supported in Barchart UDT...");
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.log.debug("Traffic class not supported in Barchart UDT...");
    }

    @Override
    public void shutdownInput() throws IOException {
        this.socketUDT.close();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.socketUDT.close();
    }

    @Override
    public SocketUDT socketUDT() {
        return this.socketUDT;
    }
}

