/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.archive.format.gzip.GZIPConstants;
import org.archive.format.gzip.GZIPFooter;
import org.archive.format.gzip.GZIPFormatException;
import org.archive.format.gzip.GZIPHeader;
import org.archive.format.gzip.GZIPMemberSeries;

public class GZIPSeriesMember
extends InputStream
implements GZIPConstants {
    private static Logger LOG = Logger.getLogger(GZIPSeriesMember.class.getName());
    private GZIPMemberSeries series = null;
    private GZIPHeader header = null;
    private GZIPFooter footer = null;
    private boolean gotIOError = false;
    private boolean gotGZError = false;
    private boolean gotEOR = false;
    private Inflater inflater = null;
    private CRC32 crc = null;

    public GZIPSeriesMember(GZIPMemberSeries series, GZIPHeader header) {
        this.series = series;
        this.header = header;
        this.footer = null;
        this.inflater = new Inflater(true);
        this.crc = new CRC32();
        this.gotIOError = false;
        this.gotGZError = false;
        this.gotEOR = false;
    }

    public GZIPFooter getFooter() {
        return this.footer;
    }

    public GZIPHeader getHeader() {
        return this.header;
    }

    public long getRecordStartOffset() {
        return this.series.getCurrentMemberStartOffset();
    }

    public String getRecordFileContext() {
        return this.series.getStreamContext();
    }

    public boolean gotEOR() {
        return this.gotEOR;
    }

    public boolean gotIOError() {
        return this.gotIOError;
    }

    public boolean gotGZipError() {
        return this.gotGZError;
    }

    public long getUncompressedBytesRead() {
        return this.inflater.getBytesWritten();
    }

    public long getCompressedBytesRead() {
        long amtRead = (long)this.header.getLength() + this.inflater.getBytesRead();
        if (this.gotEOR) {
            amtRead += 8L;
        }
        return amtRead;
    }

    public void skipMember() throws IOException {
        this.skip(Long.MAX_VALUE);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int totalRead = 0;
        if (this.gotIOError) {
            throw new IOException("Repeated read() on IOException!");
        }
        if (this.gotGZError) {
            throw new GZIPFormatException("Repeated read() on GZIPFormatException");
        }
        if (this.gotEOR) {
            return -1;
        }
        while (totalRead < len && !this.gotEOR) {
            int amtInflated;
            if (this.inflater.needsInput()) {
                int amtRead;
                try {
                    amtRead = this.series.fillInflater(this.inflater);
                }
                catch (IOException e) {
                    this.gotIOError = true;
                    throw e;
                }
                if (amtRead == -1) {
                    LOG.warning("At end of file without inflate done...");
                    this.gotGZError = true;
                    throw new GZIPFormatException("At end of file without inflate done...");
                }
            }
            try {
                amtInflated = this.inflater.inflate(b, off + totalRead, len - totalRead);
            }
            catch (DataFormatException e) {
                LOG.warning("GOT GZ-DATAFORMATERROR");
                this.gotGZError = true;
                this.series.noteGZError();
                throw new GZIPFormatException(e);
            }
            boolean finished = this.inflater.finished();
            this.crc.update(b, off + totalRead, amtInflated);
            totalRead += amtInflated;
            if (!finished) continue;
            this.series.returnBytes(this.inflater.getRemaining());
            byte[] footerBuffer = new byte[8];
            int footerBytes = this.series.read(footerBuffer, 0, footerBuffer.length);
            if (footerBytes != 8) {
                this.gotGZError = true;
                this.series.noteGZError();
                throw new GZIPFormatException("short footer");
            }
            this.gotEOR = true;
            this.series.noteEndOfRecord();
            try {
                GZIPFooter tmpFooter = new GZIPFooter(footerBuffer);
                tmpFooter.verify(this.crc.getValue(), this.inflater.getTotalOut());
                this.footer = tmpFooter;
            }
            catch (GZIPFormatException e) {
                this.gotGZError = true;
                this.series.noteGZError();
                throw e;
            }
            if (totalRead != 0) continue;
            totalRead = -1;
        }
        return totalRead;
    }

    @Override
    public int available() throws IOException {
        if (this.gotEOR) {
            return 0;
        }
        return this.inflater.needsInput() ? 0 : 1;
    }

    @Override
    public void close() throws IOException {
        this.skipMember();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int amt = this.read(b, 0, 1);
        if (amt == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long amt) throws IOException {
        int r;
        long skipped = 0L;
        int SKIP_LENGTH = 4096;
        byte[] b = new byte[SKIP_LENGTH];
        while (amt > 0L && (r = this.read(b, 0, b.length)) != -1) {
            skipped += (long)r;
            amt -= (long)r;
        }
        return skipped;
    }
}

