/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeflateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int EXPECTED_COMPRESSION_RATIO = 5;
    private static final int BUF_SIZE = 4096;

    public static final byte[] inflateBestEffort(byte[] in) {
        return DeflateUtils.inflateBestEffort(in, Integer.MAX_VALUE);
    }

    public static final byte[] inflateBestEffort(byte[] in, int sizeLimit) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(5 * in.length);
        Inflater inflater = new Inflater(true);
        InflaterInputStream inStream = new InflaterInputStream(new ByteArrayInputStream(in), inflater);
        byte[] buf = new byte[4096];
        int written = 0;
        try {
            int size;
            while ((size = inStream.read(buf)) > 0) {
                if (written + size > sizeLimit) {
                    outStream.write(buf, 0, sizeLimit - written);
                    break;
                }
                outStream.write(buf, 0, size);
                written += size;
            }
        }
        catch (Exception e) {
            LOG.info("Caught Exception in inflateBestEffort", (Throwable)e);
        }
        try {
            outStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outStream.toByteArray();
    }

    public static final byte[] inflate(byte[] in) throws IOException {
        int size;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(5 * in.length);
        InflaterInputStream inStream = new InflaterInputStream(new ByteArrayInputStream(in));
        byte[] buf = new byte[4096];
        while ((size = inStream.read(buf)) > 0) {
            outStream.write(buf, 0, size);
        }
        outStream.close();
        return outStream.toByteArray();
    }

    public static final byte[] deflate(byte[] in) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(in.length / 5);
        DeflaterOutputStream outStream = new DeflaterOutputStream(byteOut);
        try {
            outStream.write(in);
        }
        catch (Exception e) {
            LOG.error("Error compressing: ", (Throwable)e);
        }
        try {
            outStream.close();
        }
        catch (IOException e) {
            LOG.error("Error closing: ", (Throwable)e);
        }
        return byteOut.toByteArray();
    }
}

