/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema;

import java.util.Map;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.WritableSchema;

public class ContentRepositorySchema
extends BaseSchema
implements WritableSchema {
    public static final String CONTENT_REPOSITORY_IMPLEMENTATION = "implementation";
    public static final String CONTENT_CLAIM_MAX_APPENDABLE_SIZE_KEY = "content claim max appendable size";
    public static final String CONTENT_CLAIM_MAX_FLOW_FILES_KEY = "content claim max flow files";
    public static final String CONTENT_REPO_ARCHIVE_ENABLED_KEY = "content repository archive enabled";
    public static final String CONTENT_REPO_ARCHIVE_MAX_RETENTION_PERIOD_KEY = "content repository archive max retention period";
    public static final String CONTENT_REPO_ARCHIVE_MAX_USAGE_PERCENTAGE_KEY = "content repository archive max usage percentage";
    public static final String DEFAULT_CONTENT_REPOSITORY_IMPLEMENTATION = "org.apache.nifi.controller.repository.FileSystemRepository";
    public static final String DEFAULT_CONTENT_CLAIM_MAX_APPENDABLE_SIZE = "10 MB";
    public static final int DEFAULT_CONTENT_CLAIM_MAX_FLOW_FILES = 100;
    public static final boolean DEFAULT_CONTENT_REPO_ARCHIVE_ENABLED = false;
    public static final String DEFAULT_CONTENT_REPO_ARCHIVE_MAX_RETENTION_PERIOD = "12 hours";
    public static final String DEFAULT_CONTENT_REPO_ARCHIVE_MAX_USAGE_PERCENTAGE = "50%";
    public static final boolean DEFAULT_ALWAYS_SYNC = false;
    private String contentRepository = "org.apache.nifi.controller.repository.FileSystemRepository";
    private String contentClaimMaxAppendableSize = "10 MB";
    private Number contentClaimMaxFlowFiles = 100;
    private Boolean contentRepoArchiveEnabled = false;
    private String contentRepoArchiveMaxRetentionPeriod = "12 hours";
    private String contentRepoArchiveMaxUsagePercentage = "50%";
    private Boolean alwaysSync = false;

    public ContentRepositorySchema() {
    }

    public ContentRepositorySchema(Map map) {
        this.contentRepository = this.getOptionalKeyAsType(map, CONTENT_REPOSITORY_IMPLEMENTATION, String.class, "Content Repository", DEFAULT_CONTENT_REPOSITORY_IMPLEMENTATION);
        this.contentClaimMaxAppendableSize = this.getOptionalKeyAsType(map, CONTENT_CLAIM_MAX_APPENDABLE_SIZE_KEY, String.class, "Content Repository", DEFAULT_CONTENT_CLAIM_MAX_APPENDABLE_SIZE);
        this.contentClaimMaxFlowFiles = this.getOptionalKeyAsType(map, CONTENT_CLAIM_MAX_FLOW_FILES_KEY, Number.class, "Content Repository", 100);
        this.contentRepoArchiveEnabled = this.getOptionalKeyAsType(map, CONTENT_REPO_ARCHIVE_ENABLED_KEY, Boolean.class, "Content Repository", false);
        this.contentRepoArchiveMaxRetentionPeriod = this.getOptionalKeyAsType(map, CONTENT_REPO_ARCHIVE_MAX_RETENTION_PERIOD_KEY, String.class, "Content Repository", DEFAULT_CONTENT_REPO_ARCHIVE_MAX_RETENTION_PERIOD);
        this.contentRepoArchiveMaxUsagePercentage = this.getOptionalKeyAsType(map, CONTENT_REPO_ARCHIVE_MAX_USAGE_PERCENTAGE_KEY, String.class, "Content Repository", DEFAULT_CONTENT_REPO_ARCHIVE_MAX_USAGE_PERCENTAGE);
        this.alwaysSync = this.getOptionalKeyAsType(map, "always sync", Boolean.class, "Content Repository", false);
    }

    @Override
    public Map<String, Object> toMap() {
        Map result = (Map)this.mapSupplier.get();
        result.put(CONTENT_REPOSITORY_IMPLEMENTATION, this.contentRepository);
        result.put(CONTENT_CLAIM_MAX_APPENDABLE_SIZE_KEY, this.contentClaimMaxAppendableSize);
        result.put(CONTENT_CLAIM_MAX_FLOW_FILES_KEY, this.contentClaimMaxFlowFiles);
        result.put(CONTENT_REPO_ARCHIVE_ENABLED_KEY, this.contentRepoArchiveEnabled);
        result.put(CONTENT_REPO_ARCHIVE_MAX_RETENTION_PERIOD_KEY, this.contentRepoArchiveMaxRetentionPeriod);
        result.put(CONTENT_REPO_ARCHIVE_MAX_USAGE_PERCENTAGE_KEY, this.contentRepoArchiveMaxUsagePercentage);
        result.put("always sync", this.alwaysSync);
        return result;
    }

    public String getContentRepository() {
        return this.contentRepository;
    }

    public String getContentClaimMaxAppendableSize() {
        return this.contentClaimMaxAppendableSize;
    }

    public Number getContentClaimMaxFlowFiles() {
        return this.contentClaimMaxFlowFiles;
    }

    public Boolean getContentRepoArchiveEnabled() {
        return this.contentRepoArchiveEnabled;
    }

    public String getContentRepoArchiveMaxRetentionPeriod() {
        return this.contentRepoArchiveMaxRetentionPeriod;
    }

    public String getContentRepoArchiveMaxUsagePercentage() {
        return this.contentRepoArchiveMaxUsagePercentage;
    }

    public boolean getAlwaysSync() {
        return this.alwaysSync;
    }
}

