/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.nifi.minifi.bootstrap.MiNiFiParameters;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.service.CurrentPortProvider;
import org.apache.nifi.minifi.bootstrap.service.GracefulShutdownParameterProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiCommandSender;
import org.apache.nifi.minifi.bootstrap.util.ProcessUtils;

public class ReloadService {
    private final BootstrapFileProvider bootstrapFileProvider;
    private final MiNiFiParameters miNiFiParameters;
    private final MiNiFiCommandSender miNiFiCommandSender;
    private static final String RELOAD_CMD = "RELOAD";
    private final CurrentPortProvider currentPortProvider;
    private final GracefulShutdownParameterProvider gracefulShutdownParameterProvider;
    private final RunMiNiFi runMiNiFi;
    private final ProcessUtils processUtils;

    public ReloadService(BootstrapFileProvider bootstrapFileProvider, MiNiFiParameters miNiFiParameters, MiNiFiCommandSender miNiFiCommandSender, CurrentPortProvider currentPortProvider, GracefulShutdownParameterProvider gracefulShutdownParameterProvider, RunMiNiFi runMiNiFi, ProcessUtils processUtils) {
        this.bootstrapFileProvider = bootstrapFileProvider;
        this.miNiFiParameters = miNiFiParameters;
        this.miNiFiCommandSender = miNiFiCommandSender;
        this.currentPortProvider = currentPortProvider;
        this.gracefulShutdownParameterProvider = gracefulShutdownParameterProvider;
        this.runMiNiFi = runMiNiFi;
        this.processUtils = processUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws IOException {
        File reloadLockFile = this.bootstrapFileProvider.getReloadLockFile();
        if (!reloadLockFile.exists()) {
            reloadLockFile.createNewFile();
        }
        long minifiPid = this.miNiFiParameters.getMinifiPid();
        try {
            Optional<String> commandResponse = this.miNiFiCommandSender.sendCommand(RELOAD_CMD, this.currentPortProvider.getCurrentPort(), new String[0]);
            if (commandResponse.filter(RELOAD_CMD::equals).isPresent()) {
                RunMiNiFi.DEFAULT_LOGGER.info("Apache MiNiFi has accepted the Reload Command and is reloading");
                if (minifiPid != -1L) {
                    this.processUtils.shutdownProcess(minifiPid, "MiNiFi has not finished shutting down after {} seconds as part of configuration reload. Killing process.", this.gracefulShutdownParameterProvider.getGracefulShutdownSeconds());
                    this.runMiNiFi.setReloading(true);
                    RunMiNiFi.DEFAULT_LOGGER.info("MiNiFi has finished shutting down and will be reloaded.");
                }
            } else {
                RunMiNiFi.DEFAULT_LOGGER.error("When sending RELOAD command to MiNiFi, got unexpected response {}.", commandResponse.orElse(null));
            }
        }
        catch (IOException e) {
            if (minifiPid == -1L) {
                RunMiNiFi.DEFAULT_LOGGER.error("No PID found for the MiNiFi process, so unable to kill process; The process should be killed manually.");
            } else {
                RunMiNiFi.DEFAULT_LOGGER.error("Will kill the MiNiFi Process with PID {}", (Object)minifiPid);
                this.processUtils.killProcessTree(minifiPid);
            }
        }
        finally {
            if (reloadLockFile.exists() && !reloadLockFile.delete()) {
                RunMiNiFi.DEFAULT_LOGGER.error("Failed to delete reload lock file {}; this file should be cleaned up manually", (Object)reloadLockFile);
            }
        }
    }
}

