/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.nifi.minifi.bootstrap.BootstrapCommand;
import org.apache.nifi.minifi.bootstrap.ConfigurationFileHolder;
import org.apache.nifi.minifi.bootstrap.MiNiFiParameters;
import org.apache.nifi.minifi.bootstrap.command.CommandRunnerFactory;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeCoordinator;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.service.CurrentPortProvider;
import org.apache.nifi.minifi.bootstrap.service.GracefulShutdownParameterProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiCommandSender;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiConfigurationChangeListener;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiExecCommandProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiStatusProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiStdLogHandler;
import org.apache.nifi.minifi.bootstrap.service.PeriodicStatusReporterManager;
import org.apache.nifi.minifi.bootstrap.service.ReloadService;
import org.apache.nifi.minifi.bootstrap.util.UnixProcessUtils;
import org.apache.nifi.minifi.commons.api.MiNiFiCommandState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunMiNiFi
implements ConfigurationFileHolder {
    public static final Logger CMD_LOGGER = LoggerFactory.getLogger((String)"org.apache.nifi.minifi.bootstrap.Command");
    public static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(RunMiNiFi.class);
    public static final String CONF_DIR_KEY = "conf.dir";
    public static final String MINIFI_CONFIG_FILE_KEY = "nifi.minifi.config";
    public static final String STATUS_FILE_PID_KEY = "pid";
    public static final int UNINITIALIZED = -1;
    private static final String STATUS_FILE_PORT_KEY = "port";
    private static final String STATUS_FILE_SECRET_KEY = "secret.key";
    private static final String ACKNOWLEDGE_OPERATION = "ACKNOWLEDGE_OPERATION";
    private static final String PROCESS_KILL_SUCCESS_CHECK_RETRIES_KEY = "process.kill.success.check.retries";
    private static final String PROCESS_KILL_SUCCESS_CHECK_RETRIES_DEFAULT = "30";
    private final BootstrapFileProvider bootstrapFileProvider;
    private final ConfigurationChangeCoordinator configurationChangeCoordinator;
    private final CommandRunnerFactory commandRunnerFactory;
    private final AtomicReference<ByteBuffer> currentConfigFileReference = new AtomicReference();
    private final MiNiFiParameters miNiFiParameters;
    private final PeriodicStatusReporterManager periodicStatusReporterManager;
    private final ReloadService reloadService;
    private volatile Boolean autoRestartNiFi = true;
    private volatile boolean nifiStarted;
    private final Lock startedLock = new ReentrantLock();
    private final AtomicBoolean reloading = new AtomicBoolean(false);
    private final AtomicBoolean commandInProgress = new AtomicBoolean(false);
    private final MiNiFiCommandSender miNiFiCommandSender;
    private final CurrentPortProvider currentPortProvider;
    private final ObjectMapper objectMapper;

    public RunMiNiFi(File bootstrapConfigFile) throws IOException {
        this.bootstrapFileProvider = new BootstrapFileProvider(bootstrapConfigFile);
        this.objectMapper = this.getObjectMapper();
        Properties properties = this.bootstrapFileProvider.getStatusProperties();
        Properties bootstrapProperties = this.bootstrapFileProvider.getBootstrapProperties();
        this.miNiFiParameters = new MiNiFiParameters(Optional.ofNullable(properties.getProperty(STATUS_FILE_PORT_KEY)).map(Integer::parseInt).orElse(-1), Optional.ofNullable(properties.getProperty(STATUS_FILE_PID_KEY)).map(Integer::parseInt).orElse(-1).intValue(), properties.getProperty(STATUS_FILE_SECRET_KEY));
        UnixProcessUtils processUtils = new UnixProcessUtils(Integer.parseInt(bootstrapProperties.getProperty(PROCESS_KILL_SUCCESS_CHECK_RETRIES_KEY, PROCESS_KILL_SUCCESS_CHECK_RETRIES_DEFAULT)));
        this.miNiFiCommandSender = new MiNiFiCommandSender(this.miNiFiParameters, this.objectMapper);
        MiNiFiStatusProvider miNiFiStatusProvider = new MiNiFiStatusProvider(this.miNiFiCommandSender, processUtils);
        this.periodicStatusReporterManager = new PeriodicStatusReporterManager(bootstrapProperties, miNiFiStatusProvider, this.miNiFiCommandSender, this.miNiFiParameters);
        MiNiFiConfigurationChangeListener configurationChangeListener = new MiNiFiConfigurationChangeListener(this, DEFAULT_LOGGER, this.bootstrapFileProvider);
        this.configurationChangeCoordinator = new ConfigurationChangeCoordinator(this.bootstrapFileProvider, this, Collections.singleton(configurationChangeListener));
        this.currentPortProvider = new CurrentPortProvider(this.miNiFiCommandSender, this.miNiFiParameters, processUtils);
        GracefulShutdownParameterProvider gracefulShutdownParameterProvider = new GracefulShutdownParameterProvider(this.bootstrapFileProvider);
        this.reloadService = new ReloadService(this.bootstrapFileProvider, this.miNiFiParameters, this.miNiFiCommandSender, this.currentPortProvider, gracefulShutdownParameterProvider, this, processUtils);
        this.commandRunnerFactory = new CommandRunnerFactory(this.miNiFiCommandSender, this.currentPortProvider, this.miNiFiParameters, miNiFiStatusProvider, this.periodicStatusReporterManager, this.bootstrapFileProvider, new MiNiFiStdLogHandler(), bootstrapConfigFile, this, gracefulShutdownParameterProvider, new MiNiFiExecCommandProvider(this.bootstrapFileProvider), processUtils, configurationChangeListener);
    }

    public int run(BootstrapCommand command, String ... args) {
        return this.commandRunnerFactory.getRunner(command).runCommand(args);
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 3) {
            RunMiNiFi.printUsage();
            return;
        }
        Optional<BootstrapCommand> cmd = BootstrapCommand.fromString(args[0]);
        if (!cmd.isPresent()) {
            RunMiNiFi.printUsage();
            return;
        }
        try {
            RunMiNiFi runMiNiFi = new RunMiNiFi(BootstrapFileProvider.getBootstrapConfFile());
            System.exit(runMiNiFi.run(cmd.get(), args));
        }
        catch (Exception e) {
            CMD_LOGGER.error("Exception happened during the bootstrap run, check logs for details");
            DEFAULT_LOGGER.error("", (Throwable)e);
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("java org.apache.nifi.minifi.bootstrap.RunMiNiFi <command> [options]");
        System.out.println();
        System.out.println("Valid commands include:");
        System.out.println();
        System.out.println("Start : Start a new instance of Apache MiNiFi");
        System.out.println("Stop : Stop a running instance of Apache MiNiFi");
        System.out.println("Restart : Stop Apache MiNiFi, if it is running, and then start a new instance");
        System.out.println("Status : Determine if there is a running instance of Apache MiNiFi");
        System.out.println("Dump : Write a Thread Dump to the file specified by [options], or to the log if no file is given");
        System.out.println("Run : Start a new instance of Apache MiNiFi and monitor the Process, restarting if the instance dies");
        System.out.println("FlowStatus : Get the status of the MiNiFi flow. For usage, read the System Admin Guide 'FlowStatus Query Options' section.");
        System.out.println();
    }

    public void setMiNiFiParameters(int port, String secretKey) throws IOException {
        if (Optional.ofNullable(secretKey).filter(key -> key.equals(this.miNiFiParameters.getSecretKey())).isPresent() && this.miNiFiParameters.getMiNiFiPort() == port) {
            DEFAULT_LOGGER.debug("secretKey and port match with the known one, nothing to update");
            return;
        }
        this.miNiFiParameters.setMiNiFiPort(port);
        this.miNiFiParameters.setSecretKey(secretKey);
        Properties minifiProps = new Properties();
        long minifiPid = this.miNiFiParameters.getMinifiPid();
        if (minifiPid != -1L) {
            minifiProps.setProperty(STATUS_FILE_PID_KEY, String.valueOf(minifiPid));
        }
        minifiProps.setProperty(STATUS_FILE_PORT_KEY, String.valueOf(port));
        minifiProps.setProperty(STATUS_FILE_SECRET_KEY, secretKey);
        File statusFile = this.bootstrapFileProvider.getStatusFile();
        try {
            this.bootstrapFileProvider.saveStatusProperties(minifiProps);
        }
        catch (IOException ioe) {
            DEFAULT_LOGGER.warn("Apache MiNiFi has started but failed to persist MiNiFi Port information to {}", (Object)statusFile.getAbsolutePath(), (Object)ioe);
        }
        CMD_LOGGER.info("The thread to run Apache MiNiFi is now running and listening for Bootstrap requests on port {}", (Object)port);
    }

    public void reload() throws IOException {
        this.reloadService.reload();
    }

    public void setNiFiStarted(boolean nifiStarted) {
        this.startedLock.lock();
        try {
            this.nifiStarted = nifiStarted;
        }
        finally {
            this.startedLock.unlock();
        }
    }

    public boolean isNiFiStarted() {
        this.startedLock.lock();
        try {
            boolean bl = this.nifiStarted;
            return bl;
        }
        finally {
            this.startedLock.unlock();
        }
    }

    public void shutdownChangeNotifier() {
        this.configurationChangeCoordinator.close();
    }

    public void sendAcknowledgeToMiNiFi(MiNiFiCommandState commandState) {
        try {
            if (this.commandInProgress.getAndSet(false)) {
                Integer currentPort = this.currentPortProvider.getCurrentPort();
                CMD_LOGGER.info("Sending acknowledge with state {} to MiNiFi on port {}", (Object)commandState, (Object)currentPort);
                this.miNiFiCommandSender.sendCommand(ACKNOWLEDGE_OPERATION, currentPort, commandState.name());
            }
        }
        catch (Exception e) {
            CMD_LOGGER.error("Failed to send Acknowledge to MiNiFi", (Throwable)e);
        }
    }

    public PeriodicStatusReporterManager getPeriodicStatusReporterManager() {
        return this.periodicStatusReporterManager;
    }

    public ConfigurationChangeCoordinator getConfigurationChangeCoordinator() {
        return this.configurationChangeCoordinator;
    }

    void setAutoRestartNiFi(boolean restart) {
        this.autoRestartNiFi = restart;
    }

    public Boolean isAutoRestartNiFi() {
        return this.autoRestartNiFi;
    }

    public boolean getReloading() {
        return this.reloading.get();
    }

    public void setReloading(boolean val) {
        this.reloading.set(val);
    }

    @Override
    public AtomicReference<ByteBuffer> getConfigFileReference() {
        return this.currentConfigFileReference;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper;
    }

    public void setCommandInProgress(boolean value) {
        this.commandInProgress.set(value);
    }
}

