/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.taglib.util;

import java.awt.Color;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.xml.XMLUtils;
import org.apache.myfaces.trinidadinternal.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TagUtils {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TagUtils.class);

    private TagUtils() {
    }

    public static ValueBinding getValueBinding(String valueBindingExpression) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application app = context.getApplication();
        ValueBinding vb = app.createValueBinding(valueBindingExpression);
        return vb;
    }

    public static void assertNotNull(Object object) {
        if (null == object) {
            throw new NullPointerException();
        }
    }

    public static String getString(String value) {
        return value;
    }

    public static boolean getBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public static int getInteger(String value) {
        return Integer.valueOf(value);
    }

    public static long getLong(String value) {
        return Long.valueOf(value);
    }

    public static double getDouble(String value) {
        return Double.valueOf(value);
    }

    public static float getFloat(String value) {
        return Float.valueOf(value).floatValue();
    }

    public static String[] getStringArray(String value) throws ParseException {
        return TagUtils._getTokensArray(value);
    }

    public static Set<String> getStringSet(Object value) throws ParseException {
        if (value == null) {
            return null;
        }
        return TagUtils._getTokensSet(value.toString());
    }

    public static List<String> getStringList(Object value) throws ParseException {
        if (value == null) {
            return null;
        }
        return TagUtils._getTokensList(value.toString());
    }

    public static Date getDate(String value) {
        return TagUtils._parseISODate(value);
    }

    public static Date getDateWithMaxTime(String value) {
        Date d = TagUtils._parseISODate(value);
        Calendar c = Calendar.getInstance();
        TimeZone tz = RequestContext.getCurrentInstance().getTimeZone();
        if (tz != null) {
            c.setTimeZone(tz);
        }
        c.setTime(d);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static Locale getLocale(String value) {
        return TagUtils._getLocale(value);
    }

    public static TimeZone getTimeZone(String value) {
        return DateUtils.getSupportedTimeZone(value);
    }

    public static boolean isValueReference(String expression) {
        int start;
        return null != expression && (start = expression.indexOf("#{")) >= 0 && expression.indexOf(125, start + 1) >= 0;
    }

    public static List<Color> getColorList(String value) throws ParseException {
        String[] tokenArray = TagUtils._getTokensArray(value);
        if (tokenArray == null) {
            return null;
        }
        ArrayList<Color> colorList = new ArrayList<Color>();
        for (int index = 0; index < tokenArray.length; ++index) {
            String colorCode = tokenArray[index];
            if (!colorCode.startsWith("#")) {
                throw new ParseException(_LOG.getMessage("COLOR_CODE_DOES_NOT_START_WITH_POUNDSIGN", new Object[]{colorCode, value}), value.indexOf(colorCode));
            }
            int rgb = Integer.parseInt(colorCode.substring(1), 16);
            colorList.add(new Color(rgb));
        }
        return colorList;
    }

    public static Color getColor(String value) throws ParseException {
        if (value == null) {
            return null;
        }
        String colorCode = value.toString();
        if (!colorCode.startsWith("#")) {
            throw new ParseException(_LOG.getMessage("COLOR_CODE_DOES_NOT_START_WITH_POUNDSIGN", new Object[]{colorCode, value}), 0);
        }
        int rgb = Integer.parseInt(colorCode.substring(1), 16);
        return new Color(rgb);
    }

    private static String[] _getTokensArray(String tokenComposite) throws ParseException {
        if (tokenComposite == null || "".equals(tokenComposite)) {
            return null;
        }
        return XMLUtils.parseNameTokens(tokenComposite);
    }

    private static Set<String> _getTokensSet(String tokenComposite) throws ParseException {
        if (tokenComposite == null || "".equals(tokenComposite)) {
            return null;
        }
        return XMLUtils.parseNameTokensAsSet(tokenComposite);
    }

    private static List<String> _getTokensList(String tokenComposite) throws ParseException {
        if (tokenComposite == null || "".equals(tokenComposite)) {
            return null;
        }
        return XMLUtils.parseNameTokensAsList(tokenComposite);
    }

    private static final Date _parseISODate(String stringValue) {
        try {
            return TagUtils._getDateFormat().parse(stringValue);
        }
        catch (ParseException pe) {
            _LOG.info("CANNOT_PARSE_VALUE_INTO_DATE_WITH_YYYY_MM_DD_PATTERN", (Object)stringValue);
            return null;
        }
    }

    private static Locale _getLocale(String locale) {
        String localeStr = locale.replace('-', '_');
        String[] tokens = localeStr.split("[_]", 3);
        Locale locl = null;
        if (tokens.length == 1) {
            locl = new Locale(tokens[0]);
        } else if (tokens.length == 2) {
            locl = new Locale(tokens[0], tokens[1]);
        } else if (tokens.length == 3) {
            locl = new Locale(tokens[0], tokens[1], tokens[2]);
        } else assert (tokens.length < 4);
        return locl;
    }

    private static DateFormat _getDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        TimeZone tz = RequestContext.getCurrentInstance().getTimeZone();
        if (tz != null) {
            sdf.setTimeZone(tz);
        }
        return sdf;
    }
}

