/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.xml;

import java.util.logging.Level;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.xml.sax.Locator;

public class ParseErrorUtils {
    public static void log(ParseContext context, String message, Exception e, Level verbosity, TrinidadLogger log) {
        log.log(verbosity, ParseErrorUtils.getErrorMessage(context, message), (Throwable)e);
    }

    public static void log(ParseContext context, String message, Exception e, int line, int column, String systemId, Level verbosity, TrinidadLogger log) {
        log.log(verbosity, ParseErrorUtils._getErrorMessage(message, line, column, systemId), (Throwable)e);
    }

    public static String getErrorMessage(ParseContext context, String message) {
        String systemId;
        int column;
        int line;
        Locator locator = context.getLocator();
        if (locator == null) {
            line = -1;
            column = -1;
            systemId = null;
        } else {
            line = locator.getLineNumber();
            column = locator.getColumnNumber();
            systemId = locator.getSystemId();
        }
        return ParseErrorUtils._getErrorMessage(message, line, column, systemId);
    }

    private static String _getErrorMessage(String message, int line, int column, String systemId) {
        String parseMessage = null;
        if (systemId != null) {
            parseMessage = systemId + ": ";
        }
        String append = line < 0 || column < 0 ? "Parsing error: " : "Parsing error, line " + line + ", column " + column + ": ";
        parseMessage = parseMessage == null ? append : parseMessage + append;
        if (message != null) {
            parseMessage = parseMessage + message;
        }
        return parseMessage;
    }
}

