/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.UIXTreeTable;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.SpecialColumnRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeTableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeUtils;

public class FocusColumnRenderer
extends SpecialColumnRenderer {
    protected String getHeaderText(FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        return arc.getTranslatedString("af_treeTable.FOCUS_COLUMN_HEADER");
    }

    protected String getHeaderStyleClass(TableRenderingContext tContext) {
        return "af|column::header-icon-format";
    }

    protected String getFormatType(FacesBean bean) {
        return "center";
    }

    protected void renderKids(FacesContext context, RenderingContext arc, TableRenderingContext trc, UIComponent column) throws IOException {
        TreeTableRenderingContext ttrc = (TreeTableRenderingContext)trc;
        ResponseWriter writer = context.getResponseWriter();
        UIXTreeTable hGrid = ttrc.getUIXTreeTable();
        Object focusRowKey = hGrid.getFocusRowKey();
        assert (focusRowKey != null);
        int focusPathSize = hGrid.getDepth(focusRowKey) + 1;
        if (hGrid.isContainer() && hGrid.getDepth() >= focusPathSize) {
            writer.startElement("a", null);
            if (FocusColumnRenderer.supportsNavigation(arc)) {
                String onclick = TreeUtils.callJSFocusNode((UIXHierarchy)hGrid, ttrc.getJSVarName());
                writer.writeURIAttribute("href", (Object)"#", null);
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
            this._renderFocusIcon(context, arc, arc.getTranslatedString("af_treeTable.FOCUS_TIP"));
            writer.endElement("a");
        }
    }

    private void _renderFocusIcon(FacesContext fc, RenderingContext arc, String altText) throws IOException {
        Icon icon = arc.getIcon("af|treeTable::focus-icon");
        if (icon != null) {
            OutputUtils.renderIcon(fc, arc, icon, altText, null, true);
        }
    }
}

