/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.dispatch;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.myfaces.trinidadinternal.config.dispatch.DispatchResponseConfiguratorImpl;

public class DispatchServletResponse
extends HttpServletResponseWrapper {
    private final HttpServletRequest _request;
    private static final Pattern _CONTENT_TYPE_PATTERN = Pattern.compile("([^;]+)(?:;charset=(.*))?");

    public DispatchServletResponse(ExternalContext ec) {
        super((HttpServletResponse)ec.getResponse());
        this._request = (HttpServletRequest)ec.getRequest();
    }

    public void setContentType(String contentTypeAndCharset) {
        Matcher matcher;
        if (this._request.getAttribute("javax.servlet.include.request_uri") == null && contentTypeAndCharset != null && (matcher = _CONTENT_TYPE_PATTERN.matcher(contentTypeAndCharset)).matches()) {
            String userAgent;
            String contentType = matcher.group(1);
            String charset = matcher.groupCount() > 1 ? matcher.group(2) : null;
            this._request.setAttribute(DispatchResponseConfiguratorImpl.__CONTENT_TYPE_KEY, (Object)contentType);
            if ("application/xhtml+xml".equals(contentType) && (userAgent = this._request.getHeader("User-agent")).indexOf("compatible; MSIE") != -1) {
                contentTypeAndCharset = "text/html";
                if (charset != null) {
                    contentTypeAndCharset = contentTypeAndCharset + ";charset=" + charset;
                }
            }
        }
        super.setContentType(contentTypeAndCharset);
    }
}

