/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent.parse;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.parse.IncludeNode;
import org.apache.myfaces.trinidadinternal.agent.parse.XMLConstants;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

class IncludeNodeParser
extends BaseNodeParser
implements XMLConstants {
    private String _src;
    private String _refId;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(IncludeNodeParser.class);

    IncludeNodeParser() {
    }

    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if (!"http://myfaces.apache.org/trinidad/agent/capabilities".equals(namespaceURI)) {
            throw new SAXParseException(_LOG.getMessage("INVALID_NAMESPACE", (Object)namespaceURI), context.getLocator());
        }
        String refId = attrs.getValue("refid");
        String src = attrs.getValue("src");
        if (refId == null && src == null || refId != null && refId.length() <= 0 || src != null && src.length() <= 0) {
            _LOG.warning("ELEMENT_MISSING_ATTRIBUTES", (Object)"include");
            return;
        }
        this._src = src;
        this._refId = refId;
    }

    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        URL srcUrl = this._getUrl(context, this._src);
        if (this._refId == null && srcUrl == null) {
            return null;
        }
        return new IncludeNode(this._refId, srcUrl);
    }

    private URL _getUrl(ParseContext context, String url) {
        if (url == null) {
            return null;
        }
        URL baseURL = (URL)context.getProperty("http://myfaces.apache.org/trinidad/agent/capabilities", "baseURL");
        try {
            if (baseURL != null) {
                return new URL(baseURL, url);
            }
            return new URL(url);
        }
        catch (MalformedURLException mue) {
            _LOG.warning("INVALID_CAPABILITY_DATA_URL", (Object)this._src);
            return null;
        }
    }
}

