/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.convert;

import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.FacesBeanImpl;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

final class ConverterUtils {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ConverterUtils.class);

    private ConverterUtils() {
    }

    static Object getComponentLabel(UIComponent component) {
        Object label = component.getAttributes().get("label");
        if (null == label) {
            label = component.getValueBinding("label");
        }
        return label;
    }

    static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    static FacesBean getFacesBean(final FacesBean.Type type) {
        FacesBeanImpl bean = new FacesBeanImpl(){

            public FacesBean.Type getType() {
                return type;
            }
        };
        return bean;
    }

    static void setValueBinding(FacesBean bean, String name, ValueBinding binding) {
        PropertyKey key = ConverterUtils._getPropertyKey(bean, name, true);
        bean.setValueBinding(key, binding);
    }

    static ValueBinding getValueBinding(FacesBean bean, String name) {
        PropertyKey key = ConverterUtils._getPropertyKey(bean, name, true);
        return bean.getValueBinding(key);
    }

    private static PropertyKey _getPropertyKey(FacesBean bean, String name, boolean isStrict) {
        ConverterUtils._assertNotNull(name, "attribute cannot be null");
        FacesBean.Type type = bean.getType();
        PropertyKey key = type.findKey(name);
        if (isStrict && key == null) {
            throw new IllegalArgumentException(_LOG.getMessage("INVALID_ATTRIBUTE_NAME", name));
        }
        return key;
    }

    private static void _assertNotNull(Object object, String message) {
        if (object == null) {
            if (message == null) {
                throw new NullPointerException();
            }
            throw new NullPointerException(message);
        }
    }
}

