/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UISuggest;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.apache.myfaces.tobago.model.SuggestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SuggestTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(SuggestTag.class);
    private ValueExpression filter;
    private ValueExpression delay;
    private ValueExpression markup;
    private MethodExpression suggestMethod;
    private ValueExpression minimumCharacters;
    private ValueExpression update;
    private ValueExpression totalCount;
    private ValueExpression maximumItems;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Suggest";
    }

    public String getRendererType() {
        return "Suggest";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UISuggest component = (UISuggest)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.filter != null) {
            if (!this.filter.isLiteralText()) {
                component.setValueExpression("filter", this.filter);
            } else {
                component.setFilter(SuggestFilter.parse(this.filter.getExpressionString()));
            }
        }
        if (this.delay != null) {
            if (!this.delay.isLiteralText()) {
                component.setValueExpression("delay", this.delay);
            } else {
                component.setDelay(Integer.parseInt(this.delay.getExpressionString()));
            }
        }
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.suggestMethod != null) {
            component.setSuggestMethodExpression(this.suggestMethod);
        }
        if (this.minimumCharacters != null) {
            if (!this.minimumCharacters.isLiteralText()) {
                component.setValueExpression("minimumCharacters", this.minimumCharacters);
            } else {
                component.setMinimumCharacters(Integer.parseInt(this.minimumCharacters.getExpressionString()));
            }
        }
        if (this.update != null) {
            if (!this.update.isLiteralText()) {
                component.setValueExpression("update", this.update);
            } else {
                component.setUpdate(Boolean.parseBoolean(this.update.getExpressionString()));
            }
        }
        if (this.totalCount != null) {
            if (!this.totalCount.isLiteralText()) {
                component.setValueExpression("totalCount", this.totalCount);
            } else {
                component.setTotalCount(Integer.parseInt(this.totalCount.getExpressionString()));
            }
        }
        if (this.maximumItems != null) {
            if (!this.maximumItems.isLiteralText()) {
                component.setValueExpression("maximumItems", this.maximumItems);
            } else {
                component.setMaximumItems(Integer.parseInt(this.maximumItems.getExpressionString()));
            }
        }
    }

    public ValueExpression getFilter() {
        return this.filter;
    }

    public void setFilter(ValueExpression filter) {
        this.filter = filter;
    }

    public ValueExpression getDelay() {
        return this.delay;
    }

    public void setDelay(ValueExpression delay) {
        this.delay = delay;
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public MethodExpression getSuggestMethod() {
        return this.suggestMethod;
    }

    public void setSuggestMethod(MethodExpression suggestMethod) {
        this.suggestMethod = suggestMethod;
    }

    public ValueExpression getMinimumCharacters() {
        return this.minimumCharacters;
    }

    public void setMinimumCharacters(ValueExpression minimumCharacters) {
        this.minimumCharacters = minimumCharacters;
    }

    public ValueExpression getUpdate() {
        return this.update;
    }

    public void setUpdate(ValueExpression update) {
        this.update = update;
    }

    public ValueExpression getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(ValueExpression totalCount) {
        this.totalCount = totalCount;
    }

    public ValueExpression getMaximumItems() {
        return this.maximumItems;
    }

    public void setMaximumItems(ValueExpression maximumItems) {
        this.maximumItems = maximumItems;
    }

    public void release() {
        super.release();
        this.filter = null;
        this.delay = null;
        this.markup = null;
        this.suggestMethod = null;
        this.minimumCharacters = null;
        this.update = null;
        this.totalCount = null;
        this.maximumItems = null;
    }
}

