/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.annotation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.annotation.AnnotationInfo;
import org.apache.myfaces.orchestra.conversation.annotations.ConversationName;
import org.apache.myfaces.orchestra.conversation.annotations.ConversationRequire;
import org.apache.myfaces.orchestra.viewController.annotations.InitView;
import org.apache.myfaces.orchestra.viewController.annotations.PreProcess;
import org.apache.myfaces.orchestra.viewController.annotations.PreRenderView;
import org.apache.myfaces.orchestra.viewController.annotations.ViewController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInfoManager {
    private final Log log = LogFactory.getLog(AnnotationInfoManager.class);
    private Map<String, AnnotationInfo> annotationsInfoByName = new HashMap<String, AnnotationInfo>();
    private Map<String, AnnotationInfo> annotationsInfoByViewId = new HashMap<String, AnnotationInfo>();

    protected void addAnnotationsInfo(AnnotationInfo annotationInfo) {
        if (this.annotationsInfoByName.containsKey(annotationInfo.getBeanName()) && this.log.isInfoEnabled()) {
            this.log.info((Object)("duplicate bean definition: " + annotationInfo.getBeanName()));
        }
        this.annotationsInfoByName.put(annotationInfo.getBeanName(), annotationInfo);
        ViewController viewController = annotationInfo.getViewController();
        if (viewController != null) {
            String[] viewIds = viewController.viewIds();
            for (int i = 0; i < viewIds.length; ++i) {
                String viewId = viewIds[i];
                if (this.log.isInfoEnabled() && this.annotationsInfoByViewId.containsKey(annotationInfo.getBeanName())) {
                    this.log.info((Object)("duplicate viewId definition: " + annotationInfo.getBeanName()));
                }
                this.annotationsInfoByViewId.put(viewId, annotationInfo);
            }
        }
    }

    public AnnotationInfo getAnnotationInfoByBeanName(String beanName) {
        return this.annotationsInfoByName.get(beanName);
    }

    public AnnotationInfo getAnnotationInfoByViewId(String viewId) {
        return this.annotationsInfoByViewId.get(viewId);
    }

    public void processBeanAnnotations(String beanName, Class<?> clazz) {
        ConversationName conversationName = clazz.getAnnotation(ConversationName.class);
        ViewController viewController = clazz.getAnnotation(ViewController.class);
        ConversationRequire conversationRequire = clazz.getAnnotation(ConversationRequire.class);
        if (conversationName == null && viewController == null && conversationRequire == null) {
            return;
        }
        AnnotationInfo annotationInfo = new AnnotationInfo(beanName, clazz);
        annotationInfo.setConversationName(conversationName);
        annotationInfo.setConversationRequire(conversationRequire);
        if (viewController != null) {
            annotationInfo.setViewController(viewController);
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method.isAnnotationPresent(InitView.class)) {
                    annotationInfo.setInitViewMethod(method);
                }
                if (method.isAnnotationPresent(PreProcess.class)) {
                    annotationInfo.setPreProcessMethod(method);
                }
                if (!method.isAnnotationPresent(PreRenderView.class)) continue;
                annotationInfo.setPreRenderViewMethod(method);
            }
        }
        this.addAnnotationsInfo(annotationInfo);
    }
}

