/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.CustomInformation;
import org.apache.myfaces.extensions.validator.core.ExtValContextInternals;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.InvocationOrderComparator;
import org.apache.myfaces.extensions.validator.core.ValidationModuleAware;
import org.apache.myfaces.extensions.validator.core.ValidationModuleKey;
import org.apache.myfaces.extensions.validator.core.initializer.component.ComponentInitializer;
import org.apache.myfaces.extensions.validator.core.interceptor.MetaDataExtractionInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.PropertyValidationInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.ValidationExceptionInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.ViewRootInterceptor;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
class ExtValContextInvocationOrderAwareInternals {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private List<MetaDataExtractionInterceptor> metaDataExtractionInterceptors = null;
    private Map<Class, List<MetaDataExtractionInterceptor>> moduleSpecificMetaDataExtractionInterceptors = null;
    private List<ValidationExceptionInterceptor> validationExceptionInterceptors = null;
    private List<PropertyValidationInterceptor> propertyValidationInterceptors = null;
    private Map<Class, List<PropertyValidationInterceptor>> moduleSpecificPropertyValidationInterceptors = null;
    private List<ComponentInitializer> componentInitializers = null;
    private List<ViewRootInterceptor> viewRootInterceptors = null;
    private ExtValContextInternals contextHelper;

    ExtValContextInvocationOrderAwareInternals(ExtValContextInternals contextHelper) {
        this.contextHelper = contextHelper;
    }

    void addComponentInitializer(ComponentInitializer componentInitializer) {
        this.componentInitializers.add(componentInitializer);
        this.sortComponentInitializers();
    }

    List<ComponentInitializer> getComponentInitializers() {
        return this.contextHelper.isComponentInitializationActivated() ? this.componentInitializers : new CopyOnWriteArrayList<ComponentInitializer>();
    }

    void addValidationExceptionInterceptor(ValidationExceptionInterceptor validationExceptionInterceptor) {
        this.validationExceptionInterceptors.add(validationExceptionInterceptor);
        this.sortValidationExceptionInterceptors();
    }

    List<ValidationExceptionInterceptor> getValidationExceptionInterceptors() {
        return this.validationExceptionInterceptors;
    }

    void addPropertyValidationInterceptor(PropertyValidationInterceptor propertyValidationInterceptor) {
        if (propertyValidationInterceptor instanceof ValidationModuleAware) {
            this.addPropertyValidationInterceptorForModules(propertyValidationInterceptor);
            this.sortModuleSpecificPropertyValidationInterceptors();
        } else {
            this.addPropertyValidationInterceptorForModule(null, propertyValidationInterceptor);
            this.sortPropertyValidationInterceptors();
        }
    }

    List<PropertyValidationInterceptor> getPropertyValidationInterceptors() {
        return this.propertyValidationInterceptors;
    }

    List<PropertyValidationInterceptor> getPropertyValidationInterceptorsFor(Class moduleKey) {
        ArrayList<PropertyValidationInterceptor> result = new ArrayList<PropertyValidationInterceptor>();
        result.addAll(this.getPropertyValidationInterceptors());
        if (moduleKey != null && this.moduleSpecificPropertyValidationInterceptors.containsKey(moduleKey)) {
            result.addAll((Collection<PropertyValidationInterceptor>)this.moduleSpecificPropertyValidationInterceptors.get(moduleKey));
        }
        return this.sortPropertyValidationInterceptorList(result);
    }

    private void addPropertyValidationInterceptorForModules(PropertyValidationInterceptor propertyValidationInterceptor) {
        for (String currentModuleKey : ((ValidationModuleAware)((Object)propertyValidationInterceptor)).getModuleKeys()) {
            Class moduleKey = ClassUtils.tryToLoadClassForName(currentModuleKey);
            if (moduleKey == null) continue;
            this.addPropertyValidationInterceptorForModule(moduleKey, propertyValidationInterceptor);
        }
    }

    private void addPropertyValidationInterceptorForModule(Class moduleKey, PropertyValidationInterceptor propertyValidationInterceptor) {
        if (moduleKey == null) {
            this.propertyValidationInterceptors.add(propertyValidationInterceptor);
            this.logger.finest(propertyValidationInterceptor.getClass().getName() + " added as global interceptor");
        } else {
            List<Object> propertyValidationInterceptorList;
            if (this.moduleSpecificPropertyValidationInterceptors.containsKey(moduleKey)) {
                propertyValidationInterceptorList = this.moduleSpecificPropertyValidationInterceptors.get(moduleKey);
            } else {
                propertyValidationInterceptorList = new CopyOnWriteArrayList();
                this.moduleSpecificPropertyValidationInterceptors.put(moduleKey, propertyValidationInterceptorList);
            }
            propertyValidationInterceptorList.add(propertyValidationInterceptor);
            this.logger.finest(propertyValidationInterceptor.getClass().getName() + " added for " + moduleKey.getName());
        }
    }

    void addMetaDataExtractionInterceptor(MetaDataExtractionInterceptor metaDataExtractionInterceptor) {
        if (metaDataExtractionInterceptor instanceof ValidationModuleAware) {
            this.addMetaDataExtractionInterceptorForModules(metaDataExtractionInterceptor);
            this.sortModuleSpecificMetaDataExtractionInterceptors();
        } else {
            this.addMetaDataExtractionInterceptorForModule(null, metaDataExtractionInterceptor);
            this.sortMetaDataExtractionInterceptors();
        }
    }

    private void addMetaDataExtractionInterceptorForModules(MetaDataExtractionInterceptor metaDataExtractionInterceptor) {
        for (String currentModuleKey : ((ValidationModuleAware)((Object)metaDataExtractionInterceptor)).getModuleKeys()) {
            Class moduleKey = ClassUtils.tryToLoadClassForName(currentModuleKey);
            if (moduleKey == null) continue;
            this.addMetaDataExtractionInterceptorForModule(moduleKey, metaDataExtractionInterceptor);
        }
    }

    private void addMetaDataExtractionInterceptorForModule(Class moduleKey, MetaDataExtractionInterceptor metaDataExtractionInterceptor) {
        if (moduleKey == null) {
            this.metaDataExtractionInterceptors.add(metaDataExtractionInterceptor);
            this.logger.finest(metaDataExtractionInterceptor.getClass().getName() + " added as global interceptor");
        } else {
            List<Object> metaDataExtractionInterceptorList;
            if (this.moduleSpecificMetaDataExtractionInterceptors.containsKey(moduleKey)) {
                metaDataExtractionInterceptorList = this.moduleSpecificMetaDataExtractionInterceptors.get(moduleKey);
            } else {
                metaDataExtractionInterceptorList = new CopyOnWriteArrayList();
                this.moduleSpecificMetaDataExtractionInterceptors.put(moduleKey, metaDataExtractionInterceptorList);
            }
            metaDataExtractionInterceptorList.add(metaDataExtractionInterceptor);
            this.logger.finest(metaDataExtractionInterceptor.getClass().getName() + " added for " + moduleKey.getName());
        }
    }

    List<MetaDataExtractionInterceptor> getMetaDataExtractionInterceptors() {
        return this.metaDataExtractionInterceptors;
    }

    List<MetaDataExtractionInterceptor> getMetaDataExtractionInterceptorsWith(Map<String, Object> properties) {
        ArrayList<MetaDataExtractionInterceptor> result = new ArrayList<MetaDataExtractionInterceptor>();
        result.addAll(this.getMetaDataExtractionInterceptors());
        Class moduleKey = this.tryToResolveModuleKey(properties);
        if (moduleKey != null && this.moduleSpecificMetaDataExtractionInterceptors.containsKey(moduleKey)) {
            result.addAll((Collection<MetaDataExtractionInterceptor>)this.moduleSpecificMetaDataExtractionInterceptors.get(moduleKey));
        }
        return this.sortMetaDataExtractionInterceptorList(result);
    }

    private Class tryToResolveModuleKey(Map<String, Object> properties) {
        Object foundValue;
        Class moduleKey = null;
        if (properties != null && properties.containsKey(ValidationModuleKey.class.getName()) && (foundValue = properties.get(ValidationModuleKey.class.getName())) instanceof Class) {
            moduleKey = (Class)foundValue;
        }
        return moduleKey;
    }

    void lazyInitValidationExceptionInterceptors() {
        if (this.validationExceptionInterceptors != null) {
            return;
        }
        this.validationExceptionInterceptors = new CopyOnWriteArrayList<ValidationExceptionInterceptor>();
        ArrayList<String> validationExceptionInterceptorClassNames = new ArrayList<String>();
        validationExceptionInterceptorClassNames.add(ExtValCoreConfiguration.get().customValidationExceptionInterceptorClassName());
        validationExceptionInterceptorClassNames.add(this.contextHelper.getInformationProviderBean().get(CustomInformation.VALIDATION_EXCEPTION_INTERCEPTOR));
        for (String validationExceptionInterceptorName : validationExceptionInterceptorClassNames) {
            ValidationExceptionInterceptor validationExceptionInterceptor = (ValidationExceptionInterceptor)ClassUtils.tryToInstantiateClassForName(validationExceptionInterceptorName);
            if (validationExceptionInterceptor == null) continue;
            this.validationExceptionInterceptors.add(validationExceptionInterceptor);
            this.logger.finest(validationExceptionInterceptor.getClass().getName() + " added");
        }
    }

    void lazyInitMetaDataExtractionInterceptors() {
        if (this.metaDataExtractionInterceptors != null) {
            return;
        }
        this.metaDataExtractionInterceptors = new CopyOnWriteArrayList<MetaDataExtractionInterceptor>();
        this.moduleSpecificMetaDataExtractionInterceptors = new ConcurrentHashMap<Class, List<MetaDataExtractionInterceptor>>();
        ArrayList<String> metaDataExtractionInterceptorClassNames = new ArrayList<String>();
        metaDataExtractionInterceptorClassNames.add(ExtValCoreConfiguration.get().customMetaDataExtractionInterceptorClassName());
        metaDataExtractionInterceptorClassNames.add(this.contextHelper.getInformationProviderBean().get(CustomInformation.META_DATA_EXTRACTION_INTERCEPTOR));
        for (String validationExceptionInterceptorName : metaDataExtractionInterceptorClassNames) {
            MetaDataExtractionInterceptor metaDataExtractionInterceptor = (MetaDataExtractionInterceptor)ClassUtils.tryToInstantiateClassForName(validationExceptionInterceptorName);
            if (metaDataExtractionInterceptor == null) continue;
            this.addMetaDataExtractionInterceptor(metaDataExtractionInterceptor);
        }
    }

    void lazyInitComponentInitializers() {
        if (this.componentInitializers != null) {
            return;
        }
        this.componentInitializers = new CopyOnWriteArrayList<ComponentInitializer>();
        ArrayList<String> componentInitializerClassNames = new ArrayList<String>();
        componentInitializerClassNames.add(ExtValCoreConfiguration.get().customComponentInitializerClassName());
        componentInitializerClassNames.add(this.contextHelper.getInformationProviderBean().get(CustomInformation.COMPONENT_INITIALIZER));
        for (String componentInitializerName : componentInitializerClassNames) {
            ComponentInitializer componentInitializer = (ComponentInitializer)ClassUtils.tryToInstantiateClassForName(componentInitializerName);
            if (componentInitializer == null) continue;
            this.componentInitializers.add(componentInitializer);
            this.logger.finest(componentInitializer.getClass().getName() + " added");
        }
    }

    void lazyInitPropertyValidationInterceptors() {
        if (this.propertyValidationInterceptors != null) {
            return;
        }
        this.propertyValidationInterceptors = new CopyOnWriteArrayList<PropertyValidationInterceptor>();
        this.moduleSpecificPropertyValidationInterceptors = new ConcurrentHashMap<Class, List<PropertyValidationInterceptor>>();
        ArrayList<String> validationInterceptorClassNames = new ArrayList<String>();
        validationInterceptorClassNames.add(ExtValCoreConfiguration.get().customPropertyValidationInterceptorClassName());
        validationInterceptorClassNames.add(this.contextHelper.getInformationProviderBean().get(CustomInformation.PROPERTY_VALIDATION_INTERCEPTOR));
        for (String validationInterceptorName : validationInterceptorClassNames) {
            PropertyValidationInterceptor propertyValidationInterceptor = (PropertyValidationInterceptor)ClassUtils.tryToInstantiateClassForName(validationInterceptorName);
            if (propertyValidationInterceptor == null) continue;
            if (propertyValidationInterceptor instanceof ValidationModuleAware) {
                this.addPropertyValidationInterceptorForModules(propertyValidationInterceptor);
                continue;
            }
            this.addPropertyValidationInterceptorForModule(null, propertyValidationInterceptor);
        }
    }

    private void sortComponentInitializers() {
        ArrayList<ComponentInitializer> componentInitializersToSort = new ArrayList<ComponentInitializer>(this.componentInitializers);
        Collections.sort(componentInitializersToSort, new InvocationOrderComparator());
        this.componentInitializers.clear();
        this.componentInitializers.addAll(componentInitializersToSort);
    }

    private void sortPropertyValidationInterceptors() {
        ArrayList<PropertyValidationInterceptor> propertyValidationInterceptorsToSort = new ArrayList<PropertyValidationInterceptor>(this.propertyValidationInterceptors);
        Collections.sort(propertyValidationInterceptorsToSort, new InvocationOrderComparator());
        this.propertyValidationInterceptors.clear();
        this.propertyValidationInterceptors.addAll(propertyValidationInterceptorsToSort);
    }

    private void sortModuleSpecificPropertyValidationInterceptors() {
        for (List<PropertyValidationInterceptor> propertyValidationInterceptorList : this.moduleSpecificPropertyValidationInterceptors.values()) {
            this.sortPropertyValidationInterceptorList(propertyValidationInterceptorList);
        }
    }

    private List<PropertyValidationInterceptor> sortPropertyValidationInterceptorList(List<PropertyValidationInterceptor> propertyValidationInterceptorList) {
        ArrayList<PropertyValidationInterceptor> propertyValidationInterceptorListToSort = new ArrayList<PropertyValidationInterceptor>(propertyValidationInterceptorList);
        Collections.sort(propertyValidationInterceptorListToSort, new InvocationOrderComparator());
        propertyValidationInterceptorList.clear();
        propertyValidationInterceptorList.addAll(propertyValidationInterceptorListToSort);
        return propertyValidationInterceptorList;
    }

    private void sortValidationExceptionInterceptors() {
        ArrayList<ValidationExceptionInterceptor> validationExceptionInterceptorsToSort = new ArrayList<ValidationExceptionInterceptor>(this.validationExceptionInterceptors);
        Collections.sort(validationExceptionInterceptorsToSort, new InvocationOrderComparator());
        this.validationExceptionInterceptors.clear();
        this.validationExceptionInterceptors.addAll(validationExceptionInterceptorsToSort);
    }

    private void sortMetaDataExtractionInterceptors() {
        ArrayList<MetaDataExtractionInterceptor> metaDataExtractionInterceptorsToSort = new ArrayList<MetaDataExtractionInterceptor>(this.metaDataExtractionInterceptors);
        Collections.sort(metaDataExtractionInterceptorsToSort, new InvocationOrderComparator());
        this.metaDataExtractionInterceptors.clear();
        this.metaDataExtractionInterceptors.addAll(metaDataExtractionInterceptorsToSort);
    }

    private void sortModuleSpecificMetaDataExtractionInterceptors() {
        for (List<MetaDataExtractionInterceptor> metaDataExtractionInterceptorList : this.moduleSpecificMetaDataExtractionInterceptors.values()) {
            this.sortMetaDataExtractionInterceptorList(metaDataExtractionInterceptorList);
        }
    }

    private List<MetaDataExtractionInterceptor> sortMetaDataExtractionInterceptorList(List<MetaDataExtractionInterceptor> metaDataExtractionInterceptorList) {
        ArrayList<MetaDataExtractionInterceptor> metaDataExtractionInterceptorListToSort = new ArrayList<MetaDataExtractionInterceptor>(metaDataExtractionInterceptorList);
        Collections.sort(metaDataExtractionInterceptorListToSort, new InvocationOrderComparator());
        metaDataExtractionInterceptorList.clear();
        metaDataExtractionInterceptorList.addAll(metaDataExtractionInterceptorListToSort);
        return metaDataExtractionInterceptorList;
    }

    void lazyInitViewRootInterceptors() {
        if (this.viewRootInterceptors != null) {
            return;
        }
        this.initViewRootInterceptors();
    }

    private synchronized void initViewRootInterceptors() {
        if (this.viewRootInterceptors != null) {
            return;
        }
        this.viewRootInterceptors = new CopyOnWriteArrayList<ViewRootInterceptor>();
        ArrayList<String> viewRootInterceptorClassNames = new ArrayList<String>();
        viewRootInterceptorClassNames.add(ExtValCoreConfiguration.get().customViewRootInterceptorClassName());
        viewRootInterceptorClassNames.add(this.contextHelper.getInformationProviderBean().get(CustomInformation.VIEW_ROOT_INTERCEPTOR));
        for (String viewRootInterceptorClassName : viewRootInterceptorClassNames) {
            ViewRootInterceptor viewRootInterceptor = (ViewRootInterceptor)ClassUtils.tryToInstantiateClassForName(viewRootInterceptorClassName);
            if (viewRootInterceptor == null) continue;
            this.addViewRootInterceptor(viewRootInterceptor);
        }
    }

    List<ViewRootInterceptor> getViewRootInterceptors() {
        return this.viewRootInterceptors;
    }

    public void addViewRootInterceptor(ViewRootInterceptor viewRootInterceptor) {
        this.viewRootInterceptors.add(viewRootInterceptor);
        this.sortViewRootInterceptors();
    }

    private void sortViewRootInterceptors() {
        ArrayList<ViewRootInterceptor> viewRootInterceptorsToSort = new ArrayList<ViewRootInterceptor>(this.viewRootInterceptors);
        Collections.sort(viewRootInterceptorsToSort, new InvocationOrderComparator());
        this.viewRootInterceptors.clear();
        this.viewRootInterceptors.addAll(viewRootInterceptorsToSort);
    }
}

