/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf2.impl.scope.view;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.bean.ViewScoped;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewScopedContext
implements Context,
SystemEventListener {
    private static final String COMPONENT_ID_MAP_NAME = "codi.componentIdMap";
    private static final String CREATIONAL_MAP_NAME = "codi.creationalInstanceMap";
    private static final String UNCHECKED = "unchecked";
    private boolean isJsfSubscribed = false;

    public <T> T get(Contextual<T> component) {
        Map<String, Object> viewMap;
        Map componentIdMap;
        if (component == null) {
            return null;
        }
        this.checkActive();
        if (!this.isJsfSubscribed) {
            FacesContext.getCurrentInstance().getApplication().subscribeToEvent(PreDestroyViewMapEvent.class, (SystemEventListener)this);
            this.isJsfSubscribed = true;
        }
        if ((componentIdMap = (Map)(viewMap = this.getViewMap()).get(COMPONENT_ID_MAP_NAME)) == null) {
            return null;
        }
        Object instance = componentIdMap.get(((PassivationCapable)component).getId());
        return (T)instance;
    }

    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        Object instance;
        if (!(component instanceof PassivationCapable)) {
            throw new IllegalStateException(component.toString() + " doesn't implement " + PassivationCapable.class.getName());
        }
        this.checkActive();
        Map<String, Object> viewMap = this.getViewMap();
        ConcurrentHashMap componentIdMap = (ConcurrentHashMap)viewMap.get(COMPONENT_ID_MAP_NAME);
        if (componentIdMap == null) {
            componentIdMap = new ConcurrentHashMap();
            viewMap.put(COMPONENT_ID_MAP_NAME, componentIdMap);
        }
        if ((instance = componentIdMap.get(((PassivationCapable)component).getId())) != null) {
            return (T)instance;
        }
        if (creationalContext == null) {
            return null;
        }
        instance = component.create(creationalContext);
        if (instance == null) {
            return null;
        }
        ConcurrentHashMap<String, CreationalContext<T>> creationalContextMap = (ConcurrentHashMap<String, CreationalContext<T>>)viewMap.get(CREATIONAL_MAP_NAME);
        if (creationalContextMap == null) {
            creationalContextMap = new ConcurrentHashMap<String, CreationalContext<T>>();
            viewMap.put(CREATIONAL_MAP_NAME, creationalContextMap);
        }
        componentIdMap.put(((PassivationCapable)component).getId(), instance);
        creationalContextMap.put(((PassivationCapable)component).getId(), creationalContext);
        return (T)instance;
    }

    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    public boolean isActive() {
        return this.getViewRoot() != null;
    }

    private void checkActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("WebBeans context with scope annotation @ViewScoped is not active with respect to the current thread");
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) {
        if (event instanceof PreDestroyViewMapEvent) {
            Map viewMap = ((UIViewRoot)event.getSource()).getViewMap();
            Map componentIdMap = (Map)viewMap.get(COMPONENT_ID_MAP_NAME);
            Map creationalContextMap = (Map)viewMap.get(CREATIONAL_MAP_NAME);
            if (componentIdMap != null) {
                BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
                for (Map.Entry componentEntry : componentIdMap.entrySet()) {
                    String beanId = (String)componentEntry.getKey();
                    Bean contextual = beanManager.getPassivationCapableBean(beanId);
                    Object instance = componentEntry.getValue();
                    CreationalContext creational = (CreationalContext)creationalContextMap.get(beanId);
                    contextual.destroy(instance, creational);
                }
            }
        }
    }

    protected UIViewRoot getViewRoot() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            return context.getViewRoot();
        }
        return null;
    }

    protected Map<String, Object> getViewMap() {
        UIViewRoot viewRoot = this.getViewRoot();
        if (viewRoot != null) {
            return viewRoot.getViewMap(true);
        }
        return null;
    }
}

