/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.scripting.impl.util;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.Typed;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.core.impl.util.UnmodifiableMap;
import org.apache.myfaces.extensions.cdi.scripting.api.LanguageManager;
import org.apache.myfaces.extensions.cdi.scripting.api.language.Language;
import org.apache.myfaces.extensions.cdi.scripting.impl.spi.ExternalExpressionInterpreter;
import org.apache.myfaces.extensions.cdi.scripting.impl.util.DefaultExternalExpressionInterpreter;
import org.apache.myfaces.extensions.cdi.scripting.impl.util.ExpressionLanguageSelectionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public abstract class ScriptingUtils {
    private static ThreadLocal<ScriptEngineManager> scriptEngineManagerCache = new ThreadLocal();

    private ScriptingUtils() {
    }

    public static ScriptEngineManager getCurrentScriptEngineManager() {
        ScriptEngineManager scriptEngineManager = scriptEngineManagerCache.get();
        if (scriptEngineManager == null) {
            scriptEngineManager = new ScriptEngineManager();
            scriptEngineManagerCache.set(scriptEngineManager);
        }
        return scriptEngineManager;
    }

    public static UnmodifiableMap<String, Object> createExpressionLanguageHelper() {
        return new ExpressionLanguageSelectionMap();
    }

    public static ExternalExpressionInterpreter resolveExternalExpressionInterpreter() {
        ExternalExpressionInterpreter externalExpressionInterpreter = (ExternalExpressionInterpreter)CodiUtils.getContextualReferenceByClass(ExternalExpressionInterpreter.class, (boolean)true, (Annotation[])new Annotation[0]);
        return externalExpressionInterpreter != null ? externalExpressionInterpreter : new DefaultExternalExpressionInterpreter();
    }

    public static ScriptEngine createScriptEngine(Class<? extends Language> language) {
        LanguageManager languageManager = (LanguageManager)CodiUtils.getContextualReferenceByClass(LanguageManager.class, (Annotation[])new Annotation[0]);
        String languageName = languageManager.getLanguageName(language);
        return ScriptingUtils.getCurrentScriptEngineManager().getEngineByName(languageName);
    }
}

