/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared;

import jakarta.el.ValueExpression;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectItem;
import jakarta.faces.component.UISelectItems;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.SelectItem;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.core.api.shared.SelectItemsUtil;
import org.apache.myfaces.core.api.shared.VarUtils;

public class SelectItemsIterator
implements Iterator<SelectItem> {
    private static final Logger log = Logger.getLogger(SelectItemsIterator.class.getName());
    private final Iterator<UIComponent> _children;
    private Iterator<?> _nestedItems;
    private SelectItem _nextItem;
    private UIComponent _currentComponent;
    private UISelectItems _currentUISelectItems;
    private Object _currentValue;
    private FacesContext _facesContext;

    public SelectItemsIterator(UIComponent selectItemsParent, FacesContext facesContext) {
        this._children = selectItemsParent.getChildCount() > 0 ? selectItemsParent.getChildren().iterator() : Collections.emptyIterator();
        this._facesContext = facesContext;
    }

    @Override
    public boolean hasNext() {
        if (this._nextItem != null) {
            return true;
        }
        if (this._nestedItems != null) {
            if (this._nestedItems.hasNext()) {
                return true;
            }
            this._nestedItems = null;
            this._currentComponent = null;
            this._currentValue = null;
        }
        if (this._children.hasNext()) {
            UIComponent child = this._children.next();
            while (!(child instanceof UISelectItem) && !(child instanceof UISelectItems)) {
                if (this._children.hasNext()) {
                    child = this._children.next();
                    continue;
                }
                return false;
            }
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                Object item = uiSelectItem.getValue();
                if (item == null) {
                    item = SelectItemsUtil.createSelectItem(uiSelectItem, SelectItem::new);
                } else if (!(item instanceof SelectItem)) {
                    ValueExpression expression = uiSelectItem.getValueExpression("value");
                    throw new IllegalArgumentException("ValueExpression '" + (expression == null ? null : expression.getExpressionString()) + "' of UISelectItem : " + ComponentUtils.getPathToComponent(child) + " does not reference an Object of type SelectItem");
                }
                this._nextItem = (SelectItem)item;
                this._currentComponent = child;
                this._currentValue = item;
                return true;
            }
            if (child instanceof UISelectItems) {
                Level level;
                this._currentUISelectItems = (UISelectItems)child;
                Object value = this._currentUISelectItems.getValue();
                this._currentComponent = child;
                if (value instanceof SelectItem) {
                    this._nextItem = (SelectItem)value;
                    return true;
                }
                if (value != null && value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    ArrayList<Object> items = new ArrayList<Object>(length);
                    for (int i = 0; i < length; ++i) {
                        items.add(Array.get(value, i));
                    }
                    this._nestedItems = items.iterator();
                    return this.hasNext();
                }
                if (value instanceof Iterable) {
                    this._nestedItems = ((Iterable)value).iterator();
                    return this.hasNext();
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    ArrayList<SelectItem> items = new ArrayList<SelectItem>(map.size());
                    for (Map.Entry entry : map.entrySet()) {
                        items.add(new SelectItem(entry.getValue(), entry.getKey().toString()));
                    }
                    this._nestedItems = items.iterator();
                    return this.hasNext();
                }
                Level level2 = level = this._facesContext.isProjectStage(ProjectStage.Production) ? Level.FINE : Level.WARNING;
                if (log.isLoggable(level)) {
                    ValueExpression expression = this._currentUISelectItems.getValueExpression("value");
                    log.log(level, "ValueExpression {0} of UISelectItems with component-path {1} does not reference an Object of type SelectItem, array, Iterable or Map, but of type: {2}", new Object[]{expression == null ? null : expression.getExpressionString(), ComponentUtils.getPathToComponent(child), value == null ? null : value.getClass().getName()});
                }
            } else {
                this._currentComponent = null;
                this._currentValue = null;
            }
        }
        return false;
    }

    @Override
    public SelectItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this._nextItem != null) {
            SelectItem value = this._nextItem;
            this._nextItem = null;
            return value;
        }
        if (this._nestedItems != null) {
            Object item = this._nestedItems.next();
            Map<String, Object> attributeMap = this._currentUISelectItems.getAttributes();
            String var = (String)attributeMap.get("var");
            return VarUtils.executeInScope(this._facesContext, var, item, () -> {
                if (item instanceof SelectItem) {
                    this._currentValue = null;
                    return SelectItemsUtil.updateSelectItem(this._currentUISelectItems, (SelectItem)item);
                }
                this._currentValue = item;
                return SelectItemsUtil.createSelectItem(this._currentUISelectItems, item, SelectItem::new);
            });
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public UIComponent getCurrentComponent() {
        return this._currentComponent;
    }

    public Object getCurrentValue() {
        return this._currentValue;
    }
}

