/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.util.List;

public abstract class HtmlRenderer
extends Renderer {
    public List<UIComponent> getChildren(UIComponent component) {
        if (component.getChildCount() == 0) {
            return null;
        }
        return component.getChildren();
    }

    public int getChildCount(UIComponent component) {
        return component.getChildCount();
    }

    protected String getActionUrl(FacesContext facesContext) {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        return viewHandler.getActionURL(facesContext, viewId);
    }

    protected void renderId(FacesContext context, UIComponent component) throws IOException {
        if (this.shouldRenderId(context, component)) {
            String clientId = this.getClientId(context, component);
            context.getResponseWriter().writeAttribute("id", clientId, "id");
        }
    }

    protected String getClientId(FacesContext context, UIComponent component) {
        return component.getClientId(context);
    }

    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        String id = component.getId();
        if (id == null) {
            return false;
        }
        return !id.startsWith("j_id");
    }

    protected boolean isCommonPropertiesOptimizationEnabled(FacesContext facesContext) {
        return false;
    }

    protected boolean isCommonEventsOptimizationEnabled(FacesContext facesContext) {
        return false;
    }
}

