/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import jakarta.faces.application.ResourceVisitOption;
import jakarta.faces.context.FacesContext;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.myfaces.resource.ContractResourceLoader;
import org.apache.myfaces.resource.ExternalContextResourceLoaderIterator;
import org.apache.myfaces.resource.ResourceMeta;
import org.apache.myfaces.resource.ResourceMetaImpl;

public class ExternalContextContractResourceLoader
extends ContractResourceLoader {
    protected static final Pattern VERSION_CHECKER = Pattern.compile("/\\p{Digit}+(_\\p{Digit}*)*/");
    protected static final Pattern RESOURCE_VERSION_CHECKER = Pattern.compile("/\\p{Digit}+(_\\p{Digit}*)*\\..*");

    public ExternalContextContractResourceLoader(String prefix) {
        super(prefix);
    }

    protected Set<String> getResourcePaths(String contractName, String path) {
        return FacesContext.getCurrentInstance().getExternalContext().getResourcePaths(this.getPrefix() + "/" + contractName + "/" + path);
    }

    @Override
    public String getResourceVersion(String path, String contractName) {
        String resourceVersion = null;
        Set<String> resourcePaths = this.getResourcePaths(contractName, (String)path);
        if (this.getPrefix() != null) {
            path = this.getPrefix() + "/" + (String)path;
        }
        if (null != resourcePaths && !resourcePaths.isEmpty()) {
            for (String resourcePath : resourcePaths) {
                String version = "";
                if (((String)path).length() < resourcePath.length()) {
                    version = resourcePath.substring(((String)path).length());
                }
                if (!RESOURCE_VERSION_CHECKER.matcher(version).matches()) continue;
                version = version.substring(1, version.lastIndexOf(46));
                if (resourceVersion == null) {
                    resourceVersion = version;
                    continue;
                }
                if (this.getVersionComparator().compare(resourceVersion, version) >= 0) continue;
                resourceVersion = version;
            }
            if (resourceVersion == null) {
                resourceVersion = "INVALID";
            }
        }
        return resourceVersion;
    }

    @Override
    public String getLibraryVersion(String path, String contractName) {
        String libraryVersion = null;
        Set<String> libraryPaths = this.getResourcePaths(contractName, (String)path);
        path = this.getPrefix() + "/" + (String)path;
        if (null != libraryPaths && !libraryPaths.isEmpty()) {
            for (String libraryPath : libraryPaths) {
                String version = "";
                if (((String)path).length() < libraryPath.length()) {
                    version = libraryPath.substring(((String)path).length());
                }
                if (!VERSION_CHECKER.matcher(version).matches()) continue;
                version = version.substring(1, version.length() - 1);
                if (libraryVersion == null) {
                    libraryVersion = version;
                    continue;
                }
                if (this.getVersionComparator().compare(libraryVersion, version) >= 0) continue;
                libraryVersion = version;
            }
        }
        return libraryVersion;
    }

    @Override
    public URL getResourceURL(ResourceMeta resourceMeta) {
        try {
            return FacesContext.getCurrentInstance().getExternalContext().getResource(this.getPrefix() + "/" + resourceMeta.getContractName() + "/" + resourceMeta.getResourceIdentifier());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public InputStream getResourceInputStream(ResourceMeta resourceMeta) {
        return FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream(this.getPrefix() + "/" + resourceMeta.getContractName() + "/" + resourceMeta.getResourceIdentifier());
    }

    @Override
    public ResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion, String contractName) {
        return new ResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion, contractName);
    }

    @Override
    public boolean libraryExists(String libraryName, String contractName) {
        block7: {
            String prefix = this.getPrefix();
            if (prefix != null && !prefix.isEmpty()) {
                try {
                    URL url = FacesContext.getCurrentInstance().getExternalContext().getResource(prefix + "/" + contractName + "/" + libraryName);
                    if (url != null) {
                        return true;
                    }
                    break block7;
                }
                catch (MalformedURLException e) {
                    return false;
                }
            }
            try {
                URL url = FacesContext.getCurrentInstance().getExternalContext().getResource(contractName + "/" + libraryName);
                if (url != null) {
                    return true;
                }
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public Iterator<String> iterator(FacesContext facesContext, String path, int maxDepth, ResourceVisitOption ... options) {
        Object basePath = path;
        String prefix = this.getPrefix();
        if (prefix != null) {
            basePath = prefix + "/" + (path.startsWith("/") ? path.substring(1) : path);
        }
        return new ExternalContextResourceLoaderIterator(facesContext, (String)basePath, maxDepth, options);
    }
}

