/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.search;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchKeywordContext;
import jakarta.faces.component.search.SearchKeywordResolver;
import jakarta.faces.component.search.UntargetableComponent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChildSearchKeywordResolver
extends SearchKeywordResolver {
    public static final String CHILD_KEYWORD = "child";
    private static final Pattern PATTERN = Pattern.compile("child\\((\\d+)\\)");

    public void resolve(SearchKeywordContext expressionContext, UIComponent current, String keyword) {
        Matcher matcher = PATTERN.matcher(keyword);
        if (matcher.matches()) {
            int childNumber = Integer.parseInt(matcher.group(1));
            if (childNumber + 1 > current.getChildCount()) {
                throw new FacesException("Component with clientId \"" + current.getClientId(expressionContext.getSearchExpressionContext().getFacesContext()) + "\" has fewer children as \"" + childNumber + "\". Expression: \"" + keyword + "\"");
            }
            int count = 0;
            for (int i = 0; i < current.getChildCount(); ++i) {
                if (!(current.getChildren().get(i) instanceof UntargetableComponent)) {
                    ++count;
                }
                if (count != childNumber + 1) continue;
                expressionContext.invokeContextCallback((UIComponent)current.getChildren().get(childNumber));
                break;
            }
            if (count < childNumber) {
                throw new FacesException("Component with clientId \"" + current.getClientId(expressionContext.getSearchExpressionContext().getFacesContext()) + "\" has fewer children as \"" + childNumber + "\". Expression: \"" + keyword + "\"");
            }
        } else {
            throw new FacesException("Expression does not match following pattern @child(n). Expression: \"" + keyword + "\"");
        }
    }

    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String command) {
        if (command.length() > 6 && command.substring(0, CHILD_KEYWORD.length()).equalsIgnoreCase(CHILD_KEYWORD)) {
            Matcher matcher = PATTERN.matcher(command);
            return matcher.matches();
        }
        return false;
    }

    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }

    public boolean isLeaf(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }
}

