/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.model;

import jakarta.faces.model.DataModel;
import jakarta.faces.model.DataModelEvent;
import jakarta.faces.model.DataModelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class IterableDataModel<E>
extends DataModel<E> {
    private int _rowIndex = -1;
    private Iterable<E> _iterable;
    private List<E> _list;
    private Iterator<E> _iterator;
    private int _count = -1;

    public IterableDataModel() {
    }

    public IterableDataModel(Iterable<E> iterable) {
        Assert.notNull(iterable, "iterable");
        this.setWrappedData(iterable);
    }

    @Override
    public int getRowCount() {
        return this._count;
    }

    @Override
    public E getRowData() {
        if (this._iterable == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this._list.get(this._rowIndex);
    }

    @Override
    public int getRowIndex() {
        return this._rowIndex;
    }

    @Override
    public Object getWrappedData() {
        return this._iterable;
    }

    @Override
    public boolean isRowAvailable() {
        return this._iterable != null && this._rowIndex >= 0 && this._rowIndex < this._list.size();
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + rowIndex);
        }
        int oldRowIndex = this._rowIndex;
        if (oldRowIndex < rowIndex) {
            for (int i = 0; i < rowIndex - oldRowIndex; ++i) {
                if (this._list == null) {
                    this._list = new ArrayList();
                }
                if (this._iterator == null && this._iterable != null) {
                    this._iterator = this._iterable.iterator();
                }
                if (this._iterator == null || !this._iterator.hasNext()) continue;
                this._list.add(this._iterator.next());
            }
        } else if (oldRowIndex == rowIndex || oldRowIndex > rowIndex) {
            // empty if block
        }
        this._rowIndex = rowIndex;
        if (this._iterable != null && oldRowIndex != this._rowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent(this, this._rowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this.setRowIndex(-1);
            this._iterable = null;
            this._count = -1;
        } else {
            this._iterable = (Iterable)data;
            this._rowIndex = -1;
            this.setRowIndex(0);
            this._count = data instanceof Set ? ((Set)data).size() : (data instanceof List ? ((List)data).size() : (data instanceof Map ? ((Map)data).size() : (data instanceof Collection ? ((Collection)data).size() : -1)));
        }
    }
}

