/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.search;

import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchKeywordContext;
import javax.faces.component.search.SearchKeywordResolver;
import javax.faces.component.search.UntargetableComponent;

public class NextSearchKeywordResolver
extends SearchKeywordResolver {
    public static final String NEXT_KEYWORD = "next";

    @Override
    public void resolve(SearchKeywordContext expressionContext, UIComponent current, String keyword) {
        List<UIComponent> children;
        int index;
        UIComponent parent = current.getParent();
        if (parent.getChildCount() > 1 && (index = (children = parent.getChildren()).indexOf(current)) < parent.getChildCount() - 1) {
            int nextIndex = -1;
            do {
                if (children.get(++index) instanceof UntargetableComponent) continue;
                nextIndex = index;
            } while (nextIndex == -1 && index < parent.getChildCount() - 1);
            if (nextIndex != -1) {
                expressionContext.invokeContextCallback(children.get(nextIndex));
            }
        }
        expressionContext.setKeywordResolved(true);
    }

    @Override
    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        return NEXT_KEYWORD.equalsIgnoreCase(keyword);
    }

    @Override
    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }

    @Override
    public boolean isLeaf(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }
}

