/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

public class FacesServletMapping {
    private String prefix;
    private String extension;
    private String exact;

    public static FacesServletMapping createPrefixMapping(String path) {
        FacesServletMapping mapping = new FacesServletMapping();
        mapping.setPrefix(path);
        return mapping;
    }

    public static FacesServletMapping createExtensionMapping(String extension) {
        FacesServletMapping mapping = new FacesServletMapping();
        mapping.setExtension(extension);
        return mapping;
    }

    public static FacesServletMapping createExactMapping(String exact) {
        FacesServletMapping mapping = new FacesServletMapping();
        mapping.setExact(exact);
        return mapping;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String path) {
        this.prefix = path;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isExtensionMapping() {
        return this.extension != null;
    }

    public boolean isPrefixMapping() {
        return this.prefix != null;
    }

    public String getUrlPattern() {
        if (this.isExtensionMapping()) {
            return '*' + this.extension;
        }
        return this.prefix + "/*";
    }

    public String getExact() {
        return this.exact;
    }

    public void setExact(String exact) {
        this.exact = exact;
    }

    public boolean isExactMapping() {
        return this.exact != null;
    }

    public String toString() {
        return "FacesServletMapping{prefix='" + this.prefix + '\'' + ", extension='" + this.extension + '\'' + ", exact='" + this.exact + '\'' + '}';
    }
}

