/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PdfCopy
extends PdfWriter {
    protected HashMap indirects;
    protected HashMap indirectMap;
    protected int currentObjectNum = 1;
    protected PdfReader reader;
    protected PdfIndirectReference acroForm;
    protected PdfIndirectReference topPageParent;
    protected ArrayList pageNumbersToRefs = new ArrayList();
    protected List newBookmarks;

    public PdfCopy(Document document, OutputStream os) throws DocumentException {
        super(new PdfDocument(), os);
        document.addDocListener(this.pdf);
        this.pdf.addWriter(this);
        this.indirectMap = new HashMap();
    }

    public void open() {
        super.open();
        this.topPageParent = this.getPdfIndirectReference();
        this.root.setLinearMode(this.topPageParent);
    }

    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber) {
        if (this.currentPdfReaderInstance != null) {
            if (this.currentPdfReaderInstance.getReader() != reader) {
                try {
                    this.currentPdfReaderInstance.getReader().close();
                    this.currentPdfReaderInstance.getReaderFile().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.currentPdfReaderInstance = reader.getPdfReaderInstance(this);
            }
        } else {
            this.currentPdfReaderInstance = reader.getPdfReaderInstance(this);
        }
        return this.currentPdfReaderInstance.getImportedPage(pageNumber);
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        PdfIndirectReference theRef;
        RefKey key = new RefKey(in);
        IndirectReferences iRef = (IndirectReferences)this.indirects.get(key);
        if (iRef != null) {
            theRef = iRef.getRef();
            if (iRef.getCopied()) {
                return theRef;
            }
        } else {
            theRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(theRef);
            this.indirects.put(key, iRef);
        }
        iRef.setCopied();
        PdfObject obj = this.copyObject(PdfReader.getPdfObjectRelease(in));
        this.addToBody(obj, theRef);
        return theRef;
    }

    protected PdfDictionary copyDictionary(PdfDictionary in) throws IOException, BadPdfFormatException {
        PdfDictionary out = new PdfDictionary();
        PdfName type = (PdfName)in.get(PdfName.TYPE);
        Iterator it = in.getKeys().iterator();
        while (it.hasNext()) {
            PdfName key = (PdfName)it.next();
            PdfObject value = in.get(key);
            if (type != null && PdfName.PAGE.equals(type)) {
                if (key.equals(PdfName.PARENT)) {
                    out.put(PdfName.PARENT, this.topPageParent);
                    continue;
                }
                if (key.equals(PdfName.B)) continue;
                out.put(key, this.copyObject(value));
                continue;
            }
            out.put(key, this.copyObject(value));
        }
        return out;
    }

    protected PdfStream copyStream(PRStream in) throws IOException, BadPdfFormatException {
        PRStream out = new PRStream(in, null);
        Iterator it = in.getKeys().iterator();
        while (it.hasNext()) {
            PdfName key = (PdfName)it.next();
            PdfObject value = in.get(key);
            out.put(key, this.copyObject(value));
        }
        return out;
    }

    protected PdfArray copyArray(PdfArray in) throws IOException, BadPdfFormatException {
        PdfArray out = new PdfArray();
        Iterator i = in.getArrayList().iterator();
        while (i.hasNext()) {
            PdfObject value = (PdfObject)i.next();
            out.add(this.copyObject(value));
        }
        return out;
    }

    protected PdfObject copyObject(PdfObject in) throws IOException, BadPdfFormatException {
        if (in == null) {
            return PdfNull.PDFNULL;
        }
        switch (in.type) {
            case 6: {
                return this.copyDictionary((PdfDictionary)in);
            }
            case 10: {
                return this.copyIndirect((PRIndirectReference)in);
            }
            case 5: {
                return this.copyArray((PdfArray)in);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return in;
            }
            case 7: {
                return this.copyStream((PRStream)in);
            }
        }
        if (in.type < 0) {
            String lit = ((PdfLiteral)in).toString();
            if (lit.equals("true") || lit.equals("false")) {
                return new PdfBoolean(lit);
            }
            return new PdfLiteral(lit);
        }
        System.out.println("CANNOT COPY type " + in.type);
        return null;
    }

    protected int setFromIPage(PdfImportedPage iPage) {
        int pageNum = iPage.getPageNumber();
        PdfReaderInstance inst = this.currentPdfReaderInstance = iPage.getPdfReaderInstance();
        this.reader = inst.getReader();
        this.setFromReader(this.reader);
        return pageNum;
    }

    protected void setFromReader(PdfReader reader) {
        this.reader = reader;
        this.indirects = (HashMap)this.indirectMap.get(reader);
        if (this.indirects == null) {
            this.indirects = new HashMap();
            this.indirectMap.put(reader, this.indirects);
            PdfDictionary catalog = reader.getCatalog();
            PRIndirectReference ref = (PRIndirectReference)catalog.get(PdfName.PAGES);
            this.indirects.put(new RefKey(ref), new IndirectReferences(this.topPageParent));
            ref = null;
            PdfObject o = catalog.get(PdfName.ACROFORM);
            if (o == null || o.type() != 10) {
                return;
            }
            ref = (PRIndirectReference)o;
            if (this.acroForm == null) {
                this.acroForm = this.body.getPdfIndirectReference();
            }
            this.indirects.put(new RefKey(ref), new IndirectReferences(this.acroForm));
        }
    }

    public void addPage(PdfImportedPage iPage) throws IOException, BadPdfFormatException {
        PdfIndirectReference pageRef;
        int pageNum = this.setFromIPage(iPage);
        PdfDictionary thePage = this.reader.getPageN(pageNum);
        PRIndirectReference origRef = this.reader.getPageOrigRef(pageNum);
        this.reader.releasePage(pageNum);
        RefKey key = new RefKey(origRef);
        IndirectReferences iRef = (IndirectReferences)this.indirects.get(key);
        if (iRef != null) {
            pageRef = iRef.getRef();
        } else {
            pageRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(pageRef);
            this.indirects.put(key, iRef);
        }
        this.pageReferences.add(pageRef);
        ++this.currentPageNumber;
        if (!iRef.getCopied()) {
            iRef.setCopied();
            PdfDictionary newPage = this.copyDictionary(thePage);
            newPage.put(PdfName.PARENT, this.topPageParent);
            this.addToBody((PdfObject)newPage, pageRef);
        }
        this.root.addPage(pageRef);
        this.pageNumbersToRefs.add(pageRef);
    }

    public PdfIndirectReference getPageReference(int page) {
        if (page < 0 || page > this.pageNumbersToRefs.size()) {
            throw new IllegalArgumentException("Invalid page number " + page);
        }
        return (PdfIndirectReference)this.pageNumbersToRefs.get(page - 1);
    }

    public void copyAcroForm(PdfReader reader) throws IOException, BadPdfFormatException {
        PdfIndirectReference myRef;
        this.setFromReader(reader);
        PdfDictionary catalog = reader.getCatalog();
        PRIndirectReference hisRef = null;
        PdfObject o = catalog.get(PdfName.ACROFORM);
        if (o != null && o.type() == 10) {
            hisRef = (PRIndirectReference)o;
        }
        if (hisRef == null) {
            return;
        }
        RefKey key = new RefKey(hisRef);
        IndirectReferences iRef = (IndirectReferences)this.indirects.get(key);
        if (iRef != null) {
            this.acroForm = myRef = iRef.getRef();
        } else {
            this.acroForm = myRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(myRef);
            this.indirects.put(key, iRef);
        }
        if (!iRef.getCopied()) {
            iRef.setCopied();
            PdfDictionary theForm = this.copyDictionary((PdfDictionary)PdfReader.getPdfObject(hisRef));
            this.addToBody((PdfObject)theForm, myRef);
        }
    }

    protected PdfDictionary getCatalog(PdfIndirectReference rootObj) {
        try {
            PdfDocument.PdfCatalog theCat = ((PdfDocument)this.document).getCatalog(rootObj);
            if (this.acroForm != null) {
                theCat.put(PdfName.ACROFORM, this.acroForm);
            }
            if (this.newBookmarks == null || this.newBookmarks.isEmpty()) {
                return theCat;
            }
            PdfDictionary top = new PdfDictionary();
            PdfIndirectReference topRef = this.getPdfIndirectReference();
            Object[] kids = SimpleBookmark.iterateOutlines(this, topRef, this.newBookmarks, false);
            top.put(PdfName.FIRST, (PdfIndirectReference)kids[0]);
            top.put(PdfName.LAST, (PdfIndirectReference)kids[1]);
            top.put(PdfName.COUNT, new PdfNumber((Integer)kids[2]));
            this.addToBody((PdfObject)top, topRef);
            theCat.put(PdfName.OUTLINES, topRef);
            return theCat;
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    public void setOutlines(List outlines) {
        this.newBookmarks = outlines;
    }

    public synchronized void close() {
        if (this.open) {
            PdfReaderInstance ri = this.currentPdfReaderInstance;
            this.pdf.close();
            super.close();
            if (ri != null) {
                try {
                    ri.getReader().close();
                    ri.getReaderFile().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    PdfIndirectReference add(PdfImage pdfImage, PdfIndirectReference fixedRef) throws PdfException {
        return null;
    }

    public PdfIndirectReference add(PdfOutline outline) {
        return null;
    }

    public void addAnnotation(PdfAnnotation annot) {
    }

    PdfIndirectReference add(PdfPage page, PdfContents contents) throws PdfException {
        return null;
    }

    public void freeReader(PdfReader reader) throws IOException {
        this.indirectMap.remove(reader);
        if (this.currentPdfReaderInstance != null && this.currentPdfReaderInstance.getReader() == reader) {
            try {
                this.currentPdfReaderInstance.getReader().close();
                this.currentPdfReaderInstance.getReaderFile().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.currentPdfReaderInstance = null;
        }
    }

    static class IndirectReferences {
        PdfIndirectReference theRef;
        boolean hasCopied;

        IndirectReferences(PdfIndirectReference ref) {
            this.theRef = ref;
            this.hasCopied = false;
        }

        void setCopied() {
            this.hasCopied = true;
        }

        boolean getCopied() {
            return this.hasCopied;
        }

        PdfIndirectReference getRef() {
            return this.theRef;
        }
    }

    protected static class RefKey {
        int num;
        int gen;

        RefKey(int num, int gen) {
            this.num = num;
            this.gen = gen;
        }

        RefKey(PdfIndirectReference ref) {
            this.num = ref.getNumber();
            this.gen = ref.getGeneration();
        }

        RefKey(PRIndirectReference ref) {
            this.num = ref.getNumber();
            this.gen = ref.getGeneration();
        }

        public int hashCode() {
            return (this.gen << 16) + this.num;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RefKey)) {
                return false;
            }
            RefKey other = (RefKey)o;
            return this.gen == other.gen && this.num == other.num;
        }

        public String toString() {
            return this.num + " " + this.gen;
        }
    }
}

